package jp.agentec.adf.net.http;


import jp.agentec.abook.abv.bl.common.log.Logger;

public class HttpDownloadNotification extends HttpDownloadSimpleNotification {
    private static final String TAG ="HttpDownloadNotification";
	protected String downloadFileName;
	protected String outputFileName;
	
	protected long fileSize;
	protected long downloadedSize;
	protected float downloadRate;
	private Object lock = new Object();
	
	protected static final String BraceL = "[";
	protected static final String BraceR = "]";
	protected static final String Delimiter = ", ";
	protected static final String Percent = "%";
	
	public HttpDownloadNotification(int downloaderId, String fileName, HttpDownloadState downloadState, Object customInformation) {
		super(downloadState, customInformation);
		
		this.downloadFileName = fileName;
		this.outputFileName = fileName;
		this.fileSize = 0;
		this.downloadedSize = 0;
		this.downloadRate = 0f;
		this.error = null;
	}
	
	public HttpDownloadNotification() {
	}

	public String getDownloadFileName() {
		return downloadFileName;
	}
	public String getOutputFileName() {
		return outputFileName;
	}
	public long getFileSize() {
		return fileSize;
	}
	public long getDownloadedSize() {
		return downloadedSize;
	}
	public float getDownloadRate() {
		return downloadRate;
	}
	public void setDownloadRate(float downloadRate) {
		this.downloadRate = downloadRate;
	}
	public void setFileSize(long fileSize) {
		this.fileSize = fileSize;
	}
	public void setDownloadedSize(long downloadedSize) {
		this.downloadedSize = downloadedSize;
	}
	public void addDownloadedSize(long downloadedSize) {
		synchronized (lock) {
			this.downloadedSize += downloadedSize;
			
			if (this.fileSize > 0 && this.downloadedSize > 0) {
				this.downloadRate = ((float)this.downloadedSize / this.fileSize) * 100;
			} else {
				this.downloadRate = 0f;
			}
		}
	}
	
	public boolean isDownloadCompleted() {
        if ( downloadRate != 100 ) {
            Logger.w(TAG, "Not DownloadCompleted :" +  "fileSize : " + this.fileSize + " downloadedSize : "
                    + this.downloadedSize + " downloadRate : " + downloadRate + " downloadFileName : " + downloadFileName);
        }
		return downloadRate == 100;
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		
		sb.append(getClass().getName());
		sb.append(BraceL);
		
		sb.append("downloadState:");
		sb.append(downloadState);
		sb.append(Delimiter);
		
		sb.append("downloadFileName:");
		sb.append(downloadFileName);
		sb.append(Delimiter);
		
		sb.append("outputFileName:");
		sb.append(outputFileName);
		sb.append(Delimiter);
		
		sb.append("downloaded:");
		sb.append(downloadedSize);
		sb.append("/");
		sb.append(fileSize);
		sb.append("bytes ");
		sb.append(getDownloadRate());
		sb.append(Percent);
		sb.append(Delimiter);
		
		sb.append("customInfomation:");
		sb.append(customInformation);
		sb.append(Delimiter);
		
		sb.append("Error:");
		sb.append(error);
		
		sb.append(BraceR);
		
		return sb.toString();
	}

}
