import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.imageio.ImageIO;

import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;


public class StringCheck {
	private static final String HTML_PATH_STR = "stringCheck.html";
	private static final String HTML_PATH_ARR = "arrayCheck.html";
	private static final String ARRAYS_XML = "arrays.xml";
	private static final String STRINGS_XML = "strings.xml";
	private static final String EMPTY = "★★EMPTY★★";
	private static final String bgcolor = "white";
	private static final boolean ONLY_PROBLEM = false;

	public static void main(String[] args) throws IOException {
		
		File current = new File(".");
		File baseDir = new File(FileUtil.getParentPath(FileUtil.getParentPath(current.getAbsolutePath())) + "ABVJE_Res_Default_Android\\res");

		execute(baseDir, STRINGS_XML, HTML_PATH_STR);
		
//		baseDir = new File(FileUtil.getParentPath(FileUtil.getParentPath(current.getAbsolutePath())) + "ABVJE_UI_Android\\res");
//
//		execute(baseDir, ARRAYS_XML, HTML_PATH_ARR);
	}

	public static void execute(File baseDir, String xmlFile, String output) throws FileNotFoundException, IOException {
		List<String> allNameList = new ArrayList<String>();
		List<String> dirList = Arrays.asList(new String[]{"values","values-ja","values-ko"});
		Map<String, String>[] valMap = (Map<String, String>[])new Map[dirList.size()];
		for (int i = 0; i < valMap.length; i++) {
			valMap[i] = new HashMap<String, String>();
		}
		for (int i = 0; i < dirList.size(); i++) {
			String dir = dirList.get(i);
			FileReader fr = new FileReader(baseDir + "\\" + dir + "\\" + xmlFile);
			BufferedReader br = new BufferedReader(fr);
			String line;
			while ((line=br.readLine()) != null) {
				String name = StringUtil.extractRegexString(line, "name=\"(.*?)\"", 1);
				if (name != null) {
					if (!allNameList.contains(name)) {
						allNameList.add(name);
					}
					String val = StringUtil.extractRegexString(line, ">(.*?)<\\/", 1);
					if (StringUtil.isNullOrEmpty(val)) {
						val = EMPTY;
					}
					valMap[i].put(name, val);
				}
			}
		}
		
		StringBuffer sb = new StringBuffer();
		sb.append("<html>\n");
		sb.append("<head>\n");
		sb.append("</head>\n");
		sb.append("<body bgcolor=\"" + bgcolor + "\" \"><table border=1>\n");
		sb.append("<tr>");
		sb.append("<td>");
		sb.append("key");
		sb.append("</td>");
		for (String dir : dirList) {
			sb.append("<td>");
			sb.append(dir);
			sb.append("</td>");
		}
		sb.append("</tr>\n");

		for (String key : allNameList) {
			if (ONLY_PROBLEM) {
				boolean set = true;
				for (int i = 0; i < dirList.size(); i++) {
					String val = valMap[i].get(key);
					if (val == null || val.equals(EMPTY)) {
						set = false;
						break;
					}
				}
				if (set) {
					continue;
				}
			}
			
			sb.append("<tr>");
			sb.append("<td>");
			sb.append(key);
			sb.append("</td>");
			for (int i = 0; i < dirList.size(); i++) {
				sb.append("<td>");
				String val = valMap[i].get(key);
				if (val == null) {
					val = "★★★★★";
				}
				else if (!dirList.get(i).equals("values-ja")) {
					if (containsJapanese(val)) {
						val = "★★★★★" + val;
					}
				}
				sb.append(val);
				sb.append("</td>");
			}
			sb.append("</tr>\n");
		}

		sb.append("</table></body></html>");

		FileWriter fw = new FileWriter(output);
		fw.write(sb.toString());
		fw.flush();
		fw.close();
	}

	private static BufferedImage loadImage(File file) {
		try {
			FileInputStream in = new FileInputStream(file);
			BufferedImage rv = ImageIO.read(in);
			in.close();
			return rv;
		} catch(IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	public static boolean containsJapanese(String str) {
		for(int i = 0 ; i < str.length() ; i++) {
			char ch = str.charAt(i);
			Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(ch);

			if (Character.UnicodeBlock.HIRAGANA.equals(unicodeBlock))
				return true;

			if (Character.UnicodeBlock.KATAKANA.equals(unicodeBlock) && ch != '・')
				return true;

			if (ch >= '｡' && ch <= 'ﾟ') { // 半角カタカナ
				return true;
			}
			
//			if (Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS.equals(unicodeBlock)) // 韓国語でも使われる
//				return true;

			if (Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(unicodeBlock))
				return true;

//			if (Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION.equals(unicodeBlock)) // 韓国語でも使われる
//				return true;
		}
		return false;
	}
}
