package jp.agentec.abook.abv.bl.data.dao;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CategoryDaoTest extends TestCase {

	private CategoryDao dao = AbstractDao.getDao(CategoryDao.class);

	public CategoryDaoTest(String string) {
		super(string);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper) sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite("CategoryDaoTest");
//		suite.addTest(new CategoryDaoTest("testInsertCategory"));
		suite.addTest(new CategoryDaoTest("testUpdateCategory"));
		return suite;
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void testInsertCategory(){
		dao.insertCategory(1, 0, 1, "root");
		dao.insertCategory(2, 1, 1, "child01");
		dao.insertCategory(3, 2, 1, "child02");
	}
	
	
	public void testUpdateCategory(){
		dao.updateCategory(1, 0, 1, "未指定");
		dao.updateCategory(2, 1, 1, "ジャンル01");
	}

}
