package jp.agentec.abook.abv.bl.data.dao;

import java.util.Date;
import java.util.List;
import java.util.UUID;

import jp.agentec.abook.abv.bl.common.db.SQLiteOpenHelper;
import jp.agentec.abook.abv.bl.common.db.impl.JDBCSQLiteOpenHelper;
import jp.agentec.abook.abv.bl.data.DBConnector;
import jp.agentec.abook.abv.bl.dto.ContentMemoDto;
import junit.framework.TestCase;

public class ContentMemoTest extends TestCase {

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		DBConnector conn = DBConnector.getInstance();
		SQLiteOpenHelper sqlLiteOpenHelper = new JDBCSQLiteOpenHelper("test.db", 0);
		conn.setSqlLiteOpenHelper(sqlLiteOpenHelper);
		((JDBCSQLiteOpenHelper)sqlLiteOpenHelper).onCreate(conn.getDatabase());
	}
	
	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
	}
	
	public void testInsertMemo() throws Exception {
		long contentId = 1000;
		ContentMemoDto dto = new ContentMemoDto();
		dto.contentId = contentId;
		dto.axisX = 100;
		dto.axisY = 100;
		dto.delFlg = false;
		dto.copyFlg = false;
		dto.insertDate = new Date(System.currentTimeMillis());
		dto.updateDate = new Date(System.currentTimeMillis());
		dto.memo = "新しいメモだよ";
		dto.pageNum = 1;
		dto.memoId = UUID.randomUUID().toString();
		
		ContentMemoDao dao = new ContentMemoDao();
		dao.insertMemo(dto);// 1回
		dao.insertMemo(dto);// 2回
		
		List<ContentMemoDto> list = dao.getMemoList(contentId);
		for (ContentMemoDto contentMemoDto : list) {
			System.out.println("testInsertMemo=" + contentMemoDto.toString());
		}
	}

}
