package jp.agentec.adf.core.formatter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import jp.agentec.adf.util.StringUtil;

import org.junit.Test;

public class PropertyNameFormatterTest {
	public static final String Delimiter = "_";
	
	public static final String s1 = "column_name";
	public static final String s2 = "test_column_name";
	public static final String s3 = StringUtil.Empty;
	public static final String s4 = null;
	public static final String s5 = "c";
	public static final String s6 = "c1";
	
	@Test
	public void testGeneratePropertyName() {
		String result = null;
		
		result = PropertyNameFormatter.generatePropertyNameFromDatabaseFieldName(s1, Delimiter);
		assertEquals(result, "columnName", result);
		
		result = PropertyNameFormatter.generatePropertyNameFromDatabaseFieldName(s2, Delimiter);
		assertEquals(result, "testColumnName", result);
		
		result = PropertyNameFormatter.generatePropertyNameFromDatabaseFieldName(s3, Delimiter);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generatePropertyNameFromDatabaseFieldName(s4, Delimiter);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generatePropertyNameFromDatabaseFieldName(s5, Delimiter);
		assertEquals(result, "c", result);
		
		result = PropertyNameFormatter.generatePropertyNameFromDatabaseFieldName(s6, Delimiter);
		assertEquals(result, "c1", result);
	}
	
	@Test
	public void testGeneratePropertyNameFromGetter() {
		String result = null;
		
		result = PropertyNameFormatter.generatePropertyNameFromGetter("getColumnName");
		assertEquals(result, "columnName", result);
		
		result = PropertyNameFormatter.generatePropertyNameFromGetter("getColumnName1");
		assertEquals(result, "columnName1", result);
		
		result = PropertyNameFormatter.generatePropertyNameFromGetter("setColumnName1");
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generatePropertyNameFromMethod("getColumnName1", PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, "columnName1", result);
		
//		PropertyNameFormatterTestObject obj = new PropertyNameFormatterTestObject();
//		String[] temp = PropertyNameFormatter.generatePropertyNamesFromObject(obj, PropertyNameFormatterTestObject.class);
//		
//		for (String s : temp) {
//			System.out.println(s);
//		}
		
		assertTrue(true);
	}
	
	@Test
	public void testGenerateDatabaseFieldNameFromPropertyName() {
		String result = null;
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromPropertyName("columnName", PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, s1, result);
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromPropertyName("testColumnName", PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, s2, result);
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromPropertyName(StringUtil.Empty, PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromPropertyName(null, PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromPropertyName("c1", PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, "c1", result);
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromPropertyName("c1A", PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, "c1_a", result);
	}
	
	@Test
	public void testGenerateDatabaseFieldNameFromGetter() {
		String result = null;
		
		result = PropertyNameFormatter.generateDatabaseFieldNameFromGetter("getColumnName", PropertyNameFormatter.DefaultGetterPrefix, PropertyNameFormatter.DefaultDelimiter);
		System.out.println(result);
		assertEquals(result, s1, result);
	}

	@Test
	public void testGenerateGetterName() {
		String result = null;
		
		result = PropertyNameFormatter.generateGetterName(s1, Delimiter);
		assertEquals(result, "getColumnName", result);
		
		result = PropertyNameFormatter.generateGetterName(s2, Delimiter);
		assertEquals(result, "getTestColumnName", result);
		
		result = PropertyNameFormatter.generateGetterName(s3, Delimiter);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateGetterName(s4, Delimiter);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateGetterName(s5, Delimiter);
		assertEquals(result, "getC", result);
		
		result = PropertyNameFormatter.generateGetterName(s6, Delimiter);
		assertEquals(result, "getC1", result);
	}

	@Test
	public void testGenerateSetterName() {
		String result = null;
		
		result = PropertyNameFormatter.generateSetterName(s1, Delimiter);
		assertEquals(result, "setColumnName", result);
		
		result = PropertyNameFormatter.generateSetterName(s2, Delimiter);
		assertEquals(result, "setTestColumnName", result);
		
		result = PropertyNameFormatter.generateSetterName(s3, Delimiter);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateSetterName(s4, Delimiter);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateSetterName(s5, Delimiter);
		assertEquals(result, "setC", result);
		
		result = PropertyNameFormatter.generateSetterName(s6, Delimiter);
		assertEquals(result, "setC1", result);
	}

	@Test
	public void testGenerateGetterSetterName() {
		String result = null;
		
		result = PropertyNameFormatter.generateGetterSetterName(s1, Delimiter, PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, "getColumnName", result);
		
		result = PropertyNameFormatter.generateGetterSetterName(s2, Delimiter, PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, "getTestColumnName", result);
		
		result = PropertyNameFormatter.generateGetterSetterName(s3, Delimiter, PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateGetterSetterName(s4, Delimiter, PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, StringUtil.Empty, result);
		
		result = PropertyNameFormatter.generateGetterSetterName(s5, Delimiter, PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, "getC", result);
		
		result = PropertyNameFormatter.generateGetterSetterName(s6, Delimiter, PropertyNameFormatter.DefaultGetterPrefix);
		assertEquals(result, "getC1", result);
	}

}
