package jp.agentec.adf.net.http;

import static org.junit.Assert.assertTrue;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;

import jp.agentec.abook.abv.bl.acms.client.parameters.AcmsContentCheckParameters;
import jp.agentec.adf.net.http.HttpDownloadState;
import jp.agentec.adf.net.http.HttpFileDownloader;
import jp.agentec.adf.net.http.HttpHeaderProperties;
import jp.agentec.adf.net.http.HttpHeaderProperties.PropertyKey;
import jp.agentec.adf.net.http.HttpParameterObject;
import jp.agentec.adf.net.http.HttpRequestSender;

import org.junit.Test;

public class HttpFileDownloaderTest {

	@Test
	public void testObserver() throws MalformedURLException, InterruptedException {
//		URL url = new URL("https://ia700505.us.archive.org/3/items/Windows7WildlifeSampleVideo/Wildlife_512kb_404.mp4");
//		String url = "https://ia700505.us.archive.org/3/items/Windows7WildlifeSampleVideo/Wildlife_512kb.mp4";
		String url = "https://web5.abook.bz/acms/dt/dl/contentZipFile/getContentForAndroid/1431/20e1eceed9676327ebf4a94f4768c333/2";

		HttpHeaderProperties prop = new HttpHeaderProperties();
		prop.addProperty(PropertyKey.UserAgent, "Android");

		HttpParameterObject param = new AcmsContentCheckParameters("hoge", 9877, 123);
		int startByte = 0;
//		int startByte = 1000;
		final HttpFileDownloader downloader = new HttpFileDownloader(url, param , prop, "contentDownload.zip", startByte, new Observer() {
			
			@Override
			public void update(Observable arg0, Object arg1) {
				System.out.println("update: " + arg1);
			}
		}, 1234L);
		downloader.downloadAsync();
		
		new Thread(new Runnable() {
			@Override
			public void run() {
				while (downloader.getNotification().isDownloading()) {
					System.out.println(downloader.getDownloadRate() + " : " + downloader.getNotification().getDownloadedSize());
					
					try {
						Thread.sleep(1000);
					} catch (InterruptedException e) {
					}
				}
			}
		}).start();

		while (downloader.getNotification().isDownloading()) {
			Thread.sleep(100);
		}

		System.out.println("before finish:" + downloader.getDownloadRate() + " : " + downloader.getNotification().getDownloadedSize());

		if (downloader.getError() != null) {
			downloader.getError().printStackTrace();
			assertTrue(false);
		}

		System.out.println("finished");
	}
	


	@Test
	public void testSync() throws MalformedURLException, InterruptedException {
		String url = "http://www.agentec.jp/product/abook_biz/index_img/Slide_img/topslideD1.png";

		HttpFileDownloader downloader = new HttpFileDownloader(url, null, "BizLightIcon.png");
		downloader.downloadSync();

		if (downloader.getError() != null) {
			downloader.getError().printStackTrace();
			assertTrue(false);
		}

		System.out.println("finished");
	}
	

	@Test
	public void testAsync() throws MalformedURLException, InterruptedException {
		String url = "http://www.agentec.jp/images/agentec-logo.png";

		HttpFileDownloader downloader = new HttpFileDownloader(url, null, "agentec.jpg");
		downloader.downloadAsync();
		while (downloader.getState() != HttpDownloadState.finished && downloader.getState() != HttpDownloadState.failed) {
			Thread.sleep(100);
		}

		if (downloader.getError() != null) {
			downloader.getError().printStackTrace();
			assertTrue(false);
		}

		System.out.println("finished");
	}
	

//	@Test
	public void testBackupFile() {
		String url;
		try {
			url = "http://demo35.agtplus.kr/acms/agentec/abvapi/getBackupFile/";
			
			GetBackupFileDownload param = new GetBackupFileDownload();
			param.setSid("41ffde706183225c4c3b6065f468d276");
			param.setFilename("3af78c-27504-c.jpg");
			param.setDeviceType("3");
			
			HttpHeaderProperties prop = new HttpHeaderProperties();
			prop.addProperty(PropertyKey.UserAgent, "Android");
			
			HttpFileDownloader downloader = new HttpFileDownloader(url, param, prop, "1.jpg", 0, null, null);
			downloader.setMethod("POST");
			
			while (downloader.getState() != HttpDownloadState.finished && downloader.getState() != HttpDownloadState.failed) {
				Thread.sleep(100);
			}
			
			if (downloader.getError() != null) {
				downloader.getError().printStackTrace();
				assertTrue(false);
			}
			
			System.out.println("finished");
			
		} catch (Exception e) {
			e.printStackTrace();
			assertTrue(false);
		}
		
		assertTrue(true);
	}
	
	public class GetBackupFileDownload extends HttpParameterObject {
		private String sid;
		private String filename;
		private String deviceType;
		public String getSid() {
			return sid;
		}
		public void setSid(String sid) {
			this.sid = sid;
		}
		public String getFilename() {
			return filename;
		}
		public void setFilename(String filename) {
			this.filename = filename;
		}
		public String getDeviceType() {
			return deviceType;
		}
		public void setDeviceType(String deviceType) {
			this.deviceType = deviceType;
		}
	}

//	@Test
//	public void unzip() {
//		try {
//			ZipFile zipFile = new ZipFile("c:\\Users\\macrojin\\Documents\\1\\1.zip");
//			if (zipFile.isEncrypted()) {
//				zipFile.setPassword("9DD0144CC2C92546F480DA49C3A111DB");
//			}
//			
//			zipFile.extractAll("c:\\Users\\macrojin\\Documents\\1");
//		} catch (ZipException e) {
//			e.printStackTrace();
//		}
//	}
}
