package jp.agentec.adf.util;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import jp.agentec.adf.util.StringUtil;

import org.junit.Test;

public class StringUtilTest {
	@Test
	public void testIsNullOrEmpty() {
		String s1 = null;
		String s2 = StringUtil.Empty;
		String s3 = "abc";
		
		assertTrue(StringUtil.isNullOrEmpty(s1));
		assertTrue(StringUtil.isNullOrEmpty(s2));
		assertFalse(StringUtil.isNullOrEmpty(s3));
	}

	@Test
	public void testIsNullOrWhiteSpace() {
		String s1 = null;
		String s2 = StringUtil.Empty;
		String s3 = "abc";
		String s4 = "   ";
				
		assertTrue(StringUtil.isNullOrWhiteSpace(s1));
		assertTrue(StringUtil.isNullOrWhiteSpace(s2));
		assertFalse(StringUtil.isNullOrWhiteSpace(s3));
		assertTrue(StringUtil.isNullOrWhiteSpace(s4));
	}

	@Test
	public void testClear() {
		StringBuffer s1 = new StringBuffer();
		StringBuffer s2 = new StringBuffer(StringUtil.Empty);
		StringBuffer s3 = new StringBuffer("abc");
		StringBuffer s4 = new StringBuffer("   ");
		
		StringBuilder s5 = new StringBuilder();
		StringBuilder s6 = new StringBuilder(StringUtil.Empty);
		StringBuilder s7 = new StringBuilder("abc");
		StringBuilder s8 = new StringBuilder("   ");
		
		StringUtil.clear(s1);
		StringUtil.clear(s2);
		StringUtil.clear(s3);
		StringUtil.clear(s4);
		
		StringUtil.clear(s5);
		StringUtil.clear(s6);
		StringUtil.clear(s7);
		StringUtil.clear(s8);
		
		assertTrue(s1.toString().equals(StringUtil.Empty));
		assertTrue(s2.toString().equals(StringUtil.Empty));
		assertTrue(s3.toString().equals(StringUtil.Empty));
		assertTrue(s4.toString().equals(StringUtil.Empty));
		
		assertTrue(s5.toString().equals(StringUtil.Empty));
		assertTrue(s6.toString().equals(StringUtil.Empty));
		assertTrue(s7.toString().equals(StringUtil.Empty));
		assertTrue(s8.toString().equals(StringUtil.Empty));
	}
	
	@Test
	public void testSplit() {
		String colours = "Red,White, Blue   Green        Yellow, Orange,  ";
		String arr[] = StringUtil.split(colours, ",");
		
		for (String string : arr) {
			System.out.println("\"" + string + "\"");
		}
		
		arr = StringUtil.split(colours, ",", false);
		
		for (String string : arr) {
			System.out.println("\"" + string + "\"");
		}
		
		assertTrue(true);
	}
	
	@Test
	public void testIsHankaku() {
		//	日本語
		String s1 = "12 3456a -_ 日本語  bcdefg_";
		//	全角数字
		String s2 = "12 ３４５６a -_ bcdefg_";
		//	全角英字
		String s3 = "12 3456a -_ bcdｅｆｇ_";
		//	半角のみ
		String s4 = "12 3456\\a -_ bcdefg_";
		
		assertFalse(StringUtil.isHankaku(s1, true, true, new String[]{" ", "_", "-"}));
		assertFalse(StringUtil.isHankaku(s2, true, true, new String[]{" ", "_", "-"}));
		assertFalse(StringUtil.isHankaku(s3, true, true, new String[]{" ", "_", "-"}));
		assertTrue(StringUtil.isHankaku(s4, true, true, new String[]{" ", "_", "-", "\\"}));
	}
	
	@SuppressWarnings("unused")
	@Test
	public void testTest() {
		int i = 0;
		Integer i1 = 0;
		
		//String s = "abc-01.ddd";
		String s = "123124134312-00.zipa";
//		if (s.matches("[*]-\\d{2}\\..{3}")) {
//			System.out.println("true");
//		}
		
		if (s.matches(".*-\\d{2}\\.\\D*$")) {
			System.out.println("true");
		}
		
		System.out.println(String.format("%02d", 9));
		
		//assertTrue(i instanceof Integer);
		assertTrue(int.class.equals(Integer.class));
	}
}
