package jp.agentec.abook.abv.bl.common.log;

import android.util.Log;

public class UILogger extends AbstractLogger {
	private static UILogger logger = new UILogger();
	
	private UILogger() {
	}
	
	public static AbstractLogger getLogger() {
		return logger;
	}
	
	private String nvl(String log) {
		return (log==null)? "null": log;
	}

	@Override
	protected void verbose(String tag, String log) {
		Log.v(tag, nvl(log));
	}

	@Override
	protected void verbose(String tag, String log, Throwable t) {
		Log.v(tag, nvl(log), t);
	}

	@Override
	protected void debug(String tag, String log) {
		Log.d(tag, nvl(log));
	}

	@Override
	protected void debug(String tag, String log, Throwable t) {
		Log.d(tag, nvl(log), t);
	}

	@Override
	protected void info(String tag, String log) {
		Log.i(tag, nvl(log));
	}

	@Override
	protected void info(String tag, String log, Throwable t) {
		Log.i(tag, nvl(log), t);
	}

	@Override
	protected void warn(String tag, String log) {
		Log.w(tag, nvl(log));
	}

	@Override
	protected void warn(String tag, String log, Throwable t) {
		Log.w(tag, nvl(log), t);
	}

	@Override
	protected void error(String tag, String log) {
		Log.e(tag, nvl(log));
	}

	@Override
	protected void error(String tag, String log, Throwable t) {
		Log.e(tag, nvl(log), t);
	}

}
