package jp.agentec.abook.abv.cl.environment;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.download.ContentDownloader;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.NetworkInfo.DetailedState;

public class NetworkStateChangeReceiver extends BroadcastReceiver {
	@Override
	public void onReceive(Context context, Intent intent) {
		String action = intent.getAction();
		
		//	ネットワークの状態変化
		if (action.equals(ConnectivityManager.CONNECTIVITY_ACTION)) {
			ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
			if (activeNetworkInfo != null && activeNetworkInfo.getDetailedState().equals(DetailedState.CONNECTED)) {
				//	接続中
				Logger.d("Network State Changed", String.format("NetworkType:%s, State:%s", activeNetworkInfo.getTypeName(), activeNetworkInfo.getDetailedState().name()));
				ActivityHandlingHelper.getInstance().reconnectMeeting();
			} else {
				Logger.d("Network State Changed", "network disconnected.");
				//	その他の状態
				//	ダウンロード中のコンテンツを全て一時停止する。
				ContentDownloader.getInstance().pauseAll();
			}
		} 
	}
}
