package jp.agentec.abook.abv.ui.common.activity;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.database.Cursor;
import android.location.Location;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import org.json.adf.JSONObject;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.agentec.abook.abv.bl.acms.type.OperationType;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.Constant;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;
import jp.agentec.abook.abv.bl.download.ContentFileExtractor;
import jp.agentec.abook.abv.bl.dto.BluetoothPairingDeviceInfoDto;
import jp.agentec.abook.abv.bl.dto.ContentDto;
import jp.agentec.abook.abv.bl.dto.MydataDto;
import jp.agentec.abook.abv.bl.dto.OperationDto;
import jp.agentec.abook.abv.bl.dto.OperationTaskDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContentReadingLogLogic;
import jp.agentec.abook.abv.bl.logic.GroupLogic;
import jp.agentec.abook.abv.bl.logic.OperationLogic;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.cl.environment.DeviceInfo;
import jp.agentec.abook.abv.cl.helper.ContentMarkingFileHelper;
import jp.agentec.abook.abv.cl.util.AlcoholCheckerUtil;
import jp.agentec.abook.abv.cl.util.AlcoholCheckerUtilListener;
import jp.agentec.abook.abv.cl.util.AndroidStringUtil;
import jp.agentec.abook.abv.cl.util.ContentLogUtil;
import jp.agentec.abook.abv.cl.util.LocationManagerUtil;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.DefPrefKey;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType.UserPrefKey;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.common.util.PatternStringUtil;
import jp.agentec.abook.abv.ui.common.view.ABVPopupListWindow;
import jp.agentec.abook.abv.ui.home.helper.ABookCheckWebViewHelper;
import jp.agentec.abook.abv.ui.home.helper.ABookPermissionHelper;
import jp.agentec.abook.abv.ui.home.helper.ActivityHandlingHelper;
import jp.agentec.abook.abv.ui.viewer.activity.CheckOZDViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.NoPdfViewActivity;
import jp.agentec.abook.abv.ui.viewer.activity.PhotoEditActivity;
import jp.agentec.abook.abv.ui.viewer.foxitPdf.FoxitPdfCore;
import jp.agentec.abook.abv.bl.acms.type.AcmsApis;
import jp.agentec.abook.abv.ui.viewer.activity.OnlineHTMLWebViewActivity;
import jp.agentec.abook.abv.ui.common.constant.NaviConsts;
import jp.agentec.adf.util.DateTimeUtil;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;

import static jp.agentec.abook.abv.bl.common.Constant.ReportType.RoutineTask;


public abstract class ABVContentViewActivity extends ABVAuthenticatedActivity {
	protected static GroupLogic groupLogic = AbstractLogic.getLogic(GroupLogic.class);

	private static final String TAG ="ABVContentViewActivity";

	protected long contentId;// 表示中のコンテンツID
	protected long objectId;  // オブジェクトID（オブジェクト用のActivityのときのみ使用）
	protected int objectPageNumber; // オブジェクトが配置されているページ番号（オブジェクト用のActivityのときのみ使用）
	protected MeetingManager meetingManager; // 遠隔連動
	protected boolean mActivityFinishFlg = false;
	protected String mContentDir;
	protected String contentType;
	protected ABVPopupListWindow mShowedPopupWindow = null;
	protected int readingLogId;
	protected String path; // PanoViewController
	protected boolean readingLogFlg = true; // HTMLWebViewActivity,PreviewActivityがPDFのアクションとして呼び出されることがあるので、その場合ログは記録しない
	protected ImageButton subMenuBtn;
	protected ImageButton exitMeetingBtn;
	protected ConcurrentHashMap<Long, Object> objectIdPopupMap = new ConcurrentHashMap<>();

	protected int mCurrentPageNumber = 0; // 表示中のページ番号(0からスタート)

	public Long mOperationId;
	protected int mXWalkOpenType = -1;
	protected int mOperationType;
	private int mReportType;
	protected int mEnableReportHistory; //0:履歴無し 1:履歴可
	// 報告可能区分
	protected int mEnableReportEdit; //0:報告無し 1:報告可
	protected String mContentPath;
	protected int mStatusCode;
	protected boolean isOperationPdf = false;
	protected OperationDto operationDto = null;
	protected String linkUrl;
	private String mReportFileName;

	protected TextView operationNameTitle;
	protected ImageButton operationHomeButton;
	protected ImageButton taskListButton;
	protected ImageButton quickReportPrintButton;

	protected boolean isPageFinished;
	protected Double latitude;
	protected Double longitude;

	protected String mCmd;
	protected String mTaskKey;
	protected String mAttachedFileName;
	protected File mLocalFile;
	public boolean isLinkedContent;
	public int pageNo;

	public int mButtonStatus;	  // 保存ボタンチェック
	protected boolean mAddReport;  // 作業追加区分

	// 編集
	protected String mEditFilePath; //再編集する時、Webからもらうクリックしたイメージファイルのパス
	protected String mEnablePhotoEdit; //最初ファイルをアップロードする時、Webからもらう編集可能可否のパラメタ	0:編集する。 1:編集しない。
	protected PhotoEditActivity mPhotoEditDialog;

	protected boolean isCollaboration = false;

	// 定数
	private static final int REQUEST_CODE_ENABLEBLUETOOTH_CENTER_TEMPERATURE = 2001;  // Bluetooth機能の有効化要求時の識別コード(中心温度計)
	private static final int REQUEST_CODE_ENABLEBLUETOOTH_OKUDAKE = 2002;  // Bluetooth機能の有効化要求時の識別コード
	private static final int REQUEST_CODE_BARCODE_READER  = 2003;  // バーコードリーダの職別コード
	private static final int REQUEST_CODE_ENABLEBLUETOOTH_RADIATION_TEMPERATURE  = 2004;  // Bluetooth機能の有効化要求時の識別コード(放射温度計)
	private static final int REQUEST_CODE_ENABLEBLUETOOTH_SPP_MACHINE = 2005;  // Bluetooth機能の有効化要求時の識別コード(SPP通信機器)
	private static final int REQUEST_CODE_ENABLEBLUETOOTH_TR41 = 2006; // Bluetooth機能の有効化要求時の識別コード(TR41温度センサー)
	private static final int REQUEST_CODE_ENABLEBLUETOOTH_ALCOHL_CHECKER = 2007; // Bluetooth機能の有効化要求時の識別コード(TR41温度センサー)

	// アルコールチェッカー
	private AlcoholCheckerUtil alcoholCheckerUtil;
	//待ち状態の時画面に表示するダイアログ
	protected ABookAlertDialog mWaitingDialog = null;
	// 計測用ダイアログ
	private ABookAlertDialog mWaitMeasureDialog = null;
	// 息を吹きかけてください
	private ABookAlertDialog mMeasureDialog = null;

	// デバイスタイプ 0 アルコールチェッカー
	private int mDeviceType;
	// 設問ID
	private String mQid = "";
	// 二重起動防止フラグ（アルコールチェッカー）
	private boolean isAlcBlock = false;
	// ステータス
	private int checkerStatus = AlcoholCheckerUtil.fugo_init;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		Intent intent = getIntent();
		contentId = intent.getLongExtra(ABookKeys.CONTENT_ID, 0);
		contentType = intent.getStringExtra(ABookKeys.CONTENT_TYPE);
		objectId = intent.getLongExtra("objectId", -1);
		objectPageNumber = intent.getIntExtra("pageNumber", -1);
		readingLogId = intent.getIntExtra("readingLogId", -1);
		path = intent.getStringExtra("path");
		isLinkedContent = intent.getBooleanExtra("isLinkedContent", false);
		mOperationId = intent.getLongExtra(ABookKeys.OPERATION_ID, -1);

		// 戻り先のActivity名を保存しておく
		baseActivityName = getIntent().getStringExtra(AppDefType.ChatPushMessageKey.baseActivityName);

		if (!isLinkedContent) {
			operationDto = AbstractLogic.getLogic(OperationLogic.class).getOperation(mOperationId);
			mXWalkOpenType = intent.getIntExtra(Constant.ABookCheck.XWALK_OPEN_TYPE, Constant.XWalkOpenType.DEFAULT);
			if (mXWalkOpenType == Constant.XWalkOpenType.TASK_REPORT || mXWalkOpenType == Constant.XWalkOpenType.PANO_EDIT) {
				if (mXWalkOpenType == Constant.XWalkOpenType.TASK_REPORT) {
					mOperationType = operationDto.operationType;
					mReportType = operationDto.reportType;
					if (mOperationType != OperationType.PDF && isNormalSize()) {
						// 縦画面固定
						setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
					}

					new Thread(new Runnable() {
						@Override
						public void run() {
							// 添付ファイル表示のため、キャッシュディレクトリにコピーする
							ABookCheckWebViewHelper.getInstance().allCopyTaskAttachedMovieFileToCache(mOperationId, getContentId(), operationDto);
						}
					}).start();
					mStatusCode = 0;
				}
				mEnableReportEdit = operationDto.enableReportEdit;
				mEnableReportHistory = operationDto.enableReportHistory;

				linkUrl = intent.getStringExtra("LINKURL"); // LinkURL

				if (operationDto != null && operationDto.operationType == OperationType.PDF) {
					isOperationPdf = true;
				}
			}
		}

		// 遠隔連動
		meetingManager = MeetingManager.getInstance();
		isCollaboration = meetingManager.isCollaboration();

		mContentDir = getIntent().getStringExtra(FILEPATH);

		// Activity登録
		if (objectId == -1) {
			ActivityHandlingHelper.getInstance().setContentViewActivity(this);
			ContentDto dto = contentDao.getContent(contentId);
			if (dto != null) {
				// 閲覧履歴保存
				contentDao.updateContentReadingDate(DateTimeUtil.getCurrentTimestamp(), getContentId());
			}
		} else {
			ActivityHandlingHelper.getInstance().setObjectViewActivity(this);
		}
		
		contentDownloader.pauseAll();
		
		showUpdateContentAlert(contentId);
	}
	/**
	 * 各デバイスから値を正常に取得された場合、HTML側にコールする
	 * @param value 各種デバイスから取得した値
	 */
	private void successAfterAbookCheckApi(final String value, boolean isFinish) {
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				dismissAllDialog();
				JSONObject responseJson = new JSONObject();
				responseJson.put(ABookKeys.TASK_QUESTION_ID, mQid);
				responseJson.put("value", value);
				afterABookCheckApi(mCmd, "", 0, "", responseJson.toString());
				Logger.i(TAG, "successAfterAbookCheckAip  JSON [%s]", responseJson.toString());
				isAlcBlock  = false;
				handler.postDelayed(new Runnable() {
					@Override
					public void run() {
						alcoholCheckerUtil.finish();
					}
				},2000);
			}
		});
	}

	/**
	 * 各デバイスからエラー（接続不能など）発生した場合、HTML側にコールする
	 * @param errorMessage  各種デバイスから取得した値
	 */
	private void errorAfterAbookCheckApi(final String errorMessage, final boolean isSendResult) {
		// エラーの時は終了
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				dismissAllDialog();
				if (AlcoholCheckerUtil.isConnected) {
					// BLE接続中であれば、BLE表示に戻す
					alcoholCheckerUtil.SendMessageFromCentral(AlcoholCheckerUtil.F_BLE_COM_FC_START);
				}
				handler.postDelayed(new Runnable() {
					@Override
					public void run() {
						if (isSendResult) {
							afterABookCheckApi(mCmd, "", 1, errorMessage, null);
						}
						if(alcoholCheckerUtil != null) {
							alcoholCheckerUtil.finish();
							alcoholCheckerUtil = null;
						}
						Logger.e(TAG,errorMessage);
						isAlcBlock = false;
					}
				}, 2000);
			}
		});
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// アルコールチェッカーここから

	/**
	 * アルコールチェッカー、ユーティリティ初期化
	 */
	private void initAlcoholCheckerUtil() {
		Logger.i(TAG,"initAlcoholCheckerUtil");

		alcoholCheckerUtil = new AlcoholCheckerUtil(this, new AlcoholCheckerUtilListener() {

			@Override
			public void onUpdateTBVCalc(String text) {
				Logger.d(TAG, "onUpdateTBVCalc = %s", text);
			}

			@Override
			public void onServicesDiscovered(int status) {
				Logger.d(TAG, "onServicesDiscovered = %s", status);

				if (checkerStatus == AlcoholCheckerUtil.fugo_wait_connect) {
					checkerStatus = AlcoholCheckerUtil.fugo_conntected;
				} else {
					return;
				}
				runOnUiThread(new Runnable() {
					@Override
					public void run() {
						if (mWaitingDialog != null) {
							mWaitingDialog.dismiss();
							mWaitingDialog = null;
						}
						AlcoholCheckerUtil.isConnected = true;
						// 測定開始ボタン押し待ち
						showWaitMeasureDialog(getString(R.string.alcohol_checker), getString(R.string.connection_completed));
					}
				});
			}

			@Override
			public void onGetDeviceInfo(final String alcohol) {
				runOnUiThread(new Runnable() {
					@Override
					public void run() {
						Logger.d(TAG, "測定完了 = " + alcohol);
						if (!alcohol.equals("")) {
							checkerStatus = AlcoholCheckerUtil.fugo_finish;
							successAfterAbookCheckApi(alcohol, false);
						} else {

						}
					}
				});
			}

			@Override
			public void onStartMeasurement() {
				Logger.d(TAG, "onStartMeasurement");
				final boolean isFromError;
				if (checkerStatus == AlcoholCheckerUtil.fugo_conntected) {
					isFromError = false;
					checkerStatus = AlcoholCheckerUtil.fugo_wait_go;
				} else if (checkerStatus == AlcoholCheckerUtil.fugo_fu_error) {
					isFromError = true;
					checkerStatus = AlcoholCheckerUtil.fugo_wait_go;
				} else {
					return;
				}
				runOnUiThread(new Runnable() {
					@Override
					public void run() {
						if (isFromError) {
							if (mMeasureDialog != null) {
								mMeasureDialog.setMessage(getString(R.string.wait_breathe));
							}
						} else {
							if (mWaitMeasureDialog != null) {
								mWaitMeasureDialog.dismiss();
								mWaitMeasureDialog = null;
							}
							showMeasureDialog(getString(R.string.alcohol_checker), getString(R.string.wait_breathe));
						}
					}
				});
			}

			@Override
			public void onMeasurementError(String text) {
				Logger.d(TAG,"onMeasurementError = " + text);
				if (mMeasureDialog != null) {
					checkerStatus = AlcoholCheckerUtil.fugo_fu_error;
					runOnUiThread(new Runnable() {
						@Override
						public void run() {
							if (mMeasureDialog != null) {
								mMeasureDialog.setMessage(getString(R.string.msg_breath_error));
							}
						}
					});
				}
			}

			@Override
			public void onConnectionError(int status) {
				Logger.d(TAG,"onConnectionError = " + status);
				if (checkerStatus == AlcoholCheckerUtil.fugo_finish) {
					Logger.d(TAG,"fugo_finish.");
					return;
				}
				checkerStatus = AlcoholCheckerUtil.fugo_finish;
				String message = getString(R.string.msg_disconnected_device);
				if (status == 133 || status == 8) {
					message = getString(R.string.msg_connection_timeout); // デバイスと接続されていない
				} else if (status == 19) {
					message = getString(R.string.msg_disconnected_device);
				}
				if (alcoholCheckerUtil != null) {
					alcoholCheckerUtil.isConnected = false;
				}
				errorAfterAbookCheckApi(message,true);
			}

			@Override
			public void onBreakDownError(String text) {
				errorAfterAbookCheckApi(getString(R.string.msg_break_down_device),true);
			}

			@Override
			public void onLowBatteryError(String text) {
				errorAfterAbookCheckApi(getString(R.string.msg_low_battery),true);
			}

			@Override
			public void onOverUsedError(String text) {
				errorAfterAbookCheckApi(getString(R.string.msg_over_used),true);
			}

			@Override
			public void onPowerOff(String text) {
				errorAfterAbookCheckApi(getString(R.string.msg_power_off),true);
			}
		});
	}

	private void dismissAllDialog() {
		Logger.d(TAG,"dismissAllDialog");
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				// 後始末
				if (mWaitingDialog != null) {
					mWaitingDialog.dismiss();
					mWaitingDialog = null;
				}
				if (mWaitMeasureDialog != null) {
					mWaitMeasureDialog.dismiss();
					mWaitMeasureDialog = null;
				}
				if (mMeasureDialog !=null) {
					mMeasureDialog.dismiss();
					mMeasureDialog = null;
				}
			}
		});
	}

	/**
	 * 接続待ち
	 * @param title タイトル
	 * @param message 内容
	 */
	private void showWaitingDialog(String title, String message) {
		Logger.i(TAG,"showWaitingDialog");
		mWaitingDialog = AlertDialogUtil.createAlertDialog(this, title);
		mWaitingDialog.setMessage(message);
		mWaitingDialog.setButton(DialogInterface.BUTTON_POSITIVE, getResources().getString(R.string.cancel), new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				Logger.i(TAG, "waiting Dialog stop click");
				errorAfterAbookCheckApi("", false);
			}
		});
		mWaitingDialog.show();
	}

	/**
	 * 行き吹きかけボタン押し待ち
	 * @param title タイトル
	 * @param message 内容
	 */
	private void showWaitMeasureDialog(String title, String message) {
		Logger.i(TAG,"showWaitMeasureDialog");
		mWaitMeasureDialog = AlertDialogUtil.createAlertDialog(this, title);
		mWaitMeasureDialog.setMessage(getString(R.string.connection_completed));
		mWaitMeasureDialog.setButton(DialogInterface.BUTTON_POSITIVE, getString(R.string.cancel), new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				Logger.i(TAG, "waiting mWaitMeasureDialog stop click");
				errorAfterAbookCheckApi("", false);
			}
		});
		mWaitMeasureDialog.show();
	}

	/**
	 * 吹きかけてください
	 * @param title タイトル
	 * @param message 内容
	 */
	private void showMeasureDialog(String title, String message) {
		Logger.i(TAG,"showMeasureDialog");
		mMeasureDialog = AlertDialogUtil.createAlertDialog(this, title);
		mMeasureDialog.setMessage(message);
		mMeasureDialog.setButton(DialogInterface.BUTTON_NEGATIVE, getString(R.string.cancel), new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				Logger.i(TAG, "wait mMeasureDialog stop click");
				errorAfterAbookCheckApi("", false);
			}
		});
		mMeasureDialog.show();
	}


	/**
	 * アルコールチェッカー処理
	 * @param abookCheckParam
	 */
	private void getDeviceInfo(Map<String, String> abookCheckParam) {
		Logger.i(TAG, "getDeviceInfo start.");

		mDeviceType = Integer.parseInt(abookCheckParam.get(ABookKeys.TASK_DEVICE_TYPE));
		mQid = abookCheckParam.get(ABookKeys.TASK_QUESTION_ID);

		// アルコールチェッカー初期化
		initAlcoholCheckerUtil();

		if (!alcoholCheckerUtil.startGetDeviceInfo()) {
			// 端末がBluetoothをサポートしていないなどの理由で、アルコールチェッカーが使えない
			Logger.e(TAG, "bluetooth not support.");
			afterABookCheckApi(mCmd, "", 1, getString(R.string.bluetooth_is_not_supported), null);
			return;
		}

		alcoholCheckerUtil.bleManagerUtil.setListener(alcoholCheckerUtil.bleManagerUtilListener);
		checkerStatus = AlcoholCheckerUtil.fugo_init;
		// アルコールチェッカー接続
		startAlcholChecker();
	}

	/**
	 * Android端末のBluetooth機能の有効化要求
	 * @return true:bluetooth ON, false:bluetooth OFF
	 */
	private boolean requestBluetoothFeature(int requestCode) {
		if(alcoholCheckerUtil.bleManagerUtil.mBluetoothAdapter.isEnabled()) {
			return true;
		}
		// デバイスのBluetooth機能が有効になっていないときは、有効化要求（ダイアログ表示）
		Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
		startActivityForResult(enableBtIntent, requestCode);
		return false;
	}

	/**
	 * BLEディバイスのアルコールチェッカーの情報取得
	 */
	private void startAlcholChecker() {
		if (requestBluetoothFeature(REQUEST_CODE_ENABLEBLUETOOTH_ALCOHL_CHECKER)) { //端末のBluetooth設定を確認

			String deviceAddress = getABVUIDataCache().getPairingBluetoothDeviceAddress(Constant.DeviceType.alcoholChecker);
			if (StringUtil.isNullOrEmpty(deviceAddress)) {
				// 登録されているアルコールチェッカーが無い場合はエラー
				errorAfterAbookCheckApi(getString(R.string.msg_pairing_device_no_info), true);
				return;
			}
			BluetoothPairingDeviceInfoDto dto = getABVUIDataCache().getPairingBluetoothDeviceInfo(Constant.DeviceType.alcoholChecker);
			checkerStatus = AlcoholCheckerUtil.fugo_wait_connect;
//			if (AlcoholCheckerUtil.isConnected) {
//				Logger.d(TAG, "isConnection = true");
//				checkerStatus = AlcoholCheckerUtil.fugo_conntected;
//				showWaitMeasureDialog(getString(R.string.alcohol_checker), getString(R.string.connection_completed));
//			} else
			{
				Logger.d(TAG, "isConnection = false");
				// 登録されているアルコールチェッカーがある
				String message = String.format(getString(R.string.ble_connecting), dto.deviceName);
				showWaitingDialog(getString(R.string.alcohol_checker), message);
				// 接続まち
				alcoholCheckerUtil.connect(Constant.DeviceType.alcoholChecker, deviceAddress);
			}
		}
	}

	// アルコールチェッカーここまで
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	private void showUpdateContentAlert(long contentId) {
		if (meetingManager.isConnected()) {
			ContentDto contentDto = contentDao.getContent(contentId);
			if (contentDto.updatedFlg) {
				handler.post(new Runnable() {
					@Override
					public void run() {
						final ABookAlertDialog confirmDialog = AlertDialogUtil.createAlertDialog(ABVContentViewActivity.this, R.string.confirm);
						confirmDialog.setCancelable(false);
						confirmDialog.setMessage(R.string.msg_content_to_be_updated);
						confirmDialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog, int whichButton) {
								confirmDialog.dismiss();
							}
						});
						confirmDialog.show();
					}
				});
			}
		}
	}

	@Override
	protected void onResume() {
		Logger.i(TAG,"onResume");
		super.onResume();
		try {
			if (readingLogFlg) {
				readingLogId = ContentLogUtil.getInstance().startContentReadLog(this, contentId, getABVUIDataCache().getPermissionAccessLocation());
			}
		} catch (Exception e) {
			Logger.e("Exception", e);
			handleErrorMessageToast(ErrorCode.E107);
		}
		
		try {
			if (ABVEnvironment.getInstance().networkAdapter.isNetworkConnected()) {
				ActivityHandlingHelper.getInstance().reconnectMeeting(); // 会議室入室時に接続切れだった場合に再接続する
			}
		} catch (Exception e) {
			Logger.e(TAG, "reconnectMeeting error.", e); // ignore
		}
	}

	@Override
	protected void onClickHomeButton() {
		super.onClickHomeButton();
	}

	@Override
	protected void onStart() {
		super.onStart();
	}
   
	@Override
	protected void onPause() {
		super.onPause();
		Logger.i(TAG,"onPause");
		if (mCmd != null && mCmd.equals(ABookKeys.CMD_GET_DEVICE_INFO)) {
			errorAfterAbookCheckApi("", false);
		}
	}

	@Override
	protected void onStop() {
		super.onStop();
		Logger.d(TAG,"onStop");

		if (!DeviceInfo.isForegrdound(getApplicationContext()) && readingLogFlg) {
			ContentReadingLogLogic logic = AbstractLogic.getLogic(ContentReadingLogLogic.class);
			logic.pauseContentReadLog(contentId);
		}
	}

	@Override
	protected void onDestroy() {
		Logger.d(TAG,"onDestroy");
		if (readingLogFlg) {
			ContentReadingLogLogic logic = AbstractLogic.getLogic(ContentReadingLogLogic.class);
			logic.endContentReadLog(contentId);
		}
		
		super.onDestroy();

		if (meetingManager.isSendable() && objectId != -1) {
			meetingManager.sendWs(MeetingManager.CMD_CLOSEPOPUP, contentId, objectPageNumber, objectId, null);
		}

		if (meetingManager.isSubscribed()) {
			ActivityHandlingHelper.getInstance().refreshMeetingListActivity();
		}
		if (objectId == -1) {
			ActivityHandlingHelper.getInstance().removeContentViewActivity(this);
		} else {
			ActivityHandlingHelper.getInstance().removeObjectViewActivity(this);
		}

		//キャッシュを使用しない場合、ディレクトリが残っていれば削除
		if (!getRBoolean(R.bool.use_cache) && objectId == -1) {
			ContentFileExtractor.getInstance().removeContentCash(contentId);
		}
	}
	
	public long getContentId() {
		return contentId;
	}

	public long getObjectId() {
		return objectId;
	}

	public void performRemoteEvent(final JSONObject json) {
	}
	
	protected boolean isCursorModeEnable() {
		if (isOperationPdf()) {
			return false;
		} else {
			return PreferenceUtil.get(this, DefPrefKey.CURSOR_ENABLE, false);
		}
	}
	
	protected void initError() {
		ContentFileExtractor.getInstance().removeContentCash(contentId);
		handleErrorMessageToast(ErrorCode.E105);
		mActivityFinishFlg = true;
		finish();
	}
	
	public static void errorMessageDialog(final Context context,final int title, final ErrorCode value) {
		// アラート内レイアウト
		TextView txtMsg = new TextView(context);	
		txtMsg.setText(R.string.delete_message);
		txtMsg.setTextSize(20);
		txtMsg.setGravity(Gravity.LEFT|Gravity.CENTER_VERTICAL);
		txtMsg.setText(ErrorMessage.getMessageByErrorCode(context, value));
				
		int WC = ViewGroup.LayoutParams.WRAP_CONTENT;
		int FP = ViewGroup.LayoutParams.MATCH_PARENT;
		LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(FP, WC);
		params.leftMargin = 10;
		LinearLayout layout = new LinearLayout(context);
		layout.addView(txtMsg, params);
		layout.setLayoutParams(new LinearLayout.LayoutParams(FP, WC));
		
		ABookAlertDialog alert = AlertDialogUtil.createAlertDialog(context, title);
		alert.setView(layout);
		alert.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int whichButton) {
				dialog.dismiss();
			}
		});
		alert.show();
	}
	
	// 指定ページへのジャンプ
	@Override
	public void startContentViewActivity(long contentId, int pageNum) {
			Logger.d(TAG, "startContentViewActivity:%s, pageNum=%s", contentId, pageNum);
			releaseInit();
			Intent intent = new Intent();
			intent.putExtra("page", pageNum);
//			intent.putExtra("removeOtherActivity", true); // これは行わない
			startContentViewActivity(intent, contentId);
		}
	
	/**
	 * 閲覧履歴一覧を表示する
	 * @param anchor ツールバーの閲覧履歴ボタン
	 */
	protected void showHistoryList(View anchor) {
		mShowedPopupWindow = new ABVPopupListWindow(this);
		if (isNormalSize()) {
			mShowedPopupWindow.setWidth(getRDimensionSize(R.dimen.popup_size_normal));
		} else {
			mShowedPopupWindow.setWidth(getRDimensionSize(R.dimen.popup_size_large));
		}
		
		ArrayList<String> menuNameList = new ArrayList<>();
		
		final List<MydataDto> list = contentDao.getReadingContent();
		list.remove(0); // 自分自身を削除

		for (MydataDto MyDataDto : list) {
			menuNameList.add(MyDataDto.contentName);
		}
		
		if (menuNameList.size() == 0) {
			menuNameList.add(getRString(R.string.no_content_history));
		}
		
		mShowedPopupWindow.setRepresentNames(menuNameList);
		mShowedPopupWindow.setOnItemClickListener(new OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				if (list.size() > 0) {
					MydataDto dto = list.get(position);
					startContentViewActivity(dto.contentId, dto.pageNum);
					mShowedPopupWindow.dismiss();
				}
			}
		});
		
		mShowedPopupWindow.showAsDropDown(anchor);
	}
	
	protected void releaseInit() {
		// Activity終了時に初期化が必要な処理を作成
		// 各自必要な場合に実装する
	}
	
	/**
	 * 会議室を正常に退室
	 */
	protected void setMeetingEnteredFlg() { // TODO: 移動
		PreferenceUtil.putUserPref(this, UserPrefKey.MEETING_ENTERED_FLG, false);
	}

	protected void sendPromoteRequest() {
		JSONObject json = new JSONObject();
		json.put(MeetingManager.ID, meetingManager.getSkey());
		json.put(MeetingManager.LOGIN_ID, ABVDataCache.getInstance().getMemberInfo().loginId);
		meetingManager.sendWs(MeetingManager.CMD_PRESENTERREQUEST, getContentId(), null, null, json);
		ABVToastUtil.showMakeText(this, getString(R.string.msg_request_promotion), Toast.LENGTH_SHORT);
	}

	@Override
	public void finish() {
		// ホームをリロードさせる
		ActivityHandlingHelper.getInstance().setRequireHomeReload(true);
		super.finish();
		Logger.d(TAG, "finish");
	}

	protected void commonConfigureRemote() {
	}

	public void configureRemote() {
	}
	
	public void switchMeetingExitButton() {
		handler.post(new Runnable() {
			@Override
			public void run() {
				if (meetingManager.isSendable()) { // 会議室退室ボタン表示
					RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(WC, WC);
					params.addRule(RelativeLayout.LEFT_OF, R.id.btn_exitMeeting);
					params.addRule(RelativeLayout.CENTER_VERTICAL);
					params.rightMargin = (int) (getResources().getDisplayMetrics().density * 5);
					subMenuBtn.setLayoutParams(params);
					if (isCollaboration) {
						exitMeetingBtn.setVisibility(View.GONE);
					} else {
						exitMeetingBtn.setVisibility(View.VISIBLE);
					}


//					if (helpButton != null && helpButton.getVisibility() == View.VISIBLE) {
//						helpButton.setLayoutParams(params);
//					}
				}
				else { // 会議室退室ボタン非表示
					if (exitMeetingBtn != null) {
						exitMeetingBtn.setVisibility(View.GONE);
						RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(WC, WC);
						params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
						params.addRule(RelativeLayout.CENTER_VERTICAL);
						params.rightMargin = (int) (getResources().getDisplayMetrics().density * 5);
						subMenuBtn.setLayoutParams(params);
					}
//					if (helpButton != null && helpButton.getVisibility() == View.VISIBLE) {
//						helpButton.setLayoutParams(params);
//					}
				}
			}
		});
	}
	
	protected void showMeetingExitDialog() {
		ABookAlertDialog alert = AlertDialogUtil.createAlertDialog(this, R.string.confirm);
		if (meetingManager.isOwner()) {
			alert.setMessage(AndroidStringUtil.format(this, R.string.msg_leave_all, R.string.meeting_leave));
		}
		else {
			alert.setMessage(R.string.msg_leave);
		}
		alert.setPositiveButton(R.string.yes, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int whichButton) {
				// 遠隔連動中に保存したマーキングファイルを削除
				ContentMarkingFileHelper contentMarkingFileHelper = new ContentMarkingFileHelper();
				contentMarkingFileHelper.deleteRemoteMarkingFile(contentId);

				setMeetingEnteredFlg();
				if (meetingManager.isOwner()) {
					try {
						meetingManager.deleteMeeting();
					} catch (Exception e) {
						Logger.e(TAG, "showMeetingExitDialog deleteMeeting error", e);
						ABVToastUtil.showMakeText(ABVContentViewActivity.this, getString(R.string.E126), Toast.LENGTH_SHORT);
					}
				}
				//会議室に参加する前のonCloseと識別するため
				meetingManager.close();
				configureRemote();

				ActivityHandlingHelper handlingHelper = ActivityHandlingHelper.getInstance();
				handlingHelper.saveMeetingInfo(null, null, null, false);
				handlingHelper.finishAllContentViewActivity();
			}
		});
		alert.setNegativeButton(R.string.no, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int whichButton) {
				dialog.cancel();
			}
		});
		alert.show();
	}

	@Override
	protected void onApplicationBroughtFromBackground() {
		new Handler().post(new Runnable() {
			@Override
			public void run() {
				// コンテンツビューワーでは定期パスワード変更以外のチェックを行う
				if (checkForceOfflineLogout()) {
					finish();
				} else if (checkValidAuthTime()) {
					finish();
				}
			}
		});
	}

	@Override
	public boolean dispatchTouchEvent(MotionEvent ev) {
		Logger.v(TAG, "[dispatchTouchEvent]:start");
		try {
			return super.dispatchTouchEvent(ev);
		} catch (IllegalArgumentException e) {
			Logger.w(TAG, "dispatchTouchEvent failed.", e);
			//  java.lang.IllegalArgumentException: pointerIndex out of range
			return true;
		}
	}

	protected void setMeetingParticipantCount(boolean isVisible, View toolBar) {
		final TextView textView = (TextView)toolBar.findViewById(R.id.txt_meeting_participant);
		if (textView == null) {
			return;
		}
		textView.setVisibility(View.GONE);
		if (isVisible && !isCollaboration) {
			if (meetingManager.isConnected() && meetingManager.isOwner()) {
				textView.setVisibility(View.VISIBLE);
				CommonExecutor.execute(new Runnable() {
					@Override
					public void run() {
						final int count = meetingManager.getParticipantCount();
						handler.post(new Runnable() {
							@Override
							public void run() {
								textView.setText(getRString(R.string.meeting_participant_count) + ":" + count);
							}
						});
					}
				});
			}
			
		}
	}

	@Override
	public boolean onKeyUp(int keyCode, KeyEvent event) {
		if (keyCode == KeyEvent.KEYCODE_BACK) {
			if (this instanceof NoPdfViewActivity) {
				if(isLinkedContent) {
					goToBack();
				} else {
					this.finish();
					moveToBack();
				}
			} else {
				return super.onKeyUp(keyCode, event);
			}
			return false;
		} else {
			return super.onKeyUp(keyCode, event);
		}
	}

	public int getCurrentPageNumber() {
		return mCurrentPageNumber;
	}

	/**
	 * 戻る用コンテンツIDリストをリセット
	 */
	public void resetReturnContentIdList () {
		getABVUIDataCache().resetReturnContentIdList();
	}

	/**
	 * 戻る用コンテンツIDリストを取得
	 */
	public List<long[]> getReturnContentIdList() {
		return getABVUIDataCache().getReturnContentIdList();
	}

	/**
	 * コンテンツビューから戻るボタンタップ時の処理
	 */
	public void moveToBack() {
		//戻る用コンテンツIDの数
		int listSize = getReturnContentIdList().size();
		if (listSize == 0) {
			finish();
		} else {
			long[] contentInfo = getReturnContentIdList().get(listSize - 1);
			// 直前のコンテンツが360コンテンツか確認⇒画面遷移ではなくfinish()で廃棄することで戻る
			if (ActivityHandlingHelper.getInstance().hasPreviousPanoContentId(contentInfo[0])) {
				finish();
			} else {
				ActivityHandlingHelper.getInstance().startContentActivity(contentInfo[0], (int) contentInfo[1]);
			}
			getReturnContentIdList().remove(listSize - 1);
		}
	}

	/**
	 * コンテンツビューから戻るボタンタップ時の処理(ABookCheck専用)
	 */
	public void goToBack() {
		releaseInit();
		finish();
	}

	protected void createCheckToolbar() {
		final RelativeLayout fl;
		if (operationDto != null && operationDto.operationType == OperationType.PDF && mXWalkOpenType == Constant.XWalkOpenType.TASK_REPORT) {
			fl = (RelativeLayout) findViewById(R.id.RelativeLayout2);
		} else {
			fl = (RelativeLayout) findViewById(R.id.frameTopbar);
		}
		fl.setBackgroundColor(getResources().getColor(R.color.operation_color));
		operationHomeButton = (ImageButton) findViewById(R.id.btn_operation_home);
		quickReportPrintButton = (ImageButton) findViewById(R.id.btn_operation_print);
		operationHomeButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				if (mXWalkOpenType == Constant.XWalkOpenType.PANO_EDIT) {
					showConfirmSavePanoEdit();
				} else {
					// 作業終了する時、作業ID設定して作業一覧で使用するメソットを行う。
					putUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, mOperationId);
					finishActivity();  // 開いてる画面を閉じる
				}
			}
		});
		operationHomeButton.setVisibility(View.VISIBLE);
		
		if(operationDto != null && operationDto.operationType == OperationType.PDF){
			// 簡易帳票印刷ボタン
			quickReportPrintButton.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					showPrintTargetSelect(operationDto);
				}
			});

			if (ABVDataCache.getInstance().serviceOption.isUnableIOReport() && operationDto.quickReport == 1) {
				quickReportPrintButton.setVisibility(View.VISIBLE);
			} else {
				if (findViewById(R.id.print_layout) != null) {
					findViewById(R.id.print_layout).setVisibility(View.GONE);
					quickReportPrintButton.setVisibility(View.GONE);
				}
			}
		}

		taskListButton = (ImageButton) findViewById(R.id.btn_show_task_list);
		taskListButton.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				// 作業一覧表示
				showTaskList();
			}
		});

		if (mXWalkOpenType == Constant.XWalkOpenType.TASK_REPORT  || mXWalkOpenType == Constant.XWalkOpenType.PANO_EDIT) {
			if (mXWalkOpenType == Constant.XWalkOpenType.TASK_REPORT) {
				if (mOperationType != OperationType.PDF && isNormalSize()) {
					// 縦画面固定
					setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
				}
				mOperationType = operationDto.operationType;
				String cacheDirPath = ABVEnvironment.getInstance().getContentCacheDirectoryPath(getContentId());
				if (operationDto.operationType == OperationType.LIST) {
					mContentPath = ABVEnvironment.getInstance().getTaskListDirName(cacheDirPath);
					if (operationDto.reportType == Constant.ReportType.ReportContinuous) {
						mContentPath = ABVEnvironment.getInstance().getProcessListDirName(cacheDirPath);
					}
				} else if (operationDto.operationType == OperationType.PDF) {
					mContentPath = ABVEnvironment.getInstance().getTaskPdfDirName(cacheDirPath);
				} else {
					mContentPath = ABVEnvironment.getInstance().getPanoImageDirName(cacheDirPath);
				}
				mStatusCode = 0;
			}

			operationNameTitle = (TextView) findViewById(R.id.title);
			operationNameTitle.setText(operationDto.operationName);
			if (isNormalSize()) {
				operationNameTitle.setWidth(getRDimensionSize(R.dimen.operation_title_normal_width));
			} else {
				operationNameTitle.setWidth(getRDimensionSize(R.dimen.operation_title_large_width));
			}
			operationNameTitle.setVisibility(View.VISIBLE);
		}
	}

	/**
	 * 簡易帳票印刷対象選択画面表示
	 */
	private void showPrintTargetSelect(OperationDto operationDto) {
		Intent intent = new Intent();
		intent.setClass(ABVContentViewActivity.this, OnlineHTMLWebViewActivity.class);
		intent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
		intent.putExtra("LINKURL", AcmsApis.getApiUrl(ABVEnvironment.getInstance().acmsAddress, ABVDataCache.getInstance().getUrlPath(), AcmsApis.ApiQuickReportRevision) + "?isNative=1");
		intent.putExtra("operationId", mOperationId);
		startActivity(intent, NaviConsts.Right);
	}


	/**
	 * 360編集画面を閉じた時、呼び出す
	 */
	public void callUnloadAuth() {
		Logger.v(TAG, "run javaScript for ABookCheck : callUnloadAuth");
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				webViewLoadUrl("javascript:EDC.callUnloadAuth()");
			}
		});
	}

	/**
	 * 作業一覧表示
	 */
	public void showTaskList() {
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				webViewLoadUrl("javascript:CHK.showTaskList()");
			}
		});
	}

	/**
	 * 編集を終了しますかのダイアログメッセージ表示
	 */
	public void showConfirmSavePanoEdit() {
		ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ABVContentViewActivity.this, PatternStringUtil.patternToInt(getApplicationContext(),
				R.string.pano_edit,
				getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
		// リソースパターンの適用
		alertDialog.setMessage(PatternStringUtil.patternToString(getApplicationContext(),
				R.string.msg_confirm_save_pano_edit,
				getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
		alertDialog.setNegativeButton(R.string.cancel, null);
		alertDialog.setPositiveButton(R.string.ok,
				new DialogInterface.OnClickListener() {
					@Override
					public void onClick(DialogInterface dialog, int which) {
						callUnloadAuth();
						dialog.dismiss();
						finish();
					}
				});
		alertDialog.show();
	}

	//以下のメッソドは子ActivityにOverideで使用
	protected void finishActivity() {}
	protected void webViewLoadUrl(String url){}

	public void onClickOperationHome(View v) {
		if (mXWalkOpenType == Constant.XWalkOpenType.PANO_EDIT) {
			// リソースパターンの適用
			ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(ABVContentViewActivity.this, PatternStringUtil.patternToString(getApplicationContext(),
																													R.string.pano_edit,
																													getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
			// リソースパターンの適用
			alertDialog.setMessage(PatternStringUtil.patternToString(getApplicationContext(),
									R.string.msg_confirm_save_pano_edit,
									getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
			alertDialog.setNegativeButton(R.string.cancel, null);
			alertDialog.setPositiveButton(R.string.ok,
					new DialogInterface.OnClickListener() {
						@Override
						public void onClick(DialogInterface dialog, int which) {
							callUnloadAuth();
							dialog.dismiss();
							finish();
						}
					});
			alertDialog.show();
		} else {
			// 作業終了する時、作業ID設定して作業一覧で使用するメソットを行う。
			putUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, mOperationId);  // 作業IDの設定
			finishActivity();  // 開いてる画面を閉じる
		}
	}

	/**
	 * Be override
	 */
	protected void onActionOperationPdfWebView(Map<String, String> checkParam, OperationTaskDto operationTaskDto) {}


	/**
	 * WebView発生を受け取るメソッド
	 * @param uri 情報がkey, valueの形式で格納されている
	 * @param operationTaskDto HotSpotの情報などが入っている。報告タイプによっては、使わないケースもある
	 */
	public void commonShouldOverrideUrlLoading (Uri uri, OperationTaskDto operationTaskDto) {
		Logger.d(TAG, "Uri : %s", uri);
		//parent method
		Map<String, String> abookCheckParam = new HashMap<String, String>();
		for (String key : uri.getQueryParameterNames()) {
			abookCheckParam.put(key, uri.getQueryParameter(key));
			Logger.d(TAG,"key = %s, value = %s", key, uri.getQueryParameter(key));
		}
		mCmd = abookCheckParam.get(ABookKeys.CMD);
		if (abookCheckParam.containsKey(ABookKeys.TASK_KEY)) {
			mTaskKey = abookCheckParam.get(ABookKeys.TASK_KEY);
		}

		int taskReportLevel = 0;  // 作業報告レベル（0：報告、１：報告（回答）、２：報告（回答））
		if (abookCheckParam.containsKey(ABookKeys.TASK_REPORT_LEVEL)) {
			taskReportLevel = Integer.parseInt(abookCheckParam.get(ABookKeys.TASK_REPORT_LEVEL));  // 作業報告レベル
		}
		// 作業追加区分の値を取得する
		mAddReport = true;

		// 定期点検の場合、以下のフラグを変更しない（mAddReport trueのみ）
		if (abookCheckParam.containsKey(ABookKeys.ADD_REPORT)) {
			mAddReport = Integer.parseInt(abookCheckParam.get(ABookKeys.ADD_REPORT)) > 0 ? true : false;
		}

		int taskReportId = 0;
		String reportStartDate = "";

		if (operationDto.reportType == RoutineTask && abookCheckParam.get(ABookKeys.TASK_REPORT_ID) != null && abookCheckParam.get(ABookKeys.REPORT_START_DATE) != null) {
			taskReportId = Integer.parseInt(abookCheckParam.get(ABookKeys.TASK_REPORT_ID));
			reportStartDate = abookCheckParam.get(ABookKeys.REPORT_START_DATE);
		}

		//連続作業用
		String processKey = null;
		Integer phaseNo = 0;
		if (abookCheckParam.containsKey(ABookKeys.PROCESS_KEY)) {
			processKey = abookCheckParam.get(ABookKeys.PROCESS_KEY);
		}
		if (abookCheckParam.containsKey(ABookKeys.PHASE_NO)) {
			phaseNo = Integer.parseInt(abookCheckParam.get(ABookKeys.PHASE_NO));
		}

		if (StringUtil.equalsAny(mCmd, ABookKeys.CMD_MOVE_HOT_SPOT, ABookKeys.CMD_INSERT_TASK_REPORT, ABookKeys.CMD_UPDATE_TASK_REPORT,
				ABookKeys.CMD_DELETE_TASK_REPORT, ABookKeys.CMD_CANCEL_TASK_REPORT, ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT, ABookKeys.CMD_CHANGE_TASK_REPORT, ABookKeys.CMD_DELETE_PROCESS)) {


			try {
				if (StringUtil.equalsAny(mCmd, ABookKeys.CMD_INSERT_TASK_REPORT, ABookKeys.CMD_UPDATE_TASK_REPORT)) {
					// リソースパターンの適用
					runOnUiThread(new Runnable() {
						@Override
						public void run() {
							showProgressPopup(PatternStringUtil.patternToString(getApplicationContext(),
									R.string.file_initialization,
									getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
						}
					});
				}
				//連続作業の全削除ボタンタップ時のインジケーター表示
				if (StringUtil.equalsAny(mCmd, ABookKeys.CMD_DELETE_PROCESS)) {
					showProgressPopup(PatternStringUtil.patternToString(getApplicationContext(),
							R.string.msg_common_processing,
							getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
				}

				if (isOperationPdf && operationTaskDto != null && StringUtil.equalsAny(mCmd,
						ABookKeys.CMD_INSERT_TASK_REPORT,
						ABookKeys.CMD_UPDATE_TASK_REPORT,
						ABookKeys.CMD_MOVE_HOT_SPOT,
						ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT)) {
					String taskCode = "";

					if (abookCheckParam.get(ABookKeys.TASK_REPORT) != null) {
						JSONObject tastReportJson = new JSONObject(abookCheckParam.get(ABookKeys.TASK_REPORT));
						JSONObject taskJson = tastReportJson.getJSONObject(ABookKeys.TASK);
						Iterator taskKeys = taskJson.keys();
						while (taskKeys.hasNext()) {
							String itemKey = (String) taskKeys.next();
							if (itemKey.startsWith("q_1_")) {
								taskCode = taskJson.getString(itemKey);
							}
						}
					}

					if (abookCheckParam.get(ABookKeys.HOT_SPOT) != null) {
						JSONObject hotSpot = new JSONObject(abookCheckParam.get(ABookKeys.HOT_SPOT));
						hotSpot.put(ABookKeys.SCENE_ID, mCurrentPageNumber + 1);

						hotSpot.put(ABookKeys.PDF_X, operationTaskDto.pdfX);
						hotSpot.put(ABookKeys.PDF_Y, operationTaskDto.pdfY);

						if (!StringUtil.isNullOrEmpty(taskCode)) {
							hotSpot.put(ABookKeys.TASK_CODE, taskCode);
						}

						abookCheckParam.put(ABookKeys.HOT_SPOT, hotSpot.toString());
					}
				}

				final Callback finishCallback = new Callback() {
					@Override
					public Object callback(Object ret) {
						final boolean isError = (boolean)ret;
                        closeProgressPopup();
						//キー項目あり設定時、送信後、同期処理
						if (mOperationType == OperationType.LIST) { //リスト作業のみ実行
							if (mReportType != RoutineTask) { //定期点検以外
								if (mCmd.equals(ABookKeys.CMD_INSERT_TASK_REPORT) || mCmd.equals(ABookKeys.CMD_UPDATE_TASK_REPORT)) {
									try {
										receptionTaskData(mOperationId, null, null, mTaskKey);
										mOperationLogic.createJsonForOperationContent(mOperationId, mContentPath, false);
									} catch (Exception e) {
										Logger.e(TAG, "createJsonForOperationContent error. " + e);
									}
								}
							}
						}

						// 報告・報告（回答）の切り替えボタンタップ、連続作業の全削除ボタンタップ
						if (mCmd.equals(ABookKeys.CMD_CHANGE_TASK_REPORT) || mCmd.equals(ABookKeys.CMD_DELETE_PROCESS)) {
							afterABookCheckApi(mCmd, mTaskKey, 0, "", null, isOperationPdf());
							if (mCmd.equals(ABookKeys.CMD_DELETE_PROCESS)) {
								if (isError) {
									showSimpleAlertDialog(R.string.error,R.string.msg_error_all_process_delete);
								}
							}
							return null;
						}

						if (ActivityHandlingHelper.getInstance().searchOzdActivityStack()) {  // OZD作業画面があるかを確認
							// PDF且つ、一時保存の場合は、以下の処理を行わないでreturn null;で処理を終わらせる
							if (mCmd.equals(ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT) && isOperationPdf) {
								return null;
							}
							if (!isError) {  // エラーがなしの場合
								if (mAddReport) {  // 作業追加ありの場合
									// コールバック処理のみ行う。
									afterABookCheckApi(mCmd, mTaskKey, 0, "", null, isOperationPdf());
								}
								// 画面遷移処理(一時保存以外)
								if (!mCmd.equals(ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT)) {
									closeCurrentScreen(mReportType);
								}
							}
						} else {
							// ozd画面ではない一時保存処理時、コールバックを呼び出す
							if (mCmd.equals(ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT)) {
								afterABookCheckApi(mCmd, mTaskKey, 0, "", null, isOperationPdf());
								return null;
							}

							if (mAddReport) {  // 作業追加ありの場合
								// コールバック処理のみ行う。
								afterABookCheckApi(mCmd, mTaskKey, 0, "", null, isOperationPdf());
							} else {
								// 作業追加無しの場合、エラー発生時フォーム画面表示を維持するためにコールバックresult:1でする
								if (isError) {
									afterABookCheckApi(mCmd, mTaskKey, 1, "", null, isOperationPdf());
									return null;
								}
							}
							// 画面遷移処理
							closeCurrentScreen(mReportType);
						}

						//サーバ通信中にメモリ上のホットスポット情報が更新されない問題で、サーバ通信後に更新する処理追加
						if(isOperationPdf) {
							switch (mCmd) {
								case ABookKeys.CMD_INSERT_TASK_REPORT:            // 作業報告の登録
								case ABookKeys.CMD_UPDATE_TASK_REPORT:            // 作業報告の更新
								case ABookKeys.CMD_DELETE_TASK_REPORT:            // 作業報告の削除
								case ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT:            // 一時保存
								case ABookKeys.CMD_DELETE_PROCESS:
									getTaskHotspotJSON();
									break;
							}
						}
						return null;
					}
				};

				ABookCheckWebViewHelper.getInstance().doABookCheckParam(ABVContentViewActivity.this,
						mCmd, mTaskKey, mEnableReportHistory, abookCheckParam, mOperationId, mContentPath, getContentId(),
						operationDto.reportType, finishCallback, taskReportLevel);

				if (StringUtil.equalsAny(mCmd,ABookKeys.CMD_INSERT_TASK_REPORT, ABookKeys.CMD_UPDATE_TASK_REPORT,
						ABookKeys.CMD_DELETE_TASK_REPORT , ABookKeys.CMD_CANCEL_TASK_REPORT, ABookKeys.CMD_LOCAL_SAVE_TASK_REPORT)
				){
					// 作業一覧に戻る時,bluetoothを切断する。
					disconnectBluetoothDevice();
				}

			} catch(Exception e) {
				Logger.e(TAG, "doABookCheckParam error", e);
			}
			if(isOperationPdf) {
				onActionOperationPdfWebView(abookCheckParam, operationTaskDto);
			}
		} else if (mCmd.equals(ABookKeys.CMD_CHANGE_DISPLAY_STATUS)) {
			mStatusCode = Integer.valueOf(abookCheckParam.get(ABookKeys.STATUS_CODE));
			commonConfigureHeader();
			if(isOperationPdf) {
				onActionOperationPdfWebView(abookCheckParam, operationTaskDto);
			}
		} else if (mCmd.equals(ABookKeys.CMD_SAVE_ATTACHED)) {
			mAttachedFileName = abookCheckParam.get(ABookKeys.FILE_NAME);
			//編集可否を判別
			mEnablePhotoEdit = abookCheckParam.get(ABookKeys.EDITABLE) == null ? "0" : abookCheckParam.get(ABookKeys.EDITABLE);	//添付したファイルの編集可否のパラメタ
			getAttachedDataUrl(abookCheckParam.get(ABookKeys.TASK_KEY));
		} else if (mCmd.equals(ABookKeys.CMD_EDIT_ATTACHED)) {
			//編集パラメタ(
			mAttachedFileName = abookCheckParam.get(ABookKeys.FILE_NAME);	//再編集するファイルの名
			mEditFilePath = abookCheckParam.get(ABookKeys.FILE_PATH);	//再編集するファイルのパス
			openEditPage();
		} else if (mCmd.equals(ABookKeys.CMD_SHOW_REPORT_OZD)) {
			mReportFileName = abookCheckParam.get(ABookKeys.REPORT_FILE_NAME);
			// 作業報告画面改善
			boolean mLocalSave = false;  // 一時保存情報
			if (abookCheckParam.containsKey(ABookKeys.LOCAL_SAVE)) {
				mLocalSave = Integer.parseInt(abookCheckParam.get(ABookKeys.LOCAL_SAVE)) > 0 ? true : false;
			}
			ActivityHandlingHelper.getInstance().startOZViewerActivity(this, mOperationId, getContentId(), mTaskKey, false, taskReportId, reportStartDate, mReportFileName, mLocalSave, mAddReport, taskReportLevel, processKey, phaseNo);
		} else if (mCmd.equals(ABookKeys.CMD_PREVIEW_REPORT_OZD)) {
			mReportFileName = abookCheckParam.get(ABookKeys.REPORT_FILE_NAME);
			// 作業報告画面改善
			ActivityHandlingHelper.getInstance().startOZViewerActivity(this, mOperationId, getContentId(), mTaskKey, true, taskReportId, reportStartDate, mReportFileName, false, true, taskReportLevel, processKey, phaseNo);
		} else if (mCmd.equals(ABookKeys.CMD_CONTENT_EDIT_CLOSE)) {
			showProgressPopup();
			handler.postDelayed(new Runnable() {
				@Override
				public void run() {
					closeProgressPopup();
					finish();
				}
			}, 5000);
		} else if (mCmd.equals(ABookKeys.CMD_GET_GPS_INFO)) {
			// #32926 作業報告画面改善 start
			setLocation((Integer.valueOf(abookCheckParam.get(ABookKeys.GPS_TYPE)) != 1));
			// #32926 作業報告画面改善 end
		} else if (mCmd.equals(ABookKeys.CMD_SCENE_REGIST)) {
			String successFlg = abookCheckParam.get(ABookKeys.SUCCESS_FLG);
			if(Integer.parseInt(successFlg) == 0) {
				// リソースパターンの適用
				ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(this, PatternStringUtil.patternToInt(getApplicationContext(),
																									R.string.pano_edit,
																									getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
				alertDialog.setMessage(PatternStringUtil.patternToInt(getApplicationContext(),
											R.string.msg_sence_regist_failed,
											getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)));
				alertDialog.setPositiveButton(R.string.ok,
						new DialogInterface.OnClickListener() {
							@Override
							public void onClick(DialogInterface dialog, int which) {
								dialog.dismiss();

							}
						});
				alertDialog.show();
			} else {
				progressDialog.setProgress(100);
				// 成功
				Logger.i(TAG, ABookKeys.CMD_SCENE_REGIST + "is success");
				progressDialog.setProgress(0);
			}
			closeProgressPopup();
		} else if (mCmd.equals(ABookKeys.CMD_MOVE_PAGE)) {
			onActionOperationPdfWebView(abookCheckParam, operationTaskDto);
		} else if (mCmd.equals(ABookKeys.CMD_SHOW_RELATED_CONTENT)) {
			try {
				long linkedContentId = Long.valueOf(abookCheckParam.get(ABookKeys.CONTENT_ID));
				int pageNum = Integer.valueOf(abookCheckParam.get(ABookKeys.CMD_PAGE_NUM));

				//ダウンロード完了後、開く時に必要
				isLinkedContent = true;
				pageNo = pageNum -1 ;

				if (ActivityHandlingHelper.getInstance().checkContent(linkedContentId, pageNo)) { // コンテンツをチェックし、なければDL後開く
					ActivityHandlingHelper.getInstance().startContentActivityForLinkedConent(mOperationId, linkedContentId, pageNo);
				}
			} catch (Exception e) {
				Logger.e(TAG, "startContentActivity failed.", e);
				ErrorMessage.showErrorMessageToast(getApplicationContext(), ErrorCode.E107);
			}
		} else if (mCmd.equals(ABookKeys.CMD_GET_GROUP_TREE_INFO)) {
			List<JSONObject> groups = groupLogic.getAllGroupsJson();
			afterABookCheckApi(mCmd, null, 0, "getAllGroups", groups.toString());
		} else if (mCmd.equals(ABookKeys.CMD_CLOSE_TASK_LIST)) {
			if (mXWalkOpenType == Constant.XWalkOpenType.PANO_EDIT) {
				showConfirmSavePanoEdit();
			} else {
				// 作業終了する時、作業ID設定して作業一覧で使用するメソットを行う。
				putUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, mOperationId);
				finishActivity();  // 開いてる画面を閉じる
			}
		} else if (mCmd.equals(ABookKeys.CMD_LOAD_USER_DATA)) {
			// 前回の入力内容を読み込む
			Logger.d(TAG,"load taskKey = " + abookCheckParam.get(ABookKeys.TASK_KEY));
			loadUserDataKey(abookCheckParam.get(ABookKeys.TASK_KEY));
		} else if (mCmd.equals(ABookKeys.CMD_SAVE_USER_DATA)) {
			// 入力内容を保存する
			Logger.d(TAG,"save taskKey = " + abookCheckParam.get(ABookKeys.TASK_KEY));
			Logger.d(TAG,"save userData = " + abookCheckParam.get(ABookKeys.USER_DATA));
			saveUserDataKey(abookCheckParam.get(ABookKeys.TASK_KEY), abookCheckParam.get(ABookKeys.USER_DATA));
		} else if (mCmd.equals(ABookKeys.CMD_GET_DEVICE_INFO)) {
			if (!isAlcBlock) {
				isAlcBlock = true;
				Logger.d(TAG, "getDeviceInfo");
				getDeviceInfo(abookCheckParam);
			}
		}
	}

	/**
	 * アルコールチェッカー、userDataのルートディレクトリを返す
	 * 通常　cache/userData/
	 * @return ルートディレクトリ
	 */
	private String getUserDataDirRoot() {
		Logger.d(TAG,"userDataDirRoot = %s", ABVEnvironment.getInstance().cacheDirectory + ABVEnvironment.getInstance().userDataDir);

		return ABVEnvironment.getInstance().cacheDirectory + ABVEnvironment.getInstance().userDataDir;
	}

	/**
	 * JSから送られてきたキーデータを保存する
	 * @param userKeyFileName 保存するユーザーキーファイル名
	 * @param userData 保存するデータ
	 */
	private void saveUserDataKey(String userKeyFileName, String userData) {
		if (StringUtil.isNullOrEmpty(userKeyFileName)) {
			Logger.d(TAG,"userKeyFileName is null or empty.");
			// 読み込むためのキーがない
			afterABookCheckApi(ABookKeys.CMD_SAVE_USER_DATA, userKeyFileName, 1, "", "");
			return;
		}

		// フォルダ作成（すでに存在するなら作成はされない）
		String userDataFolderRoot = getUserDataDirRoot();
		FileUtil.createNewDirectory(userDataFolderRoot + ABVDataCache.getInstance().getMemberInfo().loginId);
		File[] userDirs = FileUtil.listFiles(userDataFolderRoot);

		for (File dir : userDirs) {
			try {
				Logger.d(TAG, "getAbsolutePath = %s", dir.getAbsolutePath());

				// 一番下のフォルダ名 = ユーザーID
				String userId = FileUtil.getLastChildDirectoryName(dir);
				Logger.d(TAG,"userId = %s", userId);

				if (!ABVDataCache.getInstance().getMemberInfo().loginId.equals(userId)) {
					// ログインしているユーザー以外のものは削除
					FileUtil.delete(dir);
					continue;
				}

				BufferedWriter bw = null;
				if (userData != null) {
					try {
						FileOutputStream fo = new FileOutputStream(userDataFolderRoot + "/" + userId + "/" + userKeyFileName);
						OutputStreamWriter osw = new OutputStreamWriter(fo, StandardCharsets.UTF_8);
						bw = new BufferedWriter(osw);
						bw.write(userData);
						bw.close();
					} catch (IOException e) {
						Logger.e(TAG, "" + e);
					} finally {
						try {
							if (bw != null) {
								bw.close();
							}
						} catch (IOException e) {
							Logger.e(TAG,"" + e);
						}
					}
					afterABookCheckApi(ABookKeys.CMD_SAVE_USER_DATA, userKeyFileName, 0, "", "");
				}
			} catch (IndexOutOfBoundsException iobex) {
				Logger.e(TAG,"" + iobex);
			}
		}
	}

	/**
	 * キーデータファイルを読み込んで、JSにわたす
	 * @param userKeyFileName ファイル名
	 */
	private void loadUserDataKey(String userKeyFileName) {

		if (StringUtil.isNullOrEmpty(userKeyFileName)) {
			Logger.d(TAG,"userKeyFileName is null or Empty");
			// ファイル名が指定されていない
			afterABookCheckApi(ABookKeys.CMD_LOAD_USER_DATA, userKeyFileName, 1, "", "");
			return;
		}

		String keyFilePath = getUserDataDirRoot() + "/" + ABVDataCache.getInstance().getMemberInfo().loginId + "/" + userKeyFileName;
		Logger.d(TAG,"keyFilePath = " + keyFilePath);

		FileInputStream fi = null;
		InputStreamReader isr = null;

		try {
			StringBuffer sb = new StringBuffer();

			fi = new FileInputStream(keyFilePath);
			isr = new InputStreamReader(fi, StandardCharsets.UTF_8);

			int data;
			while((data = isr.read()) != -1) {
				sb.append((char)data);
			}
			isr.close();
			Logger.d(TAG,"result = " + sb.toString());
			afterABookCheckApi(ABookKeys.CMD_LOAD_USER_DATA, userKeyFileName, 0, "", sb.toString());
			return;
		} catch (FileNotFoundException fex) {
			Logger.e(TAG,"" + fex);
		} catch (IOException e) {
			Logger.e(TAG,"" + e);
		} finally {
			try {
				if (isr != null) {
					isr.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		// 何かしらのExceptionが発生した
		afterABookCheckApi(ABookKeys.CMD_LOAD_USER_DATA, userKeyFileName, 1, "", "");
	}

	public void commonAttachedDataUrl (String taskKey, String data) {
		boolean isError = false;
		if (data != null) {
			try {
				String imagePath = ABVEnvironment.getInstance().getTempFilePath(getContentId(), taskKey, mAttachedFileName);
				ABookCheckWebViewHelper.getInstance().decodeToImage(data, imagePath);
				//アプリ内のファイルのみ削除（Galleryファイルは削除しない）
				if (mLocalFile != null && mLocalFile.getPath().contains(getPackageName())) {
					FileUtil.delete(mLocalFile);
				}
				mLocalFile = null;
				//編集可能可否をチェックする。
				if (mEnablePhotoEdit.equals("1")) { //編集の場合、編集画面を開ける。
					commonOpenEditPage();
				}
			} catch (Exception e) {
				isError = true;
				Logger.e(TAG, e);
			}
		}
		afterABookCheckApi(mCmd, taskKey, isError ? 1 : 0, "", null);
	}

	protected Uri attachmentImageProcessing(Uri uri) throws Exception {
		if (uri == null) {
			return null;
		}
		String[] operationion = {MediaStore.MediaColumns.DATA};
		Cursor cursor = getContentResolver().query(uri, operationion, null, null, null);
		String photoFilePath = ABookCheckWebViewHelper.getInstance().contentSchemeUriToFilePath(cursor);
		try {
			int rotationAngle = ABookCheckWebViewHelper.getInstance().rotateBitmapOrientation(photoFilePath);
			if (rotationAngle == 0) {
				mLocalFile = new File(photoFilePath);
			} else {
				mLocalFile = ABookCheckWebViewHelper.getInstance().rotateBitmapToImageFile(rotationAngle, photoFilePath, ABVEnvironment.getInstance().getContentCacheDirectoryPath(getContentId()));
			}
			if (mLocalFile.exists()) {
				return Uri.fromFile(mLocalFile);
			}
		} catch (FileNotFoundException e) {
			Logger.e(TAG, "image file is not found", e);
		}
		return null;
	}

	public void afterABookCheckApi(final String cmd, final String taskKey, final int result, final String message, final String extParam) {
		afterABookCheckApi(cmd, taskKey, result, message, extParam, false);
	}

	public void afterABookCheckApi(final String cmd, final String taskKey, final int result, final String message, final String extParam, final boolean isParent) {
		Logger.d(TAG, "run javaScript for ABookCheck : cmd=%s, taskKey=%s, result=%s, message=%s", cmd, taskKey, result, message);
		final String finalParent = isParent ? "window.parent." : "";
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				if (extParam != null) {
					Logger.i(TAG, String.format("javascript:%sCHK.afterABookCheckApi('%s', '%s', '%s', '%s', %s)", finalParent, cmd, taskKey, result, message, extParam));
					webViewLoadUrl(String.format("javascript:%sCHK.afterABookCheckApi('%s', '%s', '%s', '%s', %s)", finalParent, cmd, taskKey, result, message, extParam));
				} else {
					Logger.i(TAG, String.format("javascript:%sCHK.afterABookCheckApi('%s', '%s', '%s', '%s')", finalParent, cmd, taskKey, result, message));
					webViewLoadUrl(String.format("javascript:%sCHK.afterABookCheckApi('%s', '%s', '%s', '%s')", finalParent, cmd, taskKey, result, message));
				}
				if (cmd.equals(ABookKeys.CMD_GET_DEVICE_INFO)) {
					// アルコールチェッカー終了
					isAlcBlock = false;
				}
			}
		});
	}

	protected  void commonConfigureHeader() {
	}

	/**
	 * 添付ファイルのBase64文字列取得
	 */
	public void getAttachedDataUrl(final String taskKey) {
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				webViewLoadUrl("javascript:android.getAttachedDataUrl('" + taskKey + "', CHK.getAttachedDataUrl())");
			}
		});
	}

	public void openEditPage(){
		webViewLoadUrl("javascript:android.openEditPage()");
	}

	/**
	 * 位置情報取得
	 * @param showPermissionDialogFlg
	 */
	// #32926 作業報告画面改善 start
	protected void setLocation(final boolean showPermissionDialogFlg) {
		// #32926 作業報告画面改善 end
		ABookPermissionHelper helper = new ABookPermissionHelper(this, Constant.ABookPermissionType.AccessFineLocation, null);
		if (helper.checkMultiPermissions(showPermissionDialogFlg)) {
			// 位置情報取得
			LocationManagerUtil locationManagerUtil = new LocationManagerUtil(this, new LocationManagerUtil.LocationManagerUtilListener() {
				@Override
				public void onGetLocationFailed() {
					Logger.w(TAG, "onGetLocationFailed");
					// #32926 作業報告画面改善 end
						afterABookCheckApi(mCmd, "", 1, PatternStringUtil.patternToString(getApplicationContext(),
																			R.string.msg_location_search_fail,
																			getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), null);
				}

				@Override
				public void onGetLocation(final Location location) {
					latitude = location.getLatitude();
					longitude = location.getLongitude();
					Logger.v(TAG, "location latitude(%s), longitude(%s)", latitude, longitude);
					CommonExecutor.execute(new Runnable() {
						@Override
						public void run() {
							JSONObject json = new JSONObject();
							json.put("latitude", latitude);
							json.put("longitude", longitude);
							afterABookCheckApi(mCmd, "", 0, "", json.toString());
						};
					});
				}
			});
			locationManagerUtil.startLocationService();
		} else {
			Logger.w(TAG,"onGetLocationFailed AccessFineLocation false");
			// リソースパターンの適用
			afterABookCheckApi(mCmd, "", 1, PatternStringUtil.patternToString(getApplicationContext(),
					R.string.msg_location_search_fail,
					getUserPref(AppDefType.UserPrefKey.RESOURCE_PATTERN_TYPE, 0)), null);
		}
	}

	protected boolean isOperationPdf() {
		return isOperationPdf;
	}

	/**
	 * 報告可能フラグ
	 * @return
	 */
	public boolean isReportEdit() {
		return mEnableReportEdit == Constant.EnableReportEdit.YES;
	}

	/**
	 * PDF操作インスタンスを作成
	 * @param pdfFileName
	 * @return
	 * @throws Exception
	 */
	public FoxitPdfCore initPdf(String pdfFileName) throws Exception {
		Logger.d(TAG, "post intent to open file pdfFileName=" + pdfFileName);
		String filepath = mContentDir + "/" + pdfFileName;
		if (!FileUtil.exists(filepath)) {
			return null;
		}
		return new FoxitPdfCore(this, filepath);
	}

	// 保存処理
	public void ozdSaveProcess() {
		runOnUiThread(new Runnable() {
			@Override
			public void run () {
				// 実行Javascript - 保存
				ActivityHandlingHelper.getInstance().callOzdHtmlScript("javascript:CHK.saveOzReport()");
				Logger.d(TAG, "ozdSaveProcess");
			}
		});
	}

	// 一時保存処理
	public void ozdLocalSaveProcess() {
		runOnUiThread(new Runnable() {
			@Override
			public void run () {
				// 実行Javascript - 一時保存
				ActivityHandlingHelper.getInstance().callOzdHtmlScript("javascript:CHK.localSaveOzReport()");
				Logger.d(TAG, "ozdLocalSaveProcess");
			}
		});
	}

	// 閉じる処理
	public void ozdCancelProcess() {
		runOnUiThread(new Runnable() {
			@Override
			public void run () {
				// 実行Javascript - 閉じる
				ActivityHandlingHelper.getInstance().callOzdHtmlScript("javascript:CHK.afterABookCheckApi('"+ABookKeys.CMD_CANCEL_TASK_REPORT+"', '', '0', '')");
				ActivityHandlingHelper.getInstance().reloadPdfTaskIcon(mTaskKey);
				Logger.d(TAG, "ozdCancelProcess");
			}
		});
	}

	// 削除処理
	public void ozdDeleteProcess() {
		runOnUiThread(new Runnable() {
			@Override
			public void run () {
				// 実行Javascript - 閉じる
				ActivityHandlingHelper.getInstance().callOzdHtmlScript("javascript:CHK.deleteOzReport()");
				Logger.d(TAG, "ozdDeleteProcess");
			}
		});
	}

	// 作業一覧画面に遷移
	public void goToMain() {
		ActivityHandlingHelper.getInstance().finishAllContentViewActivity(); // 一覧画面に遷移
	}

	// 押したボタンによってHTML側の処理を行う
	public void doProcess() {
		if (this instanceof CheckOZDViewActivity) {
			if (mButtonStatus == R.id.btn_close) {
				ozdCancelProcess();  // 閉じる
			} else if (mButtonStatus == R.id.btn_temp_save) {
				ozdLocalSaveProcess();  // 一時保存
			} else if (mButtonStatus == R.id.btn_save) {
				ozdSaveProcess(); // 保存
			} else if (mButtonStatus == R.id.btn_delete) {
				ozdDeleteProcess(); // 削除
			}
		}
	}

	// 作業終了する時、作業ID設定し、画面遷移処理
	public void closeCurrentScreen(int reportType) {

		if (mAddReport) { // 作業追加あり
			if (ActivityHandlingHelper.getInstance().searchOzdActivityStack()) {  // OZD画面で画面遷移処理
				ActivityHandlingHelper.getInstance().selectedOzdActivityClose();  // 開いてる画面を閉じる
			}
		} else {  // 作業追加なし
			putUserPref(AppDefType.UserPrefKey.SYNC_TARGET_OPERATION_ID, mOperationId);  // 作業IDの設定
			if (ActivityHandlingHelper.getInstance().searchOzdActivityStack()) {  // OZD画面で画面遷移処理
				goToMain();  // 一覧画面に遷移
			} else {
				finishActivity();  // 一覧画面に遷移
			}
		}
	}

	/**
	 * 下位のWebviewからコールする編集画面
	 */
	public void commonOpenEditPage(){
		//ダイアローグの上、新しいViewを作るため、Threadで実行する。Threadを使わない場合エラー発 生
		runOnUiThread(new Runnable() {
			@Override
			public void run() {
				//添付した写真はTempパスにある。
				//保存されてある写真はoperationフォルダにある。
				//保存されてある写真を修正する場合、ファイルをTempにコピーした後に編集する。
				final String taskKey = mTaskKey;
				final String attachedFilename = mAttachedFileName;
				final String cmd = mCmd;
				Long operationId = mOperationId;
				final String tempImagePath = ABVEnvironment.getInstance().getTempFilePath(getContentId(), taskKey, attachedFilename);	//添付ファイルのTempパス
//				String savedImagePath = ABVEnvironment.getInstance().getOperationTaskReportLevelDirPath(operationId, taskKey,0) + "/" + attachedFilename;	//保存された写真のパス
				//保存されたイメージがあり、編集したいイメージのパスがTempがない場合、ファイルをTempにコピー
				//	パスがTempと一緒の場合、イメージが一回以上修正され、上書きしない。
				if(mEditFilePath != null && !mEditFilePath.equals(tempImagePath)){
					try {
						File editFile = new File(mEditFilePath);
						String savedImagePath = getDataDir().toString() + editFile.getCanonicalPath();
						if(FileUtil.exists(savedImagePath)) {
							FileUtil.copy(savedImagePath, tempImagePath, true); //保存されたファイルをTempパスにコピー
						}
					} catch (IOException e) {
						e.printStackTrace();
						return;
					}
				}
				if(FileUtil.exists(tempImagePath)){	//Tempパスにファイルがある場合、編集を実行
					//編集画面をコール
					if(!isNormalSize() && isRotatable()) {
						setFixedOrientation(true); //回転固定
					}
					PhotoEditActivity dialog = new PhotoEditActivity(ABVContentViewActivity.this, tempImagePath); //ロードして編集するイメージのパスを設定
					showPhotoEditDialog(dialog);
					dialog.setOnDismissListener(new DialogInterface.OnDismissListener() {
						@Override
						public void onDismiss(DialogInterface dialogInterface) {
							//Web Cacheが更新されて編集画面のダイアローグ閉じた後、JavascriptにてImgタグを再生成してThumbnailを更新
							webViewLoadUrl(String.format("javascript:CHK.changeReportFormThumbnailImageForAnd('%s','%s')", attachedFilename, tempImagePath));
							afterABookCheckApi(cmd, taskKey, 0, "", null);
							mPhotoEditDialog = null;
							mEditFilePath = null;
							if(!isNormalSize() && isRotatable()) {
								setFixedOrientation(false); ////回転可能
							}
						}
					});
				}
				else{
					Logger.e(TAG, "image file is not found");
					showSimpleAlertDialog(R.string.error,R.string.msg_error_edit_page_open);
				}
			}
		});
	}

	protected void showPhotoEditDialog(PhotoEditActivity photoEditDialog) {
		if (this.mPhotoEditDialog != null) {
			this.mPhotoEditDialog.dismiss();
		}
		else {
			this.mPhotoEditDialog = photoEditDialog;
			this.mPhotoEditDialog.show();
		}
	}

	/**
	 * 全Bluetoothデバイスとの接続を切る
	 */
	private void disconnectBluetoothDevice() {
		Logger.d(TAG, "disconnectBluetoothDevice");
		if (alcoholCheckerUtil != null) {
			alcoholCheckerUtil.finish();
			alcoholCheckerUtil = null;
		}
	}

	/**
	 * ContentViewActivity子クラスで実行
	 */
	protected void getTaskHotspotJSON() {}
}