package jp.agentec.abook.abv.ui.common.activity;

import android.content.DialogInterface;
import android.widget.Toast;

import jp.agentec.abook.abv.bl.acms.type.LoginStatus;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.Callback;
import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.exception.ABVException;
import jp.agentec.abook.abv.bl.common.log.LogLevel;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.environment.DeviceInfo;
import jp.agentec.abook.abv.cl.push.FcmManager;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;

/**
 * Login処理の共通ロジックを実装する
 * @author jang
 *
 */
public abstract class ABVLoginActivity extends ABVNoAuthenticatedActivity {
	private static final String TAG = "ABVLoginActivity";

	/**
	 * サーバ認証後、ローカルのデータの削除が必要であればアラートを表示する。<br>
	 * 必要なければユーザ情報を保存する。
	 */
	protected void fcmRegister() {
		final Callback resultCallback = new Callback() {
			@Override
			public Object callback(Object ret) {
				String fcmToken = (String)ret;
				if (fcmToken == null) {
					Logger.w(TAG, "[fcmRegister]: FCM Token is null.");
					runOnUiThread(new Runnable() {
						@Override
						public void run() {
							AlertDialogUtil.showAlertDialog(ABVLoginActivity.this, R.string.app_name, R.string.msg_get_device_token_fail, true, new DialogInterface.OnClickListener() {
								@Override
								public void onClick(DialogInterface dialogInterface, int i) {
									// FCMトークンを取得できない場合、noneIdでセットしてログインする
									CommonExecutor.execute(new Runnable() {
										@Override
										public void run() {
											serverLoginAndCheckChangeUser("");
										}
									});
								}
							});
						}
					});
				} else {
					serverLoginAndCheckChangeUser(fcmToken);
				}
				return null;
			}
		};

		FcmManager.getFcmToken(this, resultCallback);
	}

	/**
	 * MACアドレスを取得し、envにセットする。
	 * 
	 * @throws ABVException
	 */
	protected void loadWifiMacAddress() throws ABVException {
        // Android 6以上場合はMacAddressが取得できないためSkipする
        if (android.os.Build.VERSION.SDK_INT >= 23) {
            return;
        }
		boolean isDebugMode = LogLevel.level(getRInteger(R.integer.log_level)).level() <= LogLevel.debug.level();
		ABVEnvironment.getInstance().deviceId = DeviceInfo.getDeviceId(this, isDebugMode);
		ABVEnvironment.getInstance().encryptKey = DeviceInfo.getEncryptKey(this, isDebugMode);
	}
	
	protected abstract void serverLoginAndCheckChangeUser(String deviceToken);
}
