package jp.agentec.abook.abv.ui.common.dialog;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.view.ABVImageLineButton;
import jp.agentec.abook.abv.ui.common.view.ABVMarkingSettingPreviewView;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RadioButton;

public class ContentColorPickerView {

	private static final int COLOR_MAXSIZE = 12;
	private static final int RADIO_MAXSIZE = 5;
	private int mRadioSize[];

	private int mPenSize;
	private int mColor;
	private int mType;

	private int eraserPreviewColor = 0xFF000000;

	private ABVMarkingSettingPreviewView mSelectColor;

	public ContentColorPickerView() {
		super();
	}

	public View createColorPickerView(Context context, int type, int penSize, int color) {
		mPenSize = penSize;
		mColor = color;
		mType = type;

		LayoutInflater layoutInflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View viewSettingPaint = layoutInflater.inflate(R.layout.setting_marking, null);
		String packageName = context.getPackageName();

		RadioButton mRadioSizeButton;
		mRadioSize = new int[RADIO_MAXSIZE];
		int radioId;
		int radioSize_id;
		for (int i = 0; i < RADIO_MAXSIZE; i++) {
			// 太さ設定
			radioSize_id = context.getResources().getIdentifier("marking_size_" + String.valueOf(i), "integer", packageName);
			mRadioSize[i] = context.getResources().getInteger(radioSize_id);

			// 太さ設定ボタン
			radioId = context.getResources().getIdentifier("radio_size_" + String.valueOf(i), "id", packageName);
			mRadioSizeButton = (RadioButton) viewSettingPaint.findViewById(radioId);
			final int index = i;

			// 選ばれているものをチェック
			if (mRadioSize[i] == penSize) {
				mRadioSizeButton.setChecked(true);
			}

			mRadioSizeButton.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					mPenSize = mRadioSize[index];
					setSelect();
				}
			});
		}

		mSelectColor = (ABVMarkingSettingPreviewView) viewSettingPaint.findViewById(R.id.imgBtnSelectColor);
		setSelect();

		ABVImageLineButton arrayColorBtn;
		for (int i = 0; i < COLOR_MAXSIZE; i++) {
			int imgBtnColor_id = context.getResources().getIdentifier("imgBtnColor" + String.valueOf(i), "id", packageName);
			arrayColorBtn = (ABVImageLineButton) viewSettingPaint.findViewById(imgBtnColor_id);
			int color_id = context.getResources().getIdentifier("marking_color_" + String.valueOf(i), "color", packageName);
			final int setBtnColor = context.getResources().getColor(color_id);
			arrayColorBtn.setBackgroundColor(setBtnColor);
			arrayColorBtn.setOnClickListener(new View.OnClickListener() {
				@Override
				public void onClick(View v) {
					mColor = setBtnColor;
					mSelectColor.setSelect(mPenSize, mColor);
				}
			});
		}

		// 消しゴムの場合色選択は非表示
		if (mType == 2) {
			LinearLayout layout = (LinearLayout) viewSettingPaint.findViewById(R.id.layoutColor);
			layout.setVisibility(View.GONE);
		}

		return viewSettingPaint;
	}

	private void setSelect() {
		if (mType == 2) {
			mSelectColor.setSelect(mPenSize, eraserPreviewColor);
		} else {
			mSelectColor.setSelect(mPenSize, mColor);
		}
	}

	public int getPenSize() {
		return mPenSize;
	}

	public int getColor() {
		return mColor;
	}

	public int getType() {
		return mType;
	}
}
