package jp.agentec.abook.abv.ui.common.helper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.widget.Toast;

import jp.agentec.abook.abv.bl.acms.type.LoginMode;
import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.ContractLogic;
import jp.agentec.abook.abv.bl.logic.UserAuthenticateLogic;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppDefType;
import jp.agentec.abook.abv.ui.common.util.ABVToastUtil;
import jp.agentec.abook.abv.ui.home.activity.ABookSettingActivity;
import jp.agentec.abook.abv.ui.home.activity.LoginActivity;

/**
 * ログアウトする時に使用するヘルパークラス
 * 複数個所で、ログアウトする契機があるので、まとめた。
 */
public class LogoutHelper {

    /**
     * ログアウトして、ログイン画面に遷移する
     *
     * @param activity  呼び出し元アクティビティ
     */
    public static void logout(Activity activity) {
        logout(activity, false, true);
    }

    /**
     * ログアウトして、ログイン画面に遷移する
     *
     * @param activity  呼び出し元アクティビティ
     * @param removeLoginInfo  ログイン情報をクリアする場合はtrue
     * @param launchLogin trueならLoginActivityをstart
     */
    public static void logout(Activity activity, boolean removeLoginInfo, boolean  launchLogin) {
        try {
            // modify by Jang 2013.06.20
            UserAuthenticateLogic user = AbstractLogic.getLogic(UserAuthenticateLogic.class);
            // ログイン情報がある場合のみログアウト処理を行う
            if (user.getMemberInfo() != null) {
                user.signoutUser();
                // Widgetへ通知
                Intent intent = new Intent();
                activity.sendBroadcast(intent);
            }
        } catch (Exception e) {
            Logger.w("signoutUser failed at callLoginActivity", e);
            ABVToastUtil.showMakeText(activity, R.string.ERROR, Toast.LENGTH_SHORT);
        }

        // 新着更新が実行されている場合停止
        if (activity instanceof ABookSettingActivity) {
            ((ABookSettingActivity)activity).stopContentRefresher();
        }

        SharedPreferences sharedPreferences = activity.getSharedPreferences(AppDefType.PrefName.USER_PREFERENCE, Context.MODE_PRIVATE);
        sharedPreferences.edit().remove(AppDefType.UserPrefKey.GUEST_LOGIN).apply();

        boolean isLoginModePath = activity.getResources().getInteger(R.integer.login_mode) == LoginMode.PATH_ID_PASS;
        boolean isLoginModeSite = activity.getResources().getInteger(R.integer.login_mode) == LoginMode.SITE_PATH_ID_PASS;

        if (removeLoginInfo && (isLoginModePath || isLoginModeSite)) {
            ContractLogic logic = AbstractLogic.getLogic(ContractLogic.class);
            logic.deleteUrlPath();
        }
        if (removeLoginInfo && isLoginModeSite) {
            ABVEnvironment.getInstance().acmsAddress = null;
        }

        if (launchLogin) {
            Intent intent = new Intent(activity, LoginActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NO_HISTORY);
            activity.startActivity(intent);
            activity.finish();
        }
    }
}
