package jp.agentec.abook.abv.ui.common.helper;

import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.activity.ABVActivity;
import jp.agentec.abook.abv.ui.common.dialog.ABookAlertDialog;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import android.content.DialogInterface;

public class NavigationRequestPassForReader extends NavigationContentDownloadForReader {

	private String mRepositoryFqdn;
	private String mShareKey;
	
	public NavigationRequestPassForReader(NavigationForReaderInterface contentReaderInterface, String repositoryFqdn, String shareKey, ABVActivity activity) {
		super(contentReaderInterface, activity);
		mRepositoryFqdn = repositoryFqdn;
		mShareKey = shareKey;
	}

	@Override
	public void moveToNextDisposal() {
		mContentReaderInterface.showPassInput(mRepositoryFqdn, mShareKey);
	}

	@Override
	public void showMessageDialog(String title, String msg) {
		ABookAlertDialog alertDialog = AlertDialogUtil.createAlertDialog(mActivity, title, msg);
		alertDialog.setPositiveButton(R.string.ok, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				moveToNextDisposal();
			}
		});
		
		alertDialog.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
			@Override
			public void onClick(DialogInterface dialog, int which) {
				dialog.dismiss();
				mContentReaderInterface.onFinishPushActivity();
			}
		});
		alertDialog.show();
	}
}
