package jp.agentec.abook.abv.ui.common.util;

import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.view.View.OnSystemUiVisibilityChangeListener;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.ThreadUtil;

public class ViewUtil {

    private static final String TAG = "ViewUtil";
    private static long touchedTime = 0;

	@SuppressLint("InlinedApi")
	public static void configureFullScreen(final View decorView) {
        Logger.d(TAG, "[configureFullScreen]:decorView=" + decorView);
        int option = View.SYSTEM_UI_FLAG_LAYOUT_STABLE
				| View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
				| View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
				| View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
				| View.SYSTEM_UI_FLAG_FULLSCREEN;
		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
			option = option | View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY;
		}
		final int optionF = option;
		decorView.setSystemUiVisibility(option);
		decorView.setOnSystemUiVisibilityChangeListener(new OnSystemUiVisibilityChangeListener(){
			@Override
			public void onSystemUiVisibilityChange(int visibility) {
				decorView.setSystemUiVisibility(optionF);
			}
		});
	}

    /**
     * 1秒間タッチをロックするかしないか
     * ただし、1秒以内に同様のチェックを使っている他のボタンがあった場合、
     * 同様にロックされるので注意！
     * @return true : ロックが必要, false：ロック不要
     */
	public static boolean isTouchLock() {
        return isTouchLock(1000);
    }

	public static boolean isTouchLock(final long delayTime) {
        if (System.currentTimeMillis() - touchedTime < delayTime) {
            return true;
        }
        touchedTime = System.currentTimeMillis();
        new Thread(new Runnable() {
            @Override
            public void run() {
                ThreadUtil.sleep(delayTime);
                touchedTime = 0;
            }
        }).start();
        return false;
    }



}
