package jp.agentec.abook.abv.ui.common.view;

import jp.agentec.abook.abv.launcher.android.R;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.EditText;

/**
 * 入力テキストをクリアできる機能あり
 * @author jang
 *
 */
public class ABVEditText extends EditText {

	private int deletePixelSize;
	
	public ABVEditText(Context context) {
		super(context);
		init();
	}

	public ABVEditText(Context context, AttributeSet attrs) {
		super(context, attrs);
		init();
	}

	public ABVEditText(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
		init();
	}
	
	private void init() {
		float density = getResources().getDisplayMetrics().density;
		deletePixelSize = (int) (30f *density +0.5f);
	}
	
	@Override
	public void setCompoundDrawablesWithIntrinsicBounds(int left, int top,
			int right, int bottom) {
		super.setCompoundDrawablesWithIntrinsicBounds(left, top, R.drawable.ic_delete, bottom);
	}
	
	@Override
	public void setCompoundDrawablesWithIntrinsicBounds(Drawable left,
			Drawable top, Drawable right, Drawable bottom) {
		if (!isInEditMode()) {
			right = getResources().getDrawable(R.drawable.ic_delete);
		}
		super.setCompoundDrawablesWithIntrinsicBounds(left, top, right, bottom);
	}
	
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		float x = event.getX();
		if (getWidth() - deletePixelSize < x) {
			getEditableText().clear();
		}
		return super.onTouchEvent(event);
	}

}
