package jp.agentec.abook.abv.ui.common.vo;

import android.graphics.PointF;

public class Size implements Cloneable {
	public int width;
	public int height;
	
	public Size() {
		this.width = 0;
		this.height = 0;
	}
	
	public Size(int width, int height) {
		this.width = width;
		this.height = height;
	}
	
	public Size(PointF point) {
		this.width = (int)point.x;
		this.height = (int)point.y;
	}
	
	@Override
    public Size clone() {
		return new Size(width, height);
	}
	
	public Size getSwapSize() {
		return new Size(height, width);
	}
	
	@Override
	public String toString() {
		return width + "x" + height;
	}
}
