package jp.agentec.abook.abv.ui.home.adapter;

import jp.agentec.abook.abv.ui.home.adapter.common.SectionRowData;

public class BleListRowData extends SectionRowData {

    public boolean isSaved;
    public String deviceAddress;

    /**
     * デフォルト
     * @param title タイトル
     * @param subTitle サブタイトル
     */
    public BleListRowData(String title, String subTitle) {
        super(title, subTitle);
    }

    /**
     * bluetooth情報
     * @param title bluetoothデバイス名
     * @param deviceAddress bluetoothデバイスアドレス
     * @param isSaved 登録状態
     */
    public BleListRowData(String title, String deviceAddress, boolean isSaved) {
        super(title, null);
        this.deviceAddress = deviceAddress;
        this.isSaved = isSaved;
    }

    /**
     * bluetooth情報
     * @param title  bluetoothデバイス名
     * @param subTitle  通信機器名（中心温度計・放射温度計）
     * @param deviceAddress  bluetoothデバイスアドレス
     * @param isSaved  登録状態
     */
    public BleListRowData(String title, String subTitle, String deviceAddress, boolean isSaved) {
        super(title, subTitle);
        this.deviceAddress = deviceAddress;
        this.isSaved = isSaved;
    }
}
