package jp.agentec.abook.abv.ui.home.helper;

import java.io.File;
import java.io.IOException;

import jp.agentec.abook.abv.bl.common.ABVEnvironment;
import jp.agentec.abook.abv.bl.common.exception.AcmsException;
import jp.agentec.abook.abv.bl.common.exception.NetworkDisconnectedException;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.data.ABVDataCache;

import jp.agentec.abook.abv.bl.download.ContentFileExtractor;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;


public class OzdFileHelper {

    private static final String TAG = "OzdFileHelper";

    private static final String REPORT_OZD_FILE_NAME = "taskReportOzd.ozd";
    private static final String REPORT_OZR_FILE_NAME = "taskReportOzr.ozr";
    private static final String DIRECTION_OZD_FILE_NAME = "taskDirectionOzd.ozd";
    private static final String DIRECTION_OZR_FILE_NAME = "taskDirectionOzr.ozr";

    private static final String URL_PATH = ABVDataCache.getInstance().getUrlPath();

    /**
     * OZDファイルをPDFに変換したファイルをCMSへアップロードする。
     *
     * @param pdfFile   String
     * @param jsonData  String
     * @param contentId long
     * @param objectId  long
     * @param sendTime  String(GMT)
     * @throws Exception
     */
    public static final void sendOzdToAcms(final File pdfFile, final String jsonData, final long contentId, final long objectId, final String sendTime, final int fileType) throws AcmsException, NetworkDisconnectedException, IOException {
        String sId = ABVDataCache.getInstance().getMemberInfo().sid;

//        AcmsMessageJSON json = AcmsClient.getInstance(URL_PATH, ABVEnvironment.getInstance().networkAdapter).uploadOzdFile(sId, pdfFile, jsonData, contentId, objectId, sendTime, fileType);
//
//        Logger.d(TAG, " status=" + json.httpStatus + " message=" + StringUtil.join(",", json.errorMessage));
//        if (json.httpStatus != 200) {
//            throw new AcmsException(ABVExceptionCode.S_E_ACMS_0001, json);
//        }
    }

    /**
     * 優先的なOZDファイルのフォルダを返す。
     * 保存先のファイルを優先する。
     *
     * @param contentId
     * @param ozdFileName
     * @return
     */
    public static final String getOzdFileDir(long contentId, String ozdFileName) {
        // 保存先のファイルを優先する
        String ozdPath = ABVEnvironment.getInstance().getSavedOzdDirectoryPath(contentId, false);
        if (FileUtil.exists(ozdPath + "/" + ozdFileName)) {
            return ozdPath;
        }
        return ContentFileExtractor.getInstance().getContentCacheDirWithExtract(contentId);
    }

    /**
     * OZDファイルの日付取得する。
     *
     * @param contentId
     * @param objectId
     * @return
     * @throws NetworkDisconnectedException
     * @throws AcmsException
     */
    public static final String getOzdFileDate(long contentId, long objectId) throws NetworkDisconnectedException, AcmsException {
//        String sId = ABVDataCache.getInstance().getMemberInfo().sid;
//        GetOzdFileDateParameters parameters = new GetOzdFileDateParameters(sId, contentId, objectId);
//        return AcmsClient.getInstance(URL_PATH, ABVEnvironment.getInstance().networkAdapter).getOzdFileDate(parameters);
        return null;
    }

    public static final void downloadOzdFile(long contentId, long objectId, String outputFilePath) throws NetworkDisconnectedException, AcmsException {
        String sId = ABVDataCache.getInstance().getMemberInfo().sid;
//        GetOzdFileDateParameters parameters = new GetOzdFileDateParameters(sId, contentId, objectId);
//        AcmsClient.getInstance(URL_PATH, ABVEnvironment.getInstance().networkAdapter).downloadOzdFile(parameters, outputFilePath);
    }

    public static final String getSaveOzFileName(String reportFileName) {
        if (reportFileName != null) {
            String replacedFileName = replaceFileName(reportFileName);
            return replacedFileName;
        }
        return REPORT_OZD_FILE_NAME;
    }

    public static final String getOzFilePath(long operationId, long contentId, String taskKey, int taskReportId, String reportStartDate, String reportFileName, int taskReportLevel, String processKey, Integer phaseNo) {
        String ozdFileName = null;
        String ozrFileName = null;

        if (reportFileName != null) {
            ozdFileName = reportFileName;
            ozrFileName = reportFileName;
        } else {
            ozdFileName = REPORT_OZD_FILE_NAME;
            ozrFileName = REPORT_OZR_FILE_NAME;
        }

        String ozFilePath = ABVEnvironment.getInstance().getTempFilePath(contentId, taskKey, ozdFileName.replace("ozr", "ozd"));
        if (FileUtil.exists(ozFilePath)) {
            return ozFilePath;
        }

        if (taskReportId > 0 && !StringUtil.isNullOrEmpty(reportStartDate)) {
            ozFilePath = ABVEnvironment.getInstance().getRoutineTaskSavedOzFilePath(operationId, taskKey, taskReportId, reportStartDate, ozdFileName.replace("ozr", "ozd"), String.valueOf(taskReportLevel));
        } else {
            if (processKey != null && phaseNo != 0) {
                ozFilePath = ABVEnvironment.getInstance().getSavedOzFileTaskReportLevelPath(operationId, taskKey, ozdFileName.replace("ozr", "ozd"), String.valueOf(taskReportLevel), processKey, phaseNo);
            } else {
                ozFilePath = ABVEnvironment.getInstance().getSavedOzFileTaskReportLevelPath(operationId, taskKey, ozdFileName.replace("ozr", "ozd"), String.valueOf(taskReportLevel));
            }
        }
        if (FileUtil.exists(ozFilePath)) {
            return ozFilePath;
        }

        ozFilePath = ABVEnvironment.getInstance().getDefaultOzFilePath(contentId, taskKey, ozdFileName);
        if (processKey != null && phaseNo != 0) {
            ozFilePath = ABVEnvironment.getInstance().getContinuousTaskDefaultOzFilePath(contentId, phaseNo, ozdFileName);
        }
        if (FileUtil.exists(ozFilePath)) {
            return ozFilePath;
        } else {
            ozFilePath = ABVEnvironment.getInstance().getDefaultOzFilePath(contentId, taskKey, ozrFileName);
            if (processKey != null && phaseNo != 0) {
                ozFilePath = ABVEnvironment.getInstance().getContinuousTaskDefaultOzFilePath(contentId, phaseNo, ozrFileName);
            }
            if (FileUtil.exists(ozFilePath)) {
                return ozFilePath;
            }
        }
        Logger.e("ozFile not exists");
        return null;
    }

    public static final String replaceFileName(String fileName) {
        String editingName = fileName.replace("Ozr", "Ozd");
        String replacedName = editingName.replace("ozr", "ozd");
        return replacedName;
    }

    public static final void createTempTaskDir(long contentId, String taskKey) {
        String path = ABVEnvironment.getInstance().getTempTaskDirPath(contentId, taskKey);
        if (!FileUtil.exists(path)) {
            FileUtil.createNewDirectory(path);
        }
    }

    public static final String getTempTaskDirPath(long contentId, String taskKey) {
        return ABVEnvironment.getInstance().getTempTaskDirPath(contentId, taskKey);
    }

    public static final boolean moveTempOzdFileToOzdFile(long contentId, String taskKey, String tempOzFileName, String ozFileName) {
        String tempOzdFilePath = ABVEnvironment.getInstance().getTempFilePath(contentId, taskKey, tempOzFileName);
        String ozdFilePath = ABVEnvironment.getInstance().getTempFilePath(contentId, taskKey, ozFileName);
        if (FileUtil.exists(ozdFilePath)) {
            FileUtil.delete(ozdFilePath);
        }
        return FileUtil.move(tempOzdFilePath, ozdFilePath, true);
    }

    /**
     * 削除するOZDファイルがあるかを確認する
     * @param operationId
     * @param taskKey
     * @param taskReportId
     * @param reportStartDate
     * @param reportFileName
     * @param taskReportLevel
     * @param processKey
     * @param phaseNo
     * @return
     */
    public static final boolean checkOzFilePath(long operationId, String taskKey, int taskReportId, String reportStartDate, String reportFileName, int taskReportLevel, String processKey, Integer phaseNo) {
        String ozdFileName = null;

        if (reportFileName != null) {
            ozdFileName = reportFileName.replace("ozr", "ozd");
        }

        String ozFilePath = null;
        if (taskReportId > 0 && !StringUtil.isNullOrEmpty(reportStartDate)) {
            ozFilePath = ABVEnvironment.getInstance().getRoutineTaskSavedOzFilePath(operationId, taskKey, taskReportId, reportStartDate, ozdFileName, String.valueOf(taskReportLevel));
        } else {
            if (processKey != null && phaseNo != 0) { //連続作業
                ozFilePath = ABVEnvironment.getInstance().getSavedOzFileTaskReportLevelPath(operationId, taskKey, ozdFileName, String.valueOf(taskReportLevel), processKey, phaseNo);
            } else {
                ozFilePath = ABVEnvironment.getInstance().getSavedOzFileTaskReportLevelPath(operationId, taskKey, ozdFileName, String.valueOf(taskReportLevel));
            }

        }
        if (FileUtil.exists(ozFilePath)) {
            return true;
        }
        return false;
    }
}