package jp.agentec.abook.abv.ui.viewer.activity;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.JsonUtil;
import jp.agentec.abook.abv.bl.websocket.MeetingManager;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.viewer.view.FullVideoView;

import org.json.adf.JSONObject;

import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;

/**
 * 動画再生用Activity
 * 
 * ※FullVideoViewをImageViewなどと同様に開く予定だったが、ZoomRelativeLayoutとのイベントの兼ね合いで、解決するのに 時間がかかるため、オーサリング部品がないのでとりあえずActivityで実施。
 * 
 *
 */
public class VideoViewActivity extends NoPdfViewActivity implements View.OnTouchListener {
	private static final String TAG = "VideoViewActivity";
	
	private FullVideoView mVideoView;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "onCreate");
        super.onCreate(savedInstanceState);
        
        //***** 引数の取得
        Intent intent = getIntent();
        String videofile = intent.getStringExtra(FILEPATH);   //動画FilePath
	    String contentName = intent.getStringExtra(ABookKeys.CONTENT_NAME); // コンテンツ名
        Logger.d(TAG, "onCreate:" + videofile);
        
		mVideoView = new FullVideoView(this, videofile, contentName, getContentId(), objectPageNumber, getObjectId(), isNormalSize(), -1);
		mVideoView.setOnTouchListener(this);
		mVideoView.findViewById(R.id.imgBtnBack).setVisibility(View.GONE);
		
		addViewToMainFrame(mVideoView);
		
		// 最初はツールバーを表示しない
		getToolbar().setVisibility(View.GONE);
    }
    
	@Override
    public void onResume() {
		Logger.i(TAG, "onResume");
		super.onResume();
    }
    
	@Override
    public void onStop() {
		super.onStop();
		mVideoView.stop();
    }

	@Override
	public void performRemoteEvent(final JSONObject json) {
		Logger.v(TAG, "[performRemoteEvent]%s", json);
		String type = JsonUtil.getString(json, MeetingManager.TYPE);
		int playTime = JsonUtil.getInt(json, MeetingManager.PLAY_TIME);
		if (playTime != -1 && playTime >= 0 && playTime * 1000 < mVideoView.getDuration()) {
			mVideoView.jump(playTime * 1000);
		}
		if (type != null && type.equals(MeetingManager.START)) {
			mVideoView.restartVideo();
		}
		else if (type != null && type.equals(MeetingManager.PAUSE)) {
			mVideoView.pauseVideo();
		}
	}
	@Override
	protected void finishActivity() {
		mVideoView.stop();
		super.finishActivity();
	}
	
	@Override
	public boolean onTouch(View v, MotionEvent event) {
		if(event.getAction() == MotionEvent.ACTION_DOWN){
			Logger.d(TAG, "onTouch");
			View toolbar = getToolbar();
			if (toolbar.getVisibility() == View.GONE) {
				toolbar.setVisibility(View.VISIBLE);
				mVideoView.setControlVisible(true);
			} else {
				toolbar.setVisibility(View.GONE);
				mVideoView.setControlVisible(false);
			}
			setMeetingParticipantCount(toolbar.getVisibility() == View.VISIBLE, findViewById(android.R.id.content));
		}
		
		return false;
	}

}