package jp.agentec.abook.abv.ui.viewer.activity.theta;

import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;

import com.theta.network.ImageData;
import com.theta.view.ImageListArrayAdapter;
import com.theta.view.ImageRow;

import java.util.List;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.task.DeleteImageTask;
import jp.agentec.abook.abv.ui.viewer.activity.theta.task.ImageListTask;
import jp.agentec.abook.abv.ui.viewer.activity.theta.task.LoadPhotoTask;

/**
 * THETAライブラリ画面
 * @version 1.2.300
 * @since 2020/05/19
 * @author 金鎭星
 */
public class ThetaImageListActivity extends ThetaActivity {
    private static final String TAG = "ThetaImageListActivity";
    private static int THETA_PREVIEW_BACK_ACTIVITY = 1000;
    private ListView mImageListView;
    private List<ImageRow> mImageRows;
    private int mSelectedPosition;
    private boolean isSelected = false;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        Logger.i(TAG, "--- onCreate");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.ac_theta_image_list);
        mImageListView = findViewById(R.id.lv_theta_image);

        // 戻るボタン
        Button backBtn = findViewById(R.id.btn_back);
        backBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });

        showProgressPopup();
        new ImageListTask(this).execute();
    }

    //端末の戻るボタン禁止
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Logger.v(TAG, "dispatchKeyEvent %s", event);
        if (event.getAction()==KeyEvent.ACTION_UP) { // 戻るボタンを抑止
            if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }
    /**
     * THETAカメラから全ての画像情報取得するImageListTaskTask終了時に呼ばれる
     * @param imageRows 画像データ配列
     */
    public void imageListTaskFinish(List<ImageRow> imageRows) {
        if (imageRows != null) {
            mImageRows = imageRows;
            boolean isPhone = false;
            if (isNormalSize()) {
                isPhone = true;
            }
            ImageListArrayAdapter imageListArrayAdapter = new ImageListArrayAdapter(ThetaImageListActivity.this, R.layout.listlayout_object, imageRows, isPhone);
            mImageListView.setAdapter(imageListArrayAdapter);
            mImageListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> parent, View view, final int position, long id) {
                    final ImageRow selectedItem = (ImageRow) parent.getItemAtPosition(position);
                    int viewId = view.getId();
                    if (viewId == R.id.btn_theta_image_save) { //保存ボタン
                        buttonDoubleTapControl((Button) view);
                        AlertDialogUtil.showAlertDialog(ThetaImageListActivity.this, R.string.app_name, R.string.msg_theta_image_send_confirm, false, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                showProgressPopup(getString(R.string.msg_transferring));
                                mSelectedPosition = position;
                                //画像情報を取得
                                new LoadPhotoTask(ThetaImageListActivity.this, selectedItem.getFileId()).execute();
                            }
                        });
                    } else if (viewId == R.id.btn_theta_image_delete) { //削除ボタン
                        buttonDoubleTapControl((Button) view);
                        AlertDialogUtil.showAlertDialog(ThetaImageListActivity.this, R.string.app_name, R.string.msg_theta_image_delete_confirm, false, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                showProgressPopup(getString(R.string.msg_deleting));
                                mSelectedPosition = position;
                                new DeleteImageTask(ThetaImageListActivity.this).execute(selectedItem.getFileId());

                            }
                        });
                    } else { //通常アイテムタップ時
                        if (!isSelected) {
                            isSelected = true;
                            if (selectedItem.isPhoto()) {
                                Intent intent = new Intent();
                                intent.putExtra(ABookKeys.THETA_FILE_ID, selectedItem.getFileId());
                                intent.putExtra(ABookKeys.THETA_LIST_ACTIVITY_FLG, true);
                                intent.setClassName(getPackageName(), ThetaImagePreviewActivity.class.getName());
                                startActivityForResult(intent, THETA_PREVIEW_BACK_ACTIVITY);
                            } else {
                                Logger.e(TAG, "is not Photo");
                            }
                            //ダブルタップ防止
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    isSelected = false;
                                }
                            }, 1000);
                        }
                    }
                }
            });
            closeProgressPopup();
        } else {
            thetaConnectError(R.string.msg_theta_image_load_fail);
            Logger.e(TAG, "failed to get image list");
        }
    }

    /**
     * THETAカメラから画像情報取得するLoadPhotoTask終了時に呼ばれる
     * 画像データがある場合、ローカルに保存する
     * @param imageData 画像データ
     */
    public void loadPhotoTaskFinish(ImageData imageData, String fileId) {
        if (imageData != null) {
            byte[] dataObject = imageData.getRawData();
            if (dataObject == null) {
                return;
            }
            Bitmap bitmap = BitmapFactory.decodeByteArray(dataObject, 0, dataObject.length);
            if (mThetaHelper.thetaImageLocalSave(bitmap, fileId)) {
                showSimpleAlertDialog(R.string.msg_theta_image_send_success);

                ImageRow imageRow = mImageRows.get(mSelectedPosition);
                imageRow.setIsTransferred(true);

                ImageListArrayAdapter imageListArrayAdapter = (ImageListArrayAdapter)mImageListView.getAdapter();
                imageListArrayAdapter.setListItem(mImageRows);
                imageListArrayAdapter.notifyDataSetChanged();
            } else {
                Logger.e(TAG,"failed to local save image");
                showSimpleAlertDialog(R.string.msg_theta_image_send_fail);
            }
            closeProgressPopup();
        } else {
            Logger.e(TAG,"failed loadPhotoTaskFinish");
            thetaConnectError(R.string.msg_theta_image_load_fail);
        }

    }

    /**
     * THETAカメラから画像を削除するDeleteImageTask終了時に呼ばれる
     * @param isSuccess 削除結果（true:成功、false:失敗）
     */
    public void deleteImageTaskFinish(boolean isSuccess) {
        if (isSuccess) {
            AlertDialogUtil.showAlertDialog(ThetaImageListActivity.this, R.string.app_name, R.string.msg_theta_image_delete_success, true, new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    mImageRows.remove(mSelectedPosition);
                    ImageListArrayAdapter imageListArrayAdapter = (ImageListArrayAdapter)mImageListView.getAdapter();
                    imageListArrayAdapter.setListItem(mImageRows);
                    imageListArrayAdapter.notifyDataSetChanged();
                }
            });
            closeProgressPopup();
        } else {
            Logger.e(TAG,"failed to delete image");
            thetaConnectError(R.string.msg_theta_image_delete_fail);
        }

    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        //THETAプレビュー画面から転送したあと、戻ったとき再描画を行う。
        if (requestCode == THETA_PREVIEW_BACK_ACTIVITY && resultCode == RESULT_OK) {
            showProgressPopup();
            new ImageListTask(this).execute();
        }
    }
}
