package jp.agentec.abook.abv.ui.viewer.activity.theta;

import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;

import com.theta.glview.GLPhotoView;
import com.theta.model.Photo;
import com.theta.model.RotateInertia;
import com.theta.network.ImageData;

import jp.agentec.abook.abv.bl.common.CommonExecutor;
import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.util.AlertDialogUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.task.LoadPhotoTask;

/**
 * THETAプレビュー画面
 * @version 1.2.300
 * @since 2020/05/19
 * @author 金鎭星
 */
public class ThetaImagePreviewActivity extends ThetaActivity {
    private static final String TAG = "ThetaImagePreviewActivity";

    private RotateInertia mRotateInertia = RotateInertia.INERTIA_0;
    private Button mSaveBtn;
    private GLPhotoView mGLPhotoView;
    private Photo mTexture;
    private String mFileId;
    private boolean isSavedSuccess;
    private boolean isThetaListActivityBack;
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Logger.i(TAG, "onCreate");
        setContentView(R.layout.ac_theta_image_preview);
        isSavedSuccess = false;
        // 戻るボタン
        Button backBtn = findViewById(R.id.btn_back);
        backBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                //転送後にTHETAライブラリ再描画のため
                if (isThetaListActivityBack && isSavedSuccess) {
                    setResult(RESULT_OK);
                }
                finish();
            }
        });

        // 転送ボタン
        mSaveBtn = findViewById(R.id.btn_theta_image_save);
        mSaveBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                buttonDoubleTapControl(mSaveBtn);
                AlertDialogUtil.showAlertDialog(ThetaImagePreviewActivity.this, R.string.app_name, R.string.msg_theta_image_send_confirm, false, new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        showProgressPopup();
                        CommonExecutor.execute(new Runnable() { //スレッド化
                            @Override
                            public void run() {
                                if (mThetaHelper.thetaImageLocalSave(mTexture.getPhoto(), mFileId)) {
                                    showSimpleAlertDialog(R.string.app_name, R.string.msg_theta_image_send_success);
                                    isSavedSuccess = true;
                                } else {
                                    showSimpleAlertDialog(R.string.app_name, R.string.msg_theta_image_send_fail);
                                }
                                closeProgressPopup();
                            }
                        });


                    }
                });
            }
        });

        Intent intent = getIntent();
        this.mFileId = intent.getStringExtra(ABookKeys.THETA_FILE_ID);
        this.isThetaListActivityBack = intent.getBooleanExtra(ABookKeys.THETA_LIST_ACTIVITY_FLG, false);

        mGLPhotoView = findViewById(R.id.photo_image);
        mGLPhotoView.setmRotateInertia(mRotateInertia);

        new LoadPhotoTask(this, mFileId).execute();
    }

    //端末の戻るボタン禁止
    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        Logger.v(TAG, "dispatchKeyEvent %s", event);
        if (event.getAction()==KeyEvent.ACTION_UP) { // 戻るボタンを抑止
            if (event.getKeyCode() == KeyEvent.KEYCODE_BACK) {
                return true;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    /**
     * THETAカメラから画像情報取得するLoadPhotoTask終了時に呼ばれる
     * @param imageData 画像データ
     */
    public void loadPhotoTaskFinish(ImageData imageData) {
        if (imageData != null) {
            byte[] dataObject = imageData.getRawData();
            if (dataObject == null) {
                return;
            }
            Bitmap __bitmap = BitmapFactory.decodeByteArray(dataObject, 0, dataObject.length);
            Double yaw = imageData.getYaw();
            Double pitch = imageData.getPitch();
            Double roll = imageData.getRoll();
            mTexture = new Photo(__bitmap, yaw, pitch, roll);
            if (null != mGLPhotoView) {
                mGLPhotoView.setTexture(mTexture);
            }
            closeProgressPopup();
        } else {
            thetaConnectError(R.string.msg_theta_image_load_fail);
            Logger.e(TAG,"failed loadPhotoTaskFinish");
        }
    }
}
