package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.os.AsyncTask;

import com.theta.network.HttpConnector;
import com.theta.network.HttpEventListener;

import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaImageListActivity;

/**
 * THETAカメラから１つの画像を削除するスレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class DeleteImageTask extends AsyncTask<String, String, Void> {
    private static final String TAG = "DeleteImageTask";
    private final WeakReference<ThetaImageListActivity> refActivity;

    public DeleteImageTask(ThetaImageListActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected Void doInBackground(String... fileId) {
        Logger.d(TAG, "doInBackground delete " + fileId[0]);
        DeleteEventListener deleteListener = new DeleteEventListener();
        boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(),ABookKeys.THETA_OLD_VERSION_FLG, false);
        HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
        camera.deleteFile(fileId[0], deleteListener);
        return null;
    }

    private class DeleteEventListener implements HttpEventListener {
        @Override
        public void onCheckStatus(boolean newStatus) {
            if (newStatus) {
                Logger.d(TAG, "onCheckStatus deleteFile:FINISHED");
            } else {
                Logger.d(TAG,"onCheckStatus deleteFile:IN PROGRESS");
            }
        }

        @Override
        public void onObjectChanged(String latestCapturedFileId) {
            Logger.d(TAG, "onObjectChanged delete " + latestCapturedFileId);
        }

        @Override
        public void onCompleted() {
            Logger.d(TAG, "onCompleted　deleted.");
            refActivity.get().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    ThetaImageListActivity imageListActivity = refActivity.get();
                    imageListActivity.deleteImageTaskFinish(true);
                }
            });
        }

        @Override
        public void onError(String errorMessage) {
            Logger.e(TAG, "delete error " + errorMessage);
            refActivity.get().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    ThetaImageListActivity imageListActivity = refActivity.get();
                    imageListActivity.deleteImageTaskFinish(false);
                }
            });

        }
    }
}
