package jp.agentec.abook.abv.ui.viewer.activity.theta.task;

import android.os.AsyncTask;

import com.theta.network.HttpConnector;

import java.lang.ref.WeakReference;

import jp.agentec.abook.abv.bl.common.constant.ABookKeys;
import jp.agentec.abook.abv.bl.common.constant.ABookValues;
import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.cl.util.PreferenceUtil;
import jp.agentec.abook.abv.ui.viewer.activity.theta.ThetaCameraActivity;
/**
 * THETAカメラのWifi機能をOFFにするスレッド
 * @version 1.2.300
 * @author kimjinsung
 * @since 2020/05/29
 */
public class FinishWlanTask extends AsyncTask<Void, String, String> {
    private static final String TAG = "FinishWlanTask";
    private static final int SLEEP_TIME = 2000;
    private final WeakReference<ThetaCameraActivity> refActivity;

    public FinishWlanTask(ThetaCameraActivity refActivity) {
        this.refActivity = new WeakReference<>(refActivity);
    }

    @Override
    protected String doInBackground(Void... params) {
        Logger.d(TAG, "doInBackground");
        boolean isOldApi = PreferenceUtil.getUserPref(refActivity.get(), ABookKeys.THETA_OLD_VERSION_FLG, false);
        HttpConnector camera = new HttpConnector(ABookValues.THETA_IP_ADDRESS, isOldApi);
        if (camera.cameraFinishWlan()) {
            try {
                // Wifi切り替える時間２秒スリップ
                Thread.sleep(SLEEP_TIME);
            } catch (InterruptedException e) {
                Logger.e(TAG, "sleep error" + e.toString());
            }

            return ABookValues.SUCCESS;
        }
        return ABookValues.FAIL;
    }

    @Override
    protected void onPostExecute(String result) {
        Logger.d(TAG, "onPostExecute");
        ThetaCameraActivity activity = refActivity.get();
        activity.finishWlanTaskFinish(result);
    }
}
