package jp.agentec.abook.abv.ui.viewer.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import jp.agentec.abook.abv.bl.common.log.Logger;
import jp.agentec.abook.abv.bl.common.util.ContentFileUtil;
import jp.agentec.abook.abv.bl.dto.ContentBookmarkDto;
import jp.agentec.abook.abv.bl.logic.AbstractLogic;
import jp.agentec.abook.abv.bl.logic.BookmarkLogic;
import jp.agentec.abook.abv.cl.util.BitmapUtil;
import jp.agentec.abook.abv.launcher.android.R;
import jp.agentec.abook.abv.ui.common.appinfo.AppColor;
import jp.agentec.abook.abv.ui.common.constant.ErrorCode;
import jp.agentec.abook.abv.ui.common.constant.ErrorMessage;
import jp.agentec.abook.abv.ui.viewer.activity.ContentViewActivity;
import jp.agentec.abook.abv.ui.viewer.foxitPdf.PdfThumbnailProvider;
import jp.agentec.adf.util.FileUtil;
import jp.agentec.adf.util.StringUtil;
import android.content.Context;
import android.graphics.Bitmap.Config;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ContentBookmarkAdapter extends BaseAdapter {
	private static final String TAG = "ContentBookmarkAdapter";
	Context context;
	LayoutInflater inflater;
	List<ContentBookmarkDto> listItem;
	private boolean isPdf;
	private PdfThumbnailProvider pdfThumbnailProvider;

	public ContentBookmarkAdapter(Context context, long contentId, boolean isPdf) throws IOException {
		this.context = context;
		this.isPdf = isPdf;
		inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);

		listItem = new ArrayList<>();
		listItem = AbstractLogic.getLogic(BookmarkLogic.class).getContentBookmark(contentId);
		Logger.v("ABVBookmarkAdapter", "btn_bookmarks:listItem=%s", listItem);
		if (isPdf) { // PDFの場合
			pdfThumbnailProvider = new PdfThumbnailProvider(context, contentId, ((ContentViewActivity) context).isNormalSize());
		}
	}

	@Override
    public int getCount() {
		return listItem.size();
	}

	@Override
    public long getItemId(int position) {
		return listItem.get(position).contentId;
	}

	@Override
    public View getView(int position, View convertView, ViewGroup parent) {
		if (null == convertView) {
			convertView = inflater.inflate(R.layout.bookmark_render, null);
		}

		final ContentBookmarkDto dto = listItem.get(position);

		ImageView image = (ImageView) convertView.findViewById(R.id.img_main);

		if (isPdf) { // PDFの場合
			Logger.d("ABVBookmarkAdapter", "getView:1");
			if (!StringUtil.isNullOrEmpty(dto.pageThumbnailPath)) {
				Logger.d("ABVBookmarkAdapter", "getView:2");
				String pageThumbnailPath = ContentFileUtil.getPdfThumbnailPath(dto.contentId, dto.pageNum, ContentFileUtil.SIZE_L);
				try {
					if (FileUtil.exists(pageThumbnailPath)) {
						image.setImageBitmap(BitmapUtil.getBitmap(pageThumbnailPath, Config.RGB_565));
					}
					else {
						image.setImageBitmap(pdfThumbnailProvider.getThumbnail(dto.pageNum, false));
					}
					image.setAdjustViewBounds(true);
					image.setScaleType(ImageView.ScaleType.FIT_CENTER);
					image.setPadding(0, 0, 1, 1);
					GradientDrawable g = new GradientDrawable(GradientDrawable.Orientation.TL_BR, new int[] { Color.WHITE, Color.WHITE, AppColor.getBackground() });
					//noinspection deprecation(API16から非推奨になった。無視)
					image.setBackgroundDrawable(g);
				} catch (Exception e) {
					Logger.e(TAG, "PdfThumbnailProvider", e);
					ErrorMessage.showErrorMessageToast(context.getApplicationContext(), ErrorCode.E107);
				}
			}
		} else {
			convertView.findViewById(R.id.layout_main).setVisibility(View.GONE);
		}

		TextView pageNum = (TextView) convertView.findViewById(R.id.num_page);
		pageNum.setText(context.getResources().getString(R.string.page) + " " + (dto.pageNum + 1));

		TextView pageText = (TextView) convertView.findViewById(R.id.txt_page);
		pageText.setText(dto.pageText);

		return convertView;
	}

	@Override
    public ContentBookmarkDto getItem(int position) {
		return listItem.get(position);
	}
}
