package jp.agentec.abook.abv.ui.viewer.view;

import jp.agentec.abook.abv.bl.common.log.Logger;
import android.content.Context;
import android.view.MotionEvent;
import android.widget.HorizontalScrollView;

public class PageScrollView extends HorizontalScrollView {

	/** 拡大・縮小中はScrollできないようにする場合に利用する **/
	private boolean mIsZooming = false;
	private boolean mIsFix = false;
	private boolean mIsVideoMax = false;
	
	public PageScrollView(Context context) {
		super(context);
	}

	@Override
	public boolean onTouchEvent(MotionEvent ev) {
		Logger.v("PageScrollView", "[onTouchEvent]:start");
		if (!mIsZooming && !mIsFix && !mIsVideoMax) {
			boolean result =  super.onTouchEvent(ev);
			Logger.v("PageScrollView", "[onTouchEvent]:end");
			return result;
		}
		Logger.v("PageScrollView", "[onTouchEvent]:end");
		return false;
	}
	
	@Override
	protected boolean overScrollBy(int deltaX, int deltaY, int scrollX,
			int scrollY, int scrollRangeX, int scrollRangeY,
			int maxOverScrollX, int maxOverScrollY, boolean isTouchEvent) {
		// OverScrollの範囲設定
		return super.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX,
				scrollRangeY, 200, maxOverScrollY, isTouchEvent);
	}
	
	/**
	 * 
	 * @param isZooming boolean
	 */
	public void setZoomingFlag(boolean isZooming) {
		mIsZooming = isZooming;
	}
	public void setFixFlag(boolean isFix) {
		mIsFix = isFix;
	}
	public void setVideoMaxFlag(boolean isVideoMax) {
		mIsVideoMax = isVideoMax;
	}
	

	/**
	 * Zoomの状態ではScrollできない
	 * @return
	 */
	public boolean isScrollable() {
		return !mIsZooming && !mIsFix && !mIsVideoMax;
	}
	public boolean isMemocheck() {
		return !mIsZooming && !mIsVideoMax;
	}
	
	public boolean isZooming() {
		return mIsZooming ;
	}
	
	public boolean isVideoMax() {
		return mIsVideoMax ;
	}
}
