# AndroidプロジェクトのAndroid Studio上での開発について

[Android Studio](https://developer.android.com/sdk/index.html)がVersion1.0となり、Android開発のオフィシャルIDEとなったため、
ADT+AntのプロジェクトをAndroid Studio+Gradleへ移行しました。
下記の手順で試してみてください。

## 環境構築

### Android SDK

Android SDK Platform-tools 21.1.2 が必要です。適時 Android sdkを更新してください。

### Android NDK

mupdfのビルドにNDKが必要です。[Android NDK](https://developer.android.com/tools/sdk/ndk/index.html)からダウンロードして展開、LIB_MUPDF15/gradle.properties にNDKのパスを記載してください。

### Cygwin

mupdfのビルドにmake,ccが必要です。[32bit版](http://cygwin.com/setup-x86.exe)または[64bit版](http://cygwin.com/setup-x86_64.exe)を実行し、
Develカテゴリからmakeとgcc-g++をインストールしてください。また、パスを通しておいてください。

OSXの場合はXCodeがインストール済みであればmake,ccはインストール済みのため当ステップは不要です。

### Android Studio

[公式サイト](https://developer.android.com/sdk/index.html)からAndroid Studioをダウンロード、インストールしてください。

## IDE

Android Studio (内部エンジン:IntelliJ IDEA)用の設定ファイルはGit上に含まれていませんが、Gradleファイルからプロジェクトファイルは容易に作成可能です。

### Branch

sandbox/gradle ブランチへ切り替えてください。

### プロジェクトの作成

Android Studioを起動、Welcome画面のQuickStartで ** Import Non-Android Studio project ** を選択、abook_androidディレクトリを指定してください。

NDK, Cygwinの設定に問題がなければビルドが始まります。(初回は時間がかかります)

## Tips

### プロジェクト構成

|file             |path                  |description|
|-----------------|----------------------|--|
|build.gradle     |/                     |ルートビルドファイル|
|settings.gradle  |/                     |子プロジェクトを列記|
|gradle.properties|/                     |各種プロパティ。AndroidManifest.xmlへ埋め込む設定。プロパティ名は機械的処理のためabvEnvironments.xmlに合わせてあります。|
|build.gradle     |ABVJE_BL              |ABVJE_BLビルド設定|
|build.gradle     |ABVJE_Launcher_Android|ABVJE_Launcher_Androidビルド設定|
|build.gradle     |ABVJE_UI_Android      |ABVJE_UI_Androidビルド設定|
|build.gradle     |LIB_MUPDF15           |LIB_MUPDF15ビルド設定|
|gradle.properties|LIB_MUPDF15           |LIB_MUPDF15ビルドプロパティ。NDKパスをこちらに記載してください。|


### Multidex

[1個のdexに含められるメソッドの総数には64Kの制限](https://developer.android.com/tools/building/multidex.html)があり、制限回避のために Multidex (dex分割)の仕組みがある。
ビルドシステムに加えて、1点のみソースコードを変更している。

```ABVApplication
public class ABVApplication extends MultiDexApplication {
...
...
}
```

### Build

```
gradlew assembleRelease
```

### ToDo

* Jenkinsでのリソース切り替えのGradleへの組込み -> done

