/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie;

import android.util.Log;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oz.lottie.PerformanceTracker$1;
import oz.lottie.PerformanceTracker$FrameListener;
import oz.lottie.custom.ArraySet;
import oz.lottie.utils.MeanCalculator;

public class PerformanceTracker {
    private boolean enabled = false;
    private final Set frameListeners = new ArraySet();
    private final Map layerRenderTimes = new HashMap();
    private final Comparator floatComparator = new PerformanceTracker$1(this);

    void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void recordRenderTime(String string, float f2) {
        if (!this.enabled) {
            return;
        }
        MeanCalculator meanCalculator = (MeanCalculator)this.layerRenderTimes.get(string);
        if (meanCalculator == null) {
            meanCalculator = new MeanCalculator();
            this.layerRenderTimes.put(string, meanCalculator);
        }
        meanCalculator.add(f2);
        if (string.equals("__container")) {
            for (PerformanceTracker$FrameListener performanceTracker$FrameListener : this.frameListeners) {
                performanceTracker$FrameListener.onFrameRendered(f2);
            }
        }
    }

    public void addFrameListener(PerformanceTracker$FrameListener performanceTracker$FrameListener) {
        this.frameListeners.add(performanceTracker$FrameListener);
    }

    public void removeFrameListener(PerformanceTracker$FrameListener performanceTracker$FrameListener) {
        this.frameListeners.remove(performanceTracker$FrameListener);
    }

    public void clearRenderTimes() {
        this.layerRenderTimes.clear();
    }

    public void logRenderTimes() {
        if (!this.enabled) {
            return;
        }
        List list = this.getSortedRenderTimes();
        Log.d((String)"LOTTIE", (String)"Render times:");
        int n = 0;
        while (n < list.size()) {
            Pair pair = (Pair)list.get(n);
            Log.d((String)"LOTTIE", (String)String.format("\t\t%30s:%.2f", pair.first, pair.second));
            ++n;
        }
    }

    public List getSortedRenderTimes() {
        if (!this.enabled) {
            return Collections.emptyList();
        }
        ArrayList<Pair> arrayList = new ArrayList<Pair>(this.layerRenderTimes.size());
        for (Map.Entry entry : this.layerRenderTimes.entrySet()) {
            arrayList.add(new Pair((Object)((String)entry.getKey()), (Object)Float.valueOf(((MeanCalculator)entry.getValue()).getMean())));
        }
        Collections.sort(arrayList, this.floatComparator);
        return arrayList;
    }
}

