/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Path;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.ContentGroup;
import oz.lottie.animation.content.GreedyContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.model.content.MergePaths;

public class MergePathsContent
implements GreedyContent,
PathContent {
    private final Path firstPath = new Path();
    private final Path remainderPath = new Path();
    private final Path path = new Path();
    private final String name;
    private final List pathContents = new ArrayList();
    private final MergePaths mergePaths;

    public MergePathsContent(MergePaths mergePaths) {
        if (Build.VERSION.SDK_INT < 19) {
            throw new IllegalStateException("Merge paths are not supported pre-KitKat.");
        }
        this.name = mergePaths.getName();
        this.mergePaths = mergePaths;
    }

    @Override
    public void absorbContent(ListIterator listIterator) {
        while (listIterator.hasPrevious() && listIterator.previous() != this) {
        }
        while (listIterator.hasPrevious()) {
            Content content = (Content)listIterator.previous();
            if (!(content instanceof PathContent)) continue;
            this.pathContents.add((PathContent)content);
            listIterator.remove();
        }
    }

    @Override
    public void setContents(List list, List list2) {
        int n = 0;
        while (n < this.pathContents.size()) {
            ((PathContent)this.pathContents.get(n)).setContents(list, list2);
            ++n;
        }
    }

    @Override
    public Path getPath() {
        this.path.reset();
        if (this.mergePaths.isHidden()) {
            return this.path;
        }
        switch (this.mergePaths.getMode()) {
            case MERGE: {
                this.addPaths();
                break;
            }
            case ADD: {
                this.opFirstPathWithRest(Path.Op.UNION);
                break;
            }
            case SUBTRACT: {
                this.opFirstPathWithRest(Path.Op.REVERSE_DIFFERENCE);
                break;
            }
            case INTERSECT: {
                this.opFirstPathWithRest(Path.Op.INTERSECT);
                break;
            }
            case EXCLUDE_INTERSECTIONS: {
                this.opFirstPathWithRest(Path.Op.XOR);
            }
        }
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void addPaths() {
        int n = 0;
        while (n < this.pathContents.size()) {
            this.path.addPath(((PathContent)this.pathContents.get(n)).getPath());
            ++n;
        }
    }

    private void opFirstPathWithRest(Path.Op op) {
        Object object;
        this.remainderPath.reset();
        this.firstPath.reset();
        int n = this.pathContents.size() - 1;
        while (n >= 1) {
            object = (PathContent)this.pathContents.get(n);
            if (object instanceof ContentGroup) {
                List list = ((ContentGroup)object).getPathList();
                int n2 = list.size() - 1;
                while (n2 >= 0) {
                    Path path = ((PathContent)list.get(n2)).getPath();
                    path.transform(((ContentGroup)object).getTransformationMatrix());
                    this.remainderPath.addPath(path);
                    --n2;
                }
            } else {
                this.remainderPath.addPath(object.getPath());
            }
            --n;
        }
        PathContent pathContent = (PathContent)this.pathContents.get(0);
        if (pathContent instanceof ContentGroup) {
            object = ((ContentGroup)pathContent).getPathList();
            int n3 = 0;
            while (n3 < object.size()) {
                Path path = ((PathContent)object.get(n3)).getPath();
                path.transform(((ContentGroup)pathContent).getTransformationMatrix());
                this.firstPath.addPath(path);
                ++n3;
            }
        } else {
            this.firstPath.set(pathContent.getPath());
        }
        this.path.op(this.firstPath, this.remainderPath, op);
    }
}

