/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.animation.content;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.content.Content;
import oz.lottie.animation.content.ContentGroup;
import oz.lottie.animation.content.DrawingContent;
import oz.lottie.animation.content.GreedyContent;
import oz.lottie.animation.content.KeyPathElementContent;
import oz.lottie.animation.content.PathContent;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation$AnimationListener;
import oz.lottie.animation.keyframe.TransformKeyframeAnimation;
import oz.lottie.model.KeyPath;
import oz.lottie.model.content.Repeater;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.utils.MiscUtils;
import oz.lottie.value.LottieValueCallback;

public class RepeaterContent
implements DrawingContent,
GreedyContent,
KeyPathElementContent,
PathContent,
BaseKeyframeAnimation$AnimationListener {
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final LottieDrawable lottieDrawable;
    private final BaseLayer layer;
    private final String name;
    private final boolean hidden;
    private final BaseKeyframeAnimation copies;
    private final BaseKeyframeAnimation offset;
    private final TransformKeyframeAnimation transform;
    private ContentGroup contentGroup;

    public RepeaterContent(LottieDrawable lottieDrawable, BaseLayer baseLayer, Repeater repeater) {
        this.lottieDrawable = lottieDrawable;
        this.layer = baseLayer;
        this.name = repeater.getName();
        this.hidden = repeater.isHidden();
        this.copies = repeater.getCopies().createAnimation();
        baseLayer.addAnimation(this.copies);
        this.copies.addUpdateListener(this);
        this.offset = repeater.getOffset().createAnimation();
        baseLayer.addAnimation(this.offset);
        this.offset.addUpdateListener(this);
        this.transform = repeater.getTransform().createAnimation();
        this.transform.addAnimationsToLayer(baseLayer);
        this.transform.addListener(this);
    }

    @Override
    public void absorbContent(ListIterator listIterator) {
        if (this.contentGroup != null) {
            return;
        }
        while (listIterator.hasPrevious() && listIterator.previous() != this) {
        }
        ArrayList<Content> arrayList = new ArrayList<Content>();
        while (listIterator.hasPrevious()) {
            arrayList.add((Content)listIterator.previous());
            listIterator.remove();
        }
        Collections.reverse(arrayList);
        this.contentGroup = new ContentGroup(this.lottieDrawable, this.layer, "Repeater", this.hidden, arrayList, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContents(List list, List list2) {
        this.contentGroup.setContents(list, list2);
    }

    @Override
    public Path getPath() {
        Path path = this.contentGroup.getPath();
        this.path.reset();
        float f2 = ((Float)this.copies.getValue()).floatValue();
        float f3 = ((Float)this.offset.getValue()).floatValue();
        int n = (int)f2 - 1;
        while (n >= 0) {
            this.matrix.set(this.transform.getMatrixForRepeater((float)n + f3));
            this.path.addPath(path, this.matrix);
            --n;
        }
        return this.path;
    }

    @Override
    public void draw(Canvas canvas, Matrix matrix, int n) {
        float f2 = ((Float)this.copies.getValue()).floatValue();
        float f3 = ((Float)this.offset.getValue()).floatValue();
        float f4 = ((Float)this.transform.getStartOpacity().getValue()).floatValue() / 100.0f;
        float f5 = ((Float)this.transform.getEndOpacity().getValue()).floatValue() / 100.0f;
        int n2 = (int)f2 - 1;
        while (n2 >= 0) {
            this.matrix.set(matrix);
            this.matrix.preConcat(this.transform.getMatrixForRepeater((float)n2 + f3));
            float f6 = (float)n * MiscUtils.lerp(f4, f5, (float)n2 / f2);
            this.contentGroup.draw(canvas, this.matrix, (int)f6);
            --n2;
        }
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        this.contentGroup.getBounds(rectF, matrix, bl);
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public void resolveKeyPath(KeyPath keyPath, int n, List list, KeyPath keyPath2) {
        MiscUtils.resolveKeyPath(keyPath, n, list, keyPath2, this);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        if (this.transform.applyValueCallback(object, lottieValueCallback)) {
            return;
        }
        if (object == LottieProperty.REPEATER_COPIES) {
            this.copies.setValueCallback(lottieValueCallback);
        } else if (object == LottieProperty.REPEATER_OFFSET) {
            this.offset.setValueCallback(lottieValueCallback);
        }
    }
}

