/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.OutputStream;
import java.nio.charset.Charset;
import oz.lottie.custom.okio.Buffer;
import oz.lottie.custom.okio.BufferedSink;
import oz.lottie.custom.okio.ByteString;
import oz.lottie.custom.okio.RealBufferedSink$1;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Source;
import oz.lottie.custom.okio.Timeout;
import oz.lottie.custom.okio.Util;

final class RealBufferedSink
implements BufferedSink {
    public final Buffer buffer;
    public final Sink sink;
    private boolean closed;

    public RealBufferedSink(Sink sink, Buffer buffer) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        this.buffer = buffer;
        this.sink = sink;
    }

    public RealBufferedSink(Sink sink) {
        this(sink, new Buffer());
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(Buffer buffer, long l) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(buffer, l);
        this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(ByteString byteString) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byteString);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeUtf8(String string) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8(string);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeString(String string, Charset charset) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeString(string, charset);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(byte[] byArray) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byArray);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink write(byte[] byArray, int n, int n2) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.write(byArray, n, n2);
        return this.emitCompleteSegments();
    }

    @Override
    public long writeAll(Source source) {
        long l;
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        long l2 = 0L;
        while ((l = source.read(this.buffer, 2048L)) != -1L) {
            l2 += l;
            this.emitCompleteSegments();
        }
        return l2;
    }

    @Override
    public BufferedSink write(Source source, long l) {
        if (l > 0L) {
            source.read(this.buffer, l);
        }
        return this;
    }

    @Override
    public BufferedSink writeByte(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeByte(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeShort(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeShort(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeShortLe(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeShortLe(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeInt(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeInt(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeIntLe(int n) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeIntLe(n);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeLong(long l) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeLong(l);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink writeLongLe(long l) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeLongLe(l);
        return this.emitCompleteSegments();
    }

    @Override
    public BufferedSink emitCompleteSegments() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l = this.buffer.completeSegmentByteCount();
        if (l > 0L) {
            this.sink.write(this.buffer, l);
        }
        return this;
    }

    @Override
    public BufferedSink emit() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l = this.buffer.size();
        if (l > 0L) {
            this.sink.write(this.buffer, l);
        }
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new RealBufferedSink$1(this);
    }

    @Override
    public void flush() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size > 0L) {
            this.sink.write(this.buffer, this.buffer.size);
        }
        this.sink.flush();
    }

    @Override
    public void close() {
        Throwable throwable;
        block7: {
            if (this.closed) {
                return;
            }
            throwable = null;
            try {
                if (this.buffer.size > 0L) {
                    this.sink.write(this.buffer, this.buffer.size);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            try {
                this.sink.close();
            }
            catch (Throwable throwable3) {
                if (throwable != null) break block7;
                throwable = throwable3;
            }
        }
        this.closed = true;
        if (throwable != null) {
            Util.sneakyRethrow(throwable);
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "buffer(" + this.sink + ")";
    }

    @Override
    public BufferedSink writeUtf8(String string, int n, int n2) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        this.buffer.writeUtf8(string, n, n2);
        return this.emitCompleteSegments();
    }

    static /* synthetic */ boolean access$0(RealBufferedSink realBufferedSink) {
        return realBufferedSink.closed;
    }
}

