/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.custom.okio;

import java.io.EOFException;
import java.io.InputStream;
import java.nio.charset.Charset;
import oz.lottie.custom.okio.Buffer;
import oz.lottie.custom.okio.BufferedSource;
import oz.lottie.custom.okio.ByteString;
import oz.lottie.custom.okio.Options;
import oz.lottie.custom.okio.RealBufferedSource$1;
import oz.lottie.custom.okio.Sink;
import oz.lottie.custom.okio.Source;
import oz.lottie.custom.okio.Timeout;
import oz.lottie.custom.okio.Util;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer;
    public final Source source;
    private boolean closed;

    public RealBufferedSource(Source source, Buffer buffer) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        this.buffer = buffer;
        this.source = source;
    }

    public RealBufferedSource(Source source) {
        this(source, new Buffer());
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public long read(Buffer buffer, long l) {
        long l2;
        if (buffer == null) {
            throw new IllegalArgumentException("sink == null");
        }
        if (l < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size == 0L && (l2 = this.source.read(this.buffer, 2048L)) == -1L) {
            return -1L;
        }
        l2 = Math.min(l, this.buffer.size);
        return this.buffer.read(buffer, l2);
    }

    @Override
    public boolean exhausted() {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 2048L) == -1L;
    }

    @Override
    public void require(long l) {
        if (!this.request(l)) {
            throw new EOFException();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean request(long var1_1) {
        if (var1_1 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + var1_1);
        }
        if (!this.closed) ** GOTO lbl7
        throw new IllegalStateException("closed");
lbl-1000:
        // 1 sources

        {
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return false;
lbl7:
            // 2 sources

            ** while (this.buffer.size < var1_1)
        }
lbl8:
        // 1 sources

        return true;
    }

    @Override
    public byte readByte() {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public ByteString readByteString() {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteString();
    }

    @Override
    public ByteString readByteString(long l) {
        this.require(l);
        return this.buffer.readByteString(l);
    }

    @Override
    public byte[] readByteArray() {
        this.buffer.writeAll(this.source);
        return this.buffer.readByteArray();
    }

    @Override
    public byte[] readByteArray(long l) {
        this.require(l);
        return this.buffer.readByteArray(l);
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void readFully(byte[] var1_1) {
        block4: {
            try {
                this.require(var1_1.length);
                break block4;
            }
            catch (EOFException var2_2) {
                var3_3 = 0;
                ** while (this.buffer.size > 0L)
            }
lbl-1000:
            // 1 sources

            {
                var4_4 = this.buffer.read(var1_1, var3_3, (int)this.buffer.size - var3_3);
                if (var4_4 == -1) {
                    throw new AssertionError();
                }
                var3_3 += var4_4;
                continue;
            }
lbl12:
            // 1 sources

            throw var2_2;
        }
        this.buffer.readFully(var1_1);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        long l;
        Util.checkOffsetAndCount(byArray.length, n, n2);
        if (this.buffer.size == 0L && (l = this.source.read(this.buffer, 2048L)) == -1L) {
            return -1;
        }
        int n3 = (int)Math.min((long)n2, this.buffer.size);
        return this.buffer.read(byArray, n, n3);
    }

    @Override
    public void readFully(Buffer buffer, long l) {
        try {
            this.require(l);
        }
        catch (EOFException eOFException) {
            buffer.writeAll(this.buffer);
            throw eOFException;
        }
        this.buffer.readFully(buffer, l);
    }

    @Override
    public long readAll(Sink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("sink == null");
        }
        long l = 0L;
        while (this.source.read(this.buffer, 2048L) != -1L) {
            long l2 = this.buffer.completeSegmentByteCount();
            if (l2 <= 0L) continue;
            l += l2;
            sink.write(this.buffer, l2);
        }
        if (this.buffer.size() > 0L) {
            l += this.buffer.size();
            sink.write(this.buffer, this.buffer.size());
        }
        return l;
    }

    @Override
    public String readUtf8() {
        this.buffer.writeAll(this.source);
        return this.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long l) {
        this.require(l);
        return this.buffer.readUtf8(l);
    }

    @Override
    public String readString(Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        this.buffer.writeAll(this.source);
        return this.buffer.readString(charset);
    }

    @Override
    public String readString(long l, Charset charset) {
        this.require(l);
        if (charset == null) {
            throw new IllegalArgumentException("charset == null");
        }
        return this.buffer.readString(l, charset);
    }

    @Override
    public String readUtf8Line() {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            return this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
        }
        return this.buffer.readUtf8Line(l);
    }

    @Override
    public String readUtf8LineStrict() {
        long l = this.indexOf((byte)10);
        if (l == -1L) {
            Buffer buffer = new Buffer();
            this.buffer.copyTo(buffer, 0L, Math.min(32L, this.buffer.size()));
            throw new EOFException("\\n not found: size=" + this.buffer.size() + " content=" + buffer.readByteString().hex() + "...");
        }
        return this.buffer.readUtf8Line(l);
    }

    @Override
    public short readShort() {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void skip(long var1_1) {
        if (!this.closed) ** GOTO lbl8
        throw new IllegalStateException("closed");
lbl-1000:
        // 1 sources

        {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 2048L) == -1L) {
                throw new EOFException();
            }
            var3_2 = Math.min(var1_1, this.buffer.size());
            this.buffer.skip(var3_2);
            var1_1 -= var3_2;
lbl8:
            // 2 sources

            ** while (var1_1 > 0L)
        }
lbl9:
        // 1 sources

    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long indexOf(byte var1_1, long var2_2) {
        if (!this.closed) ** GOTO lbl5
        throw new IllegalStateException("closed");
lbl-1000:
        // 1 sources

        {
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return -1L;
lbl5:
            // 2 sources

            ** while (var2_2 >= this.buffer.size)
        }
lbl6:
        // 2 sources

        while ((var4_3 = this.buffer.indexOf(var1_1, var2_2)) == -1L) {
            var2_2 = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return -1L;
        }
        return var4_3;
    }

    @Override
    public long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long indexOfElement(ByteString var1_1, long var2_2) {
        if (!this.closed) ** GOTO lbl5
        throw new IllegalStateException("closed");
lbl-1000:
        // 1 sources

        {
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return -1L;
lbl5:
            // 2 sources

            ** while (var2_2 >= this.buffer.size)
        }
lbl6:
        // 2 sources

        while ((var4_3 = this.buffer.indexOfElement(var1_1, var2_2)) == -1L) {
            var2_2 = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return -1L;
        }
        return var4_3;
    }

    @Override
    public InputStream inputStream() {
        return new RealBufferedSource$1(this);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }

    @Override
    public long indexOf(ByteString byteString) {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l) {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l2;
        while ((l2 = this.buffer.indexOf(byteString, l)) == -1L) {
            long l3 = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) == -1L) {
                return -1L;
            }
            l = Math.max(l, l3 - (long)byteString.size() + 1L);
        }
        return l2;
    }

    @Override
    public int select(Options options) {
        int n;
        block3: {
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            do {
                if ((n = this.buffer.selectPrefix(options, true)) == -1) {
                    return -1;
                }
                if (n != -2) break block3;
            } while (this.source.read(this.buffer, 2048L) != -1L);
            return -1;
        }
        int n2 = options.byteStrings[n].size();
        this.buffer.skip(n2);
        return n;
    }

    static /* synthetic */ boolean access$0(RealBufferedSource realBufferedSource) {
        return realBufferedSource.closed;
    }
}

