/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.content;

import android.graphics.PointF;
import java.util.ArrayList;
import java.util.List;
import oz.lottie.model.CubicCurveData;
import oz.lottie.utils.Logger;
import oz.lottie.utils.MiscUtils;

public class ShapeData {
    private final List curves;
    private PointF initialPoint;
    private boolean closed;

    public ShapeData(PointF pointF, boolean bl, List list) {
        this.initialPoint = pointF;
        this.closed = bl;
        this.curves = new ArrayList(list);
    }

    public ShapeData() {
        this.curves = new ArrayList();
    }

    private void setInitialPoint(float f2, float f3) {
        if (this.initialPoint == null) {
            this.initialPoint = new PointF();
        }
        this.initialPoint.set(f2, f3);
    }

    public PointF getInitialPoint() {
        return this.initialPoint;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public List getCurves() {
        return this.curves;
    }

    public void interpolateBetween(ShapeData shapeData, ShapeData shapeData2, float f2) {
        int n;
        if (this.initialPoint == null) {
            this.initialPoint = new PointF();
        }
        boolean bl = this.closed = shapeData.isClosed() || shapeData2.isClosed();
        if (shapeData.getCurves().size() != shapeData2.getCurves().size()) {
            Logger.warning("Curves must have the same number of control points. Shape 1: " + shapeData.getCurves().size() + "\tShape 2: " + shapeData2.getCurves().size());
        }
        int n2 = Math.min(shapeData.getCurves().size(), shapeData2.getCurves().size());
        if (this.curves.size() < n2) {
            n = this.curves.size();
            while (n < n2) {
                this.curves.add(new CubicCurveData());
                ++n;
            }
        } else if (this.curves.size() > n2) {
            n = this.curves.size() - 1;
            while (n >= n2) {
                this.curves.remove(this.curves.size() - 1);
                --n;
            }
        }
        PointF pointF = shapeData.getInitialPoint();
        PointF pointF2 = shapeData2.getInitialPoint();
        this.setInitialPoint(MiscUtils.lerp(pointF.x, pointF2.x, f2), MiscUtils.lerp(pointF.y, pointF2.y, f2));
        int n3 = this.curves.size() - 1;
        while (n3 >= 0) {
            CubicCurveData cubicCurveData = (CubicCurveData)shapeData.getCurves().get(n3);
            CubicCurveData cubicCurveData2 = (CubicCurveData)shapeData2.getCurves().get(n3);
            PointF pointF3 = cubicCurveData.getControlPoint1();
            PointF pointF4 = cubicCurveData.getControlPoint2();
            PointF pointF5 = cubicCurveData.getVertex();
            PointF pointF6 = cubicCurveData2.getControlPoint1();
            PointF pointF7 = cubicCurveData2.getControlPoint2();
            PointF pointF8 = cubicCurveData2.getVertex();
            ((CubicCurveData)this.curves.get(n3)).setControlPoint1(MiscUtils.lerp(pointF3.x, pointF6.x, f2), MiscUtils.lerp(pointF3.y, pointF6.y, f2));
            ((CubicCurveData)this.curves.get(n3)).setControlPoint2(MiscUtils.lerp(pointF4.x, pointF7.x, f2), MiscUtils.lerp(pointF4.y, pointF7.y, f2));
            ((CubicCurveData)this.curves.get(n3)).setVertex(MiscUtils.lerp(pointF5.x, pointF8.x, f2), MiscUtils.lerp(pointF5.y, pointF8.y, f2));
            --n3;
        }
    }

    public String toString() {
        return "ShapeData{numCurves=" + this.curves.size() + "closed=" + this.closed + '}';
    }
}

