/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.layer;

import java.util.List;
import java.util.Locale;
import oz.lottie.LottieComposition;
import oz.lottie.model.animatable.AnimatableFloatValue;
import oz.lottie.model.animatable.AnimatableTextFrame;
import oz.lottie.model.animatable.AnimatableTextProperties;
import oz.lottie.model.animatable.AnimatableTransform;
import oz.lottie.model.layer.Layer$LayerType;
import oz.lottie.model.layer.Layer$MatteType;

public class Layer {
    private final List shapes;
    private final LottieComposition composition;
    private final String layerName;
    private final long layerId;
    private final Layer$LayerType layerType;
    private final long parentId;
    private final String refId;
    private final List masks;
    private final AnimatableTransform transform;
    private final int solidWidth;
    private final int solidHeight;
    private final int solidColor;
    private final float timeStretch;
    private final float startFrame;
    private final int preCompWidth;
    private final int preCompHeight;
    private final AnimatableTextFrame text;
    private final AnimatableTextProperties textProperties;
    private final AnimatableFloatValue timeRemapping;
    private final List inOutKeyframes;
    private final Layer$MatteType matteType;
    private final boolean hidden;

    public Layer(List list, LottieComposition lottieComposition, String string, long l, Layer$LayerType layer$LayerType, long l2, String string2, List list2, AnimatableTransform animatableTransform, int n, int n2, int n3, float f2, float f3, int n4, int n5, AnimatableTextFrame animatableTextFrame, AnimatableTextProperties animatableTextProperties, List list3, Layer$MatteType layer$MatteType, AnimatableFloatValue animatableFloatValue, boolean bl) {
        this.shapes = list;
        this.composition = lottieComposition;
        this.layerName = string;
        this.layerId = l;
        this.layerType = layer$LayerType;
        this.parentId = l2;
        this.refId = string2;
        this.masks = list2;
        this.transform = animatableTransform;
        this.solidWidth = n;
        this.solidHeight = n2;
        this.solidColor = n3;
        this.timeStretch = f2;
        this.startFrame = f3;
        this.preCompWidth = n4;
        this.preCompHeight = n5;
        this.text = animatableTextFrame;
        this.textProperties = animatableTextProperties;
        this.inOutKeyframes = list3;
        this.matteType = layer$MatteType;
        this.timeRemapping = animatableFloatValue;
        this.hidden = bl;
    }

    LottieComposition getComposition() {
        return this.composition;
    }

    float getTimeStretch() {
        return this.timeStretch;
    }

    float getStartProgress() {
        return this.startFrame / this.composition.getDurationFrames();
    }

    List getInOutKeyframes() {
        return this.inOutKeyframes;
    }

    public long getId() {
        return this.layerId;
    }

    String getName() {
        return this.layerName;
    }

    String getRefId() {
        return this.refId;
    }

    int getPreCompWidth() {
        return this.preCompWidth;
    }

    int getPreCompHeight() {
        return this.preCompHeight;
    }

    List getMasks() {
        return this.masks;
    }

    public Layer$LayerType getLayerType() {
        return this.layerType;
    }

    Layer$MatteType getMatteType() {
        return this.matteType;
    }

    long getParentId() {
        return this.parentId;
    }

    List getShapes() {
        return this.shapes;
    }

    AnimatableTransform getTransform() {
        return this.transform;
    }

    int getSolidColor() {
        return this.solidColor;
    }

    int getSolidHeight() {
        return this.solidHeight;
    }

    int getSolidWidth() {
        return this.solidWidth;
    }

    AnimatableTextFrame getText() {
        return this.text;
    }

    AnimatableTextProperties getTextProperties() {
        return this.textProperties;
    }

    AnimatableFloatValue getTimeRemapping() {
        return this.timeRemapping;
    }

    public String toString() {
        return this.toString("");
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(this.getName()).append("\n");
        Layer layer = this.composition.layerModelForId(this.getParentId());
        if (layer != null) {
            stringBuilder.append("\t\tParents: ").append(layer.getName());
            layer = this.composition.layerModelForId(layer.getParentId());
            while (layer != null) {
                stringBuilder.append("->").append(layer.getName());
                layer = this.composition.layerModelForId(layer.getParentId());
            }
            stringBuilder.append(string).append("\n");
        }
        if (!this.getMasks().isEmpty()) {
            stringBuilder.append(string).append("\tMasks: ").append(this.getMasks().size()).append("\n");
        }
        if (this.getSolidWidth() != 0 && this.getSolidHeight() != 0) {
            stringBuilder.append(string).append("\tBackground: ").append(String.format(Locale.US, "%dx%d %X\n", this.getSolidWidth(), this.getSolidHeight(), this.getSolidColor()));
        }
        if (!this.shapes.isEmpty()) {
            stringBuilder.append(string).append("\tShapes:\n");
            for (Object e2 : this.shapes) {
                stringBuilder.append(string).append("\t\t").append(e2).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

