/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.animation.LPaint;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.model.layer.Layer;
import oz.lottie.value.LottieValueCallback;

public class SolidLayer
extends BaseLayer {
    private final RectF rect = new RectF();
    private final Paint paint = new LPaint();
    private final float[] points = new float[8];
    private final Path path = new Path();
    private final Layer layerModel;
    private BaseKeyframeAnimation colorFilterAnimation;

    SolidLayer(LottieDrawable lottieDrawable, Layer layer) {
        super(lottieDrawable, layer);
        this.layerModel = layer;
        this.paint.setAlpha(0);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(layer.getSolidColor());
    }

    @Override
    public void drawLayer(Canvas canvas, Matrix matrix, int n) {
        int n2 = Color.alpha((int)this.layerModel.getSolidColor());
        if (n2 == 0) {
            return;
        }
        int n3 = this.transform.getOpacity() == null ? 100 : (Integer)this.transform.getOpacity().getValue();
        int n4 = (int)((float)n / 255.0f * ((float)n2 / 255.0f * (float)n3 / 100.0f) * 255.0f);
        this.paint.setAlpha(n4);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter((ColorFilter)this.colorFilterAnimation.getValue());
        }
        if (n4 > 0) {
            this.points[0] = 0.0f;
            this.points[1] = 0.0f;
            this.points[2] = this.layerModel.getSolidWidth();
            this.points[3] = 0.0f;
            this.points[4] = this.layerModel.getSolidWidth();
            this.points[5] = this.layerModel.getSolidHeight();
            this.points[6] = 0.0f;
            this.points[7] = this.layerModel.getSolidHeight();
            matrix.mapPoints(this.points);
            this.path.reset();
            this.path.moveTo(this.points[0], this.points[1]);
            this.path.lineTo(this.points[2], this.points[3]);
            this.path.lineTo(this.points[4], this.points[5]);
            this.path.lineTo(this.points[6], this.points[7]);
            this.path.lineTo(this.points[0], this.points[1]);
            this.path.close();
            canvas.drawPath(this.path, this.paint);
        }
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        super.getBounds(rectF, matrix, bl);
        this.rect.set(0.0f, 0.0f, (float)this.layerModel.getSolidWidth(), (float)this.layerModel.getSolidHeight());
        this.boundsMatrix.mapRect(this.rect);
        rectF.set(this.rect);
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        super.addValueCallback(object, lottieValueCallback);
        if (object == LottieProperty.COLOR_FILTER) {
            this.colorFilterAnimation = lottieValueCallback == null ? null : new ValueCallbackKeyframeAnimation(lottieValueCallback);
        }
    }
}

