/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.LongSparseArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oz.lottie.LottieComposition;
import oz.lottie.LottieDrawable;
import oz.lottie.LottieProperty;
import oz.lottie.TextDelegate;
import oz.lottie.animation.content.ContentGroup;
import oz.lottie.animation.keyframe.BaseKeyframeAnimation;
import oz.lottie.animation.keyframe.TextKeyframeAnimation;
import oz.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import oz.lottie.model.DocumentData;
import oz.lottie.model.DocumentData$Justification;
import oz.lottie.model.Font;
import oz.lottie.model.FontCharacter;
import oz.lottie.model.animatable.AnimatableTextProperties;
import oz.lottie.model.content.ShapeGroup;
import oz.lottie.model.layer.BaseLayer;
import oz.lottie.model.layer.Layer;
import oz.lottie.model.layer.TextLayer$1;
import oz.lottie.model.layer.TextLayer$2;
import oz.lottie.utils.Utils;
import oz.lottie.value.LottieValueCallback;

public class TextLayer
extends BaseLayer {
    private final StringBuilder stringBuilder = new StringBuilder(2);
    private final RectF rectF = new RectF();
    private final Matrix matrix = new Matrix();
    private final Paint fillPaint = new TextLayer$1(this, 1);
    private final Paint strokePaint = new TextLayer$2(this, 1);
    private final Map contentsForCharacter = new HashMap();
    private final LongSparseArray codePointCache = new LongSparseArray();
    private final TextKeyframeAnimation textAnimation;
    private final LottieDrawable lottieDrawable;
    private final LottieComposition composition;
    private BaseKeyframeAnimation colorAnimation;
    private BaseKeyframeAnimation strokeColorAnimation;
    private BaseKeyframeAnimation strokeWidthAnimation;
    private BaseKeyframeAnimation trackingAnimation;
    private BaseKeyframeAnimation textSizeAnimation;

    TextLayer(LottieDrawable lottieDrawable, Layer layer) {
        super(lottieDrawable, layer);
        this.lottieDrawable = lottieDrawable;
        this.composition = layer.getComposition();
        this.textAnimation = layer.getText().createAnimation();
        this.textAnimation.addUpdateListener(this);
        this.addAnimation(this.textAnimation);
        AnimatableTextProperties animatableTextProperties = layer.getTextProperties();
        if (animatableTextProperties != null && animatableTextProperties.color != null) {
            this.colorAnimation = animatableTextProperties.color.createAnimation();
            this.colorAnimation.addUpdateListener(this);
            this.addAnimation(this.colorAnimation);
        }
        if (animatableTextProperties != null && animatableTextProperties.stroke != null) {
            this.strokeColorAnimation = animatableTextProperties.stroke.createAnimation();
            this.strokeColorAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeColorAnimation);
        }
        if (animatableTextProperties != null && animatableTextProperties.strokeWidth != null) {
            this.strokeWidthAnimation = animatableTextProperties.strokeWidth.createAnimation();
            this.strokeWidthAnimation.addUpdateListener(this);
            this.addAnimation(this.strokeWidthAnimation);
        }
        if (animatableTextProperties != null && animatableTextProperties.tracking != null) {
            this.trackingAnimation = animatableTextProperties.tracking.createAnimation();
            this.trackingAnimation.addUpdateListener(this);
            this.addAnimation(this.trackingAnimation);
        }
    }

    @Override
    public void getBounds(RectF rectF, Matrix matrix, boolean bl) {
        super.getBounds(rectF, matrix, bl);
        rectF.set(0.0f, 0.0f, (float)this.composition.getBounds().width(), (float)this.composition.getBounds().height());
    }

    @Override
    void drawLayer(Canvas canvas, Matrix matrix, int n) {
        canvas.save();
        if (!this.lottieDrawable.useTextGlyphs()) {
            canvas.setMatrix(matrix);
        }
        DocumentData documentData = (DocumentData)this.textAnimation.getValue();
        Font font = (Font)this.composition.getFonts().get(documentData.fontName);
        if (font == null) {
            canvas.restore();
            return;
        }
        if (this.colorAnimation != null) {
            this.fillPaint.setColor(((Integer)this.colorAnimation.getValue()).intValue());
        } else {
            this.fillPaint.setColor(documentData.color);
        }
        if (this.strokeColorAnimation != null) {
            this.strokePaint.setColor(((Integer)this.strokeColorAnimation.getValue()).intValue());
        } else {
            this.strokePaint.setColor(documentData.strokeColor);
        }
        int n2 = this.transform.getOpacity() == null ? 100 : (Integer)this.transform.getOpacity().getValue();
        int n3 = n2 * 255 / 100;
        this.fillPaint.setAlpha(n3);
        this.strokePaint.setAlpha(n3);
        if (this.strokeWidthAnimation != null) {
            this.strokePaint.setStrokeWidth(((Float)this.strokeWidthAnimation.getValue()).floatValue());
        } else {
            float f2 = Utils.getScale(matrix);
            this.strokePaint.setStrokeWidth(documentData.strokeWidth * Utils.dpScale() * f2);
        }
        if (this.lottieDrawable.useTextGlyphs()) {
            this.drawTextGlyphs(documentData, matrix, font, canvas);
        } else {
            this.drawTextWithFont(documentData, font, matrix, canvas);
        }
        canvas.restore();
    }

    private void drawTextGlyphs(DocumentData documentData, Matrix matrix, Font font, Canvas canvas) {
        float f2 = this.textSizeAnimation == null ? documentData.size : ((Float)this.textSizeAnimation.getValue()).floatValue();
        float f3 = f2 / 100.0f;
        float f4 = Utils.getScale(matrix);
        String string = documentData.text;
        float f5 = documentData.lineHeight * Utils.dpScale();
        List list = this.getTextLines(string);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)list.get(n2);
            float f6 = this.getTextLineWidthForGlyphs(string2, font, f3, f4);
            canvas.save();
            this.applyJustification(documentData.justification, canvas, f6);
            float f7 = (float)(n - 1) * f5 / 2.0f;
            float f8 = (float)n2 * f5 - f7;
            canvas.translate(0.0f, f8);
            this.drawGlyphTextLine(string2, documentData, matrix, font, canvas, f4, f3);
            canvas.restore();
            ++n2;
        }
    }

    private void drawGlyphTextLine(String string, DocumentData documentData, Matrix matrix, Font font, Canvas canvas, float f2, float f3) {
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            int n2 = FontCharacter.hashFor(c2, font.getFamily(), font.getStyle());
            FontCharacter fontCharacter = (FontCharacter)this.composition.getCharacters().get(n2);
            if (fontCharacter != null) {
                this.drawCharacterAsGlyph(fontCharacter, matrix, f3, documentData, canvas);
                float f4 = (float)fontCharacter.getWidth() * f3 * Utils.dpScale() * f2;
                float f5 = (float)documentData.tracking / 10.0f;
                if (this.trackingAnimation != null) {
                    f5 += ((Float)this.trackingAnimation.getValue()).floatValue();
                }
                canvas.translate(f4 += f5 * f2, 0.0f);
            }
            ++n;
        }
    }

    private void drawTextWithFont(DocumentData documentData, Font font, Matrix matrix, Canvas canvas) {
        float f2 = Utils.getScale(matrix);
        Typeface typeface = this.lottieDrawable.getTypeface(font.getFamily(), font.getStyle());
        if (typeface == null) {
            return;
        }
        String string = documentData.text;
        TextDelegate textDelegate = this.lottieDrawable.getTextDelegate();
        if (textDelegate != null) {
            string = textDelegate.getTextInternal(string);
        }
        this.fillPaint.setTypeface(typeface);
        float f3 = this.textSizeAnimation == null ? documentData.size : ((Float)this.textSizeAnimation.getValue()).floatValue();
        this.fillPaint.setTextSize(f3 * Utils.dpScale());
        this.strokePaint.setTypeface(this.fillPaint.getTypeface());
        this.strokePaint.setTextSize(this.fillPaint.getTextSize());
        float f4 = documentData.lineHeight * Utils.dpScale();
        List list = this.getTextLines(string);
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)list.get(n2);
            float f5 = this.strokePaint.measureText(string2);
            this.applyJustification(documentData.justification, canvas, f5);
            float f6 = (float)(n - 1) * f4 / 2.0f;
            float f7 = (float)n2 * f4 - f6;
            canvas.translate(0.0f, f7);
            this.drawFontTextLine(string2, documentData, canvas, f2);
            canvas.setMatrix(matrix);
            ++n2;
        }
    }

    private List getTextLines(String string) {
        String string2 = string.replaceAll("\r\n", "\r").replaceAll("\n", "\r");
        String[] stringArray = string2.split("\r");
        return Arrays.asList(stringArray);
    }

    private void drawFontTextLine(String string, DocumentData documentData, Canvas canvas, float f2) {
        int n = 0;
        while (n < string.length()) {
            String string2 = this.codePointToString(string, n);
            n += string2.length();
            this.drawCharacterFromFont(string2, documentData, canvas);
            float f3 = this.fillPaint.measureText(string2, 0, 1);
            float f4 = (float)documentData.tracking / 10.0f;
            if (this.trackingAnimation != null) {
                f4 += ((Float)this.trackingAnimation.getValue()).floatValue();
            }
            float f5 = f3 + f4 * f2;
            canvas.translate(f5, 0.0f);
        }
    }

    private float getTextLineWidthForGlyphs(String string, Font font, float f2, float f3) {
        float f4 = 0.0f;
        int n = 0;
        while (n < string.length()) {
            char c2 = string.charAt(n);
            int n2 = FontCharacter.hashFor(c2, font.getFamily(), font.getStyle());
            FontCharacter fontCharacter = (FontCharacter)this.composition.getCharacters().get(n2);
            if (fontCharacter != null) {
                f4 = (float)((double)f4 + fontCharacter.getWidth() * (double)f2 * (double)Utils.dpScale() * (double)f3);
            }
            ++n;
        }
        return f4;
    }

    private void applyJustification(DocumentData$Justification documentData$Justification, Canvas canvas, float f2) {
        switch (documentData$Justification) {
            case LEFT_ALIGN: {
                break;
            }
            case RIGHT_ALIGN: {
                canvas.translate(-f2, 0.0f);
                break;
            }
            case CENTER: {
                canvas.translate(-f2 / 2.0f, 0.0f);
            }
        }
    }

    private void drawCharacterAsGlyph(FontCharacter fontCharacter, Matrix matrix, float f2, DocumentData documentData, Canvas canvas) {
        List list = this.getContentsForCharacter(fontCharacter);
        int n = 0;
        while (n < list.size()) {
            Path path = ((ContentGroup)list.get(n)).getPath();
            path.computeBounds(this.rectF, false);
            this.matrix.set(matrix);
            this.matrix.preTranslate(0.0f, -documentData.baselineShift * Utils.dpScale());
            this.matrix.preScale(f2, f2);
            path.transform(this.matrix);
            if (documentData.strokeOverFill) {
                this.drawGlyph(path, this.fillPaint, canvas);
                this.drawGlyph(path, this.strokePaint, canvas);
            } else {
                this.drawGlyph(path, this.strokePaint, canvas);
                this.drawGlyph(path, this.fillPaint, canvas);
            }
            ++n;
        }
    }

    private void drawGlyph(Path path, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawPath(path, paint);
    }

    private void drawCharacterFromFont(String string, DocumentData documentData, Canvas canvas) {
        if (documentData.strokeOverFill) {
            this.drawCharacter(string, this.fillPaint, canvas);
            this.drawCharacter(string, this.strokePaint, canvas);
        } else {
            this.drawCharacter(string, this.strokePaint, canvas);
            this.drawCharacter(string, this.fillPaint, canvas);
        }
    }

    private void drawCharacter(String string, Paint paint, Canvas canvas) {
        if (paint.getColor() == 0) {
            return;
        }
        if (paint.getStyle() == Paint.Style.STROKE && paint.getStrokeWidth() == 0.0f) {
            return;
        }
        canvas.drawText(string, 0, string.length(), 0.0f, 0.0f, paint);
    }

    private List getContentsForCharacter(FontCharacter fontCharacter) {
        if (this.contentsForCharacter.containsKey(fontCharacter)) {
            return (List)this.contentsForCharacter.get(fontCharacter);
        }
        List list = fontCharacter.getShapes();
        int n = list.size();
        ArrayList<ContentGroup> arrayList = new ArrayList<ContentGroup>(n);
        int n2 = 0;
        while (n2 < n) {
            ShapeGroup shapeGroup = (ShapeGroup)list.get(n2);
            arrayList.add(new ContentGroup(this.lottieDrawable, this, shapeGroup));
            ++n2;
        }
        this.contentsForCharacter.put(fontCharacter, arrayList);
        return arrayList;
    }

    private String codePointToString(String string, int n) {
        int n2;
        int n3;
        int n4 = string.codePointAt(n);
        int n5 = Character.charCount(n4);
        int n6 = n4;
        int n7 = n + n5;
        while (n7 < string.length()) {
            n3 = string.codePointAt(n7);
            if (!this.isModifier(n3)) break;
            n2 = Character.charCount(n3);
            n7 += n2;
            n6 = n6 * 31 + n3;
        }
        if (this.codePointCache.indexOfKey((long)n6) >= 0) {
            return (String)this.codePointCache.get((long)n6);
        }
        this.stringBuilder.setLength(0);
        n3 = n;
        while (n3 < n7) {
            n2 = string.codePointAt(n3);
            this.stringBuilder.appendCodePoint(n2);
            n3 += Character.charCount(n2);
        }
        String string2 = this.stringBuilder.toString();
        this.codePointCache.put((long)n6, (Object)string2);
        return string2;
    }

    private boolean isModifier(int n) {
        return Character.getType(n) == 16 || Character.getType(n) == 27 || Character.getType(n) == 6 || Character.getType(n) == 28 || Character.getType(n) == 19;
    }

    @Override
    public void addValueCallback(Object object, LottieValueCallback lottieValueCallback) {
        super.addValueCallback(object, lottieValueCallback);
        if (object == LottieProperty.COLOR) {
            if (this.colorAnimation != null) {
                this.colorAnimation.setValueCallback(lottieValueCallback);
            } else if (lottieValueCallback == null) {
                if (this.colorAnimation != null) {
                    this.removeAnimation(this.colorAnimation);
                }
                this.colorAnimation = null;
            } else {
                this.colorAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.colorAnimation.addUpdateListener(this);
                this.addAnimation(this.colorAnimation);
            }
        } else if (object == LottieProperty.STROKE_COLOR) {
            if (this.strokeColorAnimation != null) {
                this.strokeColorAnimation.setValueCallback(lottieValueCallback);
            } else if (lottieValueCallback == null) {
                if (this.strokeColorAnimation != null) {
                    this.removeAnimation(this.strokeColorAnimation);
                }
                this.strokeColorAnimation = null;
            } else {
                this.strokeColorAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.strokeColorAnimation.addUpdateListener(this);
                this.addAnimation(this.strokeColorAnimation);
            }
        } else if (object == LottieProperty.STROKE_WIDTH) {
            if (this.strokeWidthAnimation != null) {
                this.strokeWidthAnimation.setValueCallback(lottieValueCallback);
            } else if (lottieValueCallback == null) {
                if (this.strokeWidthAnimation != null) {
                    this.removeAnimation(this.strokeWidthAnimation);
                }
                this.strokeWidthAnimation = null;
            } else {
                this.strokeWidthAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.strokeWidthAnimation.addUpdateListener(this);
                this.addAnimation(this.strokeWidthAnimation);
            }
        } else if (object == LottieProperty.TEXT_TRACKING) {
            if (this.trackingAnimation != null) {
                this.trackingAnimation.setValueCallback(lottieValueCallback);
            } else if (lottieValueCallback == null) {
                if (this.trackingAnimation != null) {
                    this.removeAnimation(this.trackingAnimation);
                }
                this.trackingAnimation = null;
            } else {
                this.trackingAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.trackingAnimation.addUpdateListener(this);
                this.addAnimation(this.trackingAnimation);
            }
        } else if (object == LottieProperty.TEXT_SIZE) {
            if (lottieValueCallback == null) {
                if (this.textSizeAnimation != null) {
                    this.removeAnimation(this.textSizeAnimation);
                }
                this.textSizeAnimation = null;
            } else {
                this.textSizeAnimation = new ValueCallbackKeyframeAnimation(lottieValueCallback);
                this.textSizeAnimation.addUpdateListener(this);
                this.addAnimation(this.textSizeAnimation);
            }
        }
    }
}

