/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.network;

import android.content.Context;
import android.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import oz.lottie.network.FileExtension;
import oz.lottie.utils.Logger;

class NetworkCache {
    private final Context appContext;
    private final String url;

    NetworkCache(Context context, String string) {
        this.appContext = context.getApplicationContext();
        this.url = string;
    }

    Pair fetch() {
        FileInputStream fileInputStream;
        File file = null;
        try {
            file = this.getCachedFile(this.url);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        FileExtension fileExtension = file.getAbsolutePath().endsWith(".zip") ? FileExtension.ZIP : FileExtension.JSON;
        Logger.debug("Cache hit for " + this.url + " at " + file.getAbsolutePath());
        return new Pair((Object)fileExtension, (Object)fileInputStream);
    }

    File writeTempCacheFile(InputStream inputStream, FileExtension fileExtension) {
        String string = NetworkCache.filenameForUrl(this.url, fileExtension, true);
        File file = new File(this.appContext.getCacheDir(), string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                int n;
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n);
                }
                fileOutputStream.flush();
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        finally {
            inputStream.close();
        }
        return file;
    }

    void renameTempFile(FileExtension fileExtension) {
        String string = NetworkCache.filenameForUrl(this.url, fileExtension, true);
        File file = new File(this.appContext.getCacheDir(), string);
        String string2 = file.getAbsolutePath().replace(".temp", "");
        File file2 = new File(string2);
        boolean bl = file.renameTo(file2);
        Logger.debug("Copying temp file to real file (" + file2 + ")");
        if (!bl) {
            Logger.warning("Unable to rename cache file " + file.getAbsolutePath() + " to " + file2.getAbsolutePath() + ".");
        }
    }

    private File getCachedFile(String string) {
        File file = new File(this.appContext.getCacheDir(), NetworkCache.filenameForUrl(string, FileExtension.JSON, false));
        if (file.exists()) {
            return file;
        }
        File file2 = new File(this.appContext.getCacheDir(), NetworkCache.filenameForUrl(string, FileExtension.ZIP, false));
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private static String filenameForUrl(String string, FileExtension fileExtension, boolean bl) {
        return "lottie_cache_" + string.replaceAll("\\W+", "") + (bl ? fileExtension.tempExtension() : fileExtension.extension);
    }
}

