/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import oz.lottie.LottieComposition;
import oz.lottie.model.content.ContentModel;
import oz.lottie.parser.AnimatableTransformParser;
import oz.lottie.parser.CircleShapeParser;
import oz.lottie.parser.GradientFillParser;
import oz.lottie.parser.GradientStrokeParser;
import oz.lottie.parser.MergePathsParser;
import oz.lottie.parser.PolystarShapeParser;
import oz.lottie.parser.RectangleShapeParser;
import oz.lottie.parser.RepeaterParser;
import oz.lottie.parser.ShapeFillParser;
import oz.lottie.parser.ShapeGroupParser;
import oz.lottie.parser.ShapePathParser;
import oz.lottie.parser.ShapeStrokeParser;
import oz.lottie.parser.ShapeTrimPathParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.utils.Logger;

class ContentModelParser {
    private static JsonReader$Options NAMES = JsonReader$Options.of("ty", "d");

    private ContentModelParser() {
    }

    static ContentModel parse(JsonReader jsonReader, LottieComposition lottieComposition) {
        String string = null;
        jsonReader.beginObject();
        int n = 2;
        block4: while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    string = jsonReader.nextString();
                    break block4;
                }
                case 1: {
                    n = jsonReader.nextInt();
                    break;
                }
                default: {
                    jsonReader.skipName();
                    jsonReader.skipValue();
                }
            }
        }
        if (string == null) {
            return null;
        }
        ContentModel contentModel = null;
        if (string.equalsIgnoreCase("gr")) {
            contentModel = ShapeGroupParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("st")) {
            contentModel = ShapeStrokeParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("gs")) {
            contentModel = GradientStrokeParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("fl")) {
            contentModel = ShapeFillParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("gf")) {
            contentModel = GradientFillParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("tr")) {
            contentModel = AnimatableTransformParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("sh")) {
            contentModel = ShapePathParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("el")) {
            contentModel = CircleShapeParser.parse(jsonReader, lottieComposition, n);
        } else if (string.equalsIgnoreCase("rc")) {
            contentModel = RectangleShapeParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("tm")) {
            contentModel = ShapeTrimPathParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("sr")) {
            contentModel = PolystarShapeParser.parse(jsonReader, lottieComposition);
        } else if (string.equalsIgnoreCase("mm")) {
            contentModel = MergePathsParser.parse(jsonReader);
            lottieComposition.addWarning("Animation contains merge paths. Merge paths are only supported on KitKat+ and must be manually enabled by calling enableMergePathsForKitKatAndAbove().");
        } else if (string.equalsIgnoreCase("rp")) {
            contentModel = RepeaterParser.parse(jsonReader, lottieComposition);
        } else {
            Logger.warning("Unknown shape type " + string);
        }
        while (jsonReader.hasNext()) {
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return contentModel;
    }
}

