/*
 * Decompiled with CFR 0.152.
 */
package oz.lottie.parser;

import android.graphics.Rect;
import android.util.LongSparseArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oz.lottie.LottieComposition;
import oz.lottie.custom.SparseArrayCompat;
import oz.lottie.model.layer.Layer;
import oz.lottie.model.layer.Layer$LayerType;
import oz.lottie.parser.LayerParser;
import oz.lottie.parser.moshi.JsonReader;
import oz.lottie.parser.moshi.JsonReader$Options;
import oz.lottie.utils.Logger;
import oz.lottie.utils.Utils;

public class LottieCompositionParser {
    static JsonReader$Options NAMES = JsonReader$Options.of("w", "h", "ip", "op", "fr", "v", "layers", "assets", "fonts", "chars", "markers");

    public static LottieComposition parse(JsonReader jsonReader) {
        float f2 = Utils.dpScale();
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        LongSparseArray longSparseArray = new LongSparseArray();
        ArrayList arrayList = new ArrayList();
        int n = 0;
        int n2 = 0;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        ArrayList arrayList2 = new ArrayList();
        SparseArrayCompat sparseArrayCompat = new SparseArrayCompat();
        LottieComposition lottieComposition = new LottieComposition();
        jsonReader.beginObject();
        block9: while (jsonReader.hasNext()) {
            switch (jsonReader.selectName(NAMES)) {
                case 0: {
                    n = jsonReader.nextInt();
                    break;
                }
                case 1: {
                    n2 = jsonReader.nextInt();
                    break;
                }
                case 2: {
                    f3 = (float)jsonReader.nextDouble();
                    break;
                }
                case 3: {
                    f4 = (float)jsonReader.nextDouble() - 0.01f;
                    break;
                }
                case 4: {
                    f5 = (float)jsonReader.nextDouble();
                    break;
                }
                case 5: {
                    String string = jsonReader.nextString();
                    String[] stringArray = string.split("\\.");
                    int n3 = Integer.parseInt(stringArray[0]);
                    int n4 = Integer.parseInt(stringArray[1]);
                    int n5 = Integer.parseInt(stringArray[2]);
                    if (Utils.isAtLeastVersion(n3, n4, n5, 4, 4, 0)) continue block9;
                    lottieComposition.addWarning("Lottie only supports bodymovin >= 4.4.0");
                    break;
                }
                case 6: {
                    LottieCompositionParser.parseLayers(jsonReader, lottieComposition, arrayList, longSparseArray);
                }
                default: {
                    jsonReader.skipValue();
                }
            }
        }
        int n6 = (int)((float)n * f2);
        int n7 = (int)((float)n2 * f2);
        Rect rect = new Rect(0, 0, n6, n7);
        lottieComposition.init(rect, f3, f4, f5, arrayList, longSparseArray, hashMap, hashMap2, sparseArrayCompat, hashMap3, arrayList2);
        return lottieComposition;
    }

    private static void parseLayers(JsonReader jsonReader, LottieComposition lottieComposition, List list, LongSparseArray longSparseArray) {
        int n = 0;
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            Layer layer = LayerParser.parse(jsonReader, lottieComposition);
            if (layer.getLayerType() == Layer$LayerType.IMAGE) {
                ++n;
            }
            list.add(layer);
            longSparseArray.put(layer.getId(), (Object)layer);
            if (n <= 4) continue;
            Logger.warning("You have " + n + " images. Lottie should primarily be " + "used with shapes. If you are using Adobe Illustrator, convert the Illustrator layers" + " to shape layers.");
        }
        jsonReader.endArray();
    }
}

