/*
 * Decompiled with CFR 0.152.
 */
package oz.main;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import oz.main.OZStorage$WrapRunnable;
import oz.util.OZButton;

public class OZStorage {
    public static int m_screenWidth = 100;
    public static int m_screenHeight = 100;
    public static int m_width = 100;
    public static int m_height = 100;
    public static int m_dpi = 72;
    public static float m_xdpi = 72.0f;
    public static float m_ydpi = 72.0f;
    public static float m_scaledDensity = 1.0f;
    public static String m_helpURL = "";
    public static String tmpCacheDir = "";
    public static String Language = "";
    public static String m_strLan = "";
    public static Point m_SignPadiconMargin = new Point(210, 60);
    public static Point m_SignPadPrevNexticonMargin = new Point(210, 60);
    public static Point m_ImagePickericonMargin = new Point(210, 60);
    public static Point m_ImagePickerPrevNexticonMargin = new Point(210, 60);
    public static Point m_ImagePickerFlashButtonMargin = new Point(50, 50);
    public static HashMap DEVICE_CAMERA_POSITION_PRIORITY = new HashMap();
    public static int CAMERA_POSITION_PORTRAIT_TOP = 1;
    public static int CAMERA_POSITION_LANDSCAPE_TOP = 2;
    public static float padding_1 = 0.0f;
    public static int padding_3 = 0;
    public static int padding_5 = 0;
    public static int padding_10 = 0;
    public static int padding_20 = 0;
    private static Handler UIThreadHandler;

    public static int getButtonSizeWithScreen(Drawable drawable2) {
        int n = drawable2.getIntrinsicHeight();
        int n2 = (int)(m_scaledDensity * 10.0f) + 1;
        if ((double)m_scaledDensity <= 3.0) {
            return n + 2 * n2;
        }
        if ((double)m_scaledDensity <= 5.0) {
            return n + n / 2 + 2 * n2;
        }
        return 2 * n + 2 * n2;
    }

    public static String getImagePath(String string) {
        if ((double)m_scaledDensity <= 1.5) {
            string = string.replace("@1.5", "");
            string = string.replace("@2x", "");
            return string;
        }
        return string;
    }

    public static int getCustomID(String string) {
        String string2 = System.getProperty(string, "-1");
        if ("-1".equals(string2)) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static String _getCustomID(String string) {
        String string2 = System.getProperty(string, "-1");
        return string2;
    }

    public static int getBitmapDensity() {
        int n = 0;
        if (m_scaledDensity <= 1.5f || m_scaledDensity > 3.0f) {
            n = 120;
        }
        return n;
    }

    public static Drawable getDrawable_Toolbar(InputStream inputStream) {
        int n = OZStorage.getBitmapDensity();
        if (m_scaledDensity <= 1.5f) {
            n = 80;
        }
        return OZStorage.getDrawable(inputStream, n);
    }

    public static Drawable getDrawable(InputStream inputStream) {
        return OZStorage.getDrawable(inputStream, OZStorage.getBitmapDensity());
    }

    private static Drawable getDrawable(InputStream inputStream, int n) {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        bitmap.setDensity(n);
        return new BitmapDrawable(bitmap);
    }

    public static Drawable getResourceDrawable(Drawable drawable2) {
        Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if ((double)m_scaledDensity <= 3.0) {
            bitmap.setDensity(0);
        } else {
            bitmap.setDensity(240);
        }
        return new BitmapDrawable(bitmap);
    }

    public static float getDensityDPI() {
        return (float)m_dpi / 160.0f;
    }

    public static float getScreenDPI() {
        return m_xdpi;
    }

    public static int getpixels(int n) {
        int n2 = (int)((float)n * m_scaledDensity + 0.5f);
        return n2;
    }

    public static String getLanguage() {
        return m_strLan;
    }

    public static boolean IsUserLanguage() {
        if (OZStorage.getLanguage() == null) {
            return false;
        }
        return !"".equals(OZStorage.getLanguage());
    }

    public static boolean isViewerLanguageEquals(Locale locale) {
        Locale locale2 = OZStorage.getViewerLocale();
        if (Locale.CHINESE.equals(locale) || Locale.KOREAN.equals(locale) || Locale.JAPANESE.equals(locale)) {
            return locale2.getLanguage().equals(locale.getLanguage());
        }
        if (Locale.ENGLISH.equals(locale)) {
            return locale2.getLanguage().equals(Locale.ENGLISH.getLanguage()) || !locale2.getLanguage().equals(Locale.CHINESE.getLanguage()) && !locale2.getLanguage().equals(Locale.KOREAN.getLanguage()) && !locale2.getLanguage().equals(Locale.JAPANESE.getLanguage());
        }
        return locale2.equals(locale);
    }

    public static Locale getViewerLocale() {
        Locale locale = Locale.getDefault();
        if (!(locale.equals(Locale.KOREA) || locale.equals(Locale.JAPAN) || locale.equals(Locale.CHINA) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.US))) {
            locale = Locale.US;
        }
        if (!OZStorage.IsUserLanguage()) {
            return locale;
        }
        String string = OZStorage.getLanguage().replaceAll("/", "_").toLowerCase();
        if (!string.contains("_")) {
            return locale;
        }
        String string2 = string.substring(0, string.indexOf("_"));
        if (Locale.CHINESE.getLanguage().equals(string2)) {
            if (Locale.CHINA.toString().equalsIgnoreCase(string)) {
                return Locale.CHINA;
            }
            if (Locale.TAIWAN.toString().equalsIgnoreCase(string)) {
                return Locale.TAIWAN;
            }
            return locale;
        }
        if (Locale.KOREAN.getLanguage().equals(string2)) {
            if (Locale.KOREA.toString().equalsIgnoreCase(string)) {
                return Locale.KOREA;
            }
            return locale;
        }
        if (Locale.JAPANESE.getLanguage().equals(string2)) {
            if (Locale.JAPAN.toString().equalsIgnoreCase(string)) {
                return Locale.JAPAN;
            }
            return locale;
        }
        if (Locale.ENGLISH.getLanguage().equals(string2)) {
            if (Locale.US.toString().equalsIgnoreCase(string)) {
                return Locale.US;
            }
            return locale;
        }
        return locale;
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        if (context != null) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            return displayMetrics;
        }
        return null;
    }

    public static float DpPerPx(Context context, boolean bl) {
        if (context != null) {
            DisplayMetrics displayMetrics = OZStorage.getDisplayMetrics(context);
            return displayMetrics.density;
        }
        return 1.0f;
    }

    public static int DpToPx(Context context, float f2, boolean bl) {
        return Math.round(f2 * OZStorage.DpPerPx(context, bl));
    }

    public static int DpToPx(Context context, float f2, boolean bl, boolean bl2, boolean bl3) {
        int n = OZStorage.DpToPx(context, f2, bl);
        if (bl2) {
            DisplayMetrics displayMetrics = OZStorage.getDisplayMetrics(context);
            int n2 = bl ? displayMetrics.widthPixels : displayMetrics.heightPixels;
            if (bl3) {
                n2 -= OZStorage.DpToPx(context, 60.0f, bl);
            }
            if (n2 < n) {
                n = n2;
            }
        }
        return n;
    }

    public static float PxToDp(Context context, int n, boolean bl) {
        return Math.round((float)n / OZStorage.DpPerPx(context, bl));
    }

    public static boolean IsDisplayLandscape(Context context) {
        if (context == null) {
            return false;
        }
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static boolean IsDisplayPortrait(Context context) {
        if (context == null) {
            return false;
        }
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static int getKeyBoardSize(Context context) {
        if (context != null) {
            Rect rect = OZStorage.getWindowVisibleDisplayFrame(context);
            int n = OZStorage.getScreenSize((Context)context).y - rect.bottom;
            if (n < 0) {
                n = 0;
            }
            return n;
        }
        return 0;
    }

    public static Point getScreenSize(Context context) {
        DisplayMetrics displayMetrics;
        if (context != null && (displayMetrics = OZStorage.getDisplayMetrics(context)) != null) {
            return new Point(displayMetrics.widthPixels, displayMetrics.heightPixels);
        }
        return null;
    }

    public static Rect getWindowVisibleDisplayFrame(Context context) {
        if (context != null) {
            Rect rect = new Rect();
            ((Activity)context).getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
            return rect;
        }
        return null;
    }

    public static int getStatusBarHeight(Context context) {
        if (context != null) {
            int n = 0;
            int n2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (n2 > 0) {
                n = context.getResources().getDimensionPixelSize(n2);
            }
            return n;
        }
        return 0;
    }

    public static boolean hasPermanentMenuKey(Context context) {
        if (Build.VERSION.SDK_INT <= 10) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            try {
                ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
                Method method = viewConfiguration.getClass().getMethod("hasPermanentMenuKey", new Class[0]);
                return (Boolean)method.invoke((Object)viewConfiguration, new Object[0]);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    public static boolean isSmallDevice(Context context) {
        return OZStorage.isSmallDevice(context, 550.0f);
    }

    public static boolean isSmallDevice(Context context, float f2) {
        boolean bl = OZStorage.IsDisplayLandscape(context);
        float f3 = (float)(bl ? OZStorage.getScreenSize((Context)context).y : OZStorage.getScreenSize((Context)context).x) / OZStorage.DpPerPx(context, true);
        float f4 = bl ? f2 : f2 + OZStorage.PxToDp(context, OZStorage.getStatusBarHeight(context), false);
        return f3 < f4;
    }

    public static int getLockScreenOrientation(Activity activity) {
        int n;
        int n2 = activity.getWindowManager().getDefaultDisplay().getRotation();
        Point point = OZStorage.getScreenSize((Context)activity);
        if ((n2 == 0 || n2 == 2) && point.y > point.x || (n2 == 1 || n2 == 3) && point.x > point.y) {
            switch (n2) {
                case 0: {
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 9;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                default: {
                    n = 1;
                    break;
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 9;
                    break;
                }
                case 2: {
                    n = 8;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        return n;
    }

    public static native void nativeSetAndroidApi(int var0);

    public static void refitTextView(TextView textView) {
        if (textView == null) {
            return;
        }
        int n = textView.getWidth();
        if (n == 0) {
            if (textView.getMeasuredWidth() == 0) {
                textView.measure(0, 0);
            }
            n = textView.getMeasuredWidth();
        }
        if (textView.getPaint().measureText(textView.getText().toString()) >= (float)(n - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight() - (int)(8.0f * OZStorage.getDensityDPI()))) {
            OZStorage.refitTextView(textView, textView.getText().toString(), n, 1.0f);
        }
    }

    public static void refitTextView(TextView textView, String string, int n, float f2) {
        if (n <= 0 || string == null || string.length() == 0 || textView == null || f2 < 0.0f) {
            return;
        }
        int n2 = n - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight() - (int)(8.0f * OZStorage.getDensityDPI());
        float f3 = 0.5f;
        TextPaint textPaint = textView.getPaint();
        if (textPaint == null) {
            textPaint = new Paint();
        }
        float f4 = textView.getTextSize();
        while (f4 - f2 > 0.5f) {
            float f5 = (f4 + f2) / 2.0f;
            textPaint.setTextSize(f5);
            if (textPaint.measureText(string) >= (float)n2) {
                f4 = f5;
                continue;
            }
            f2 = f5;
        }
        textView.setTextSize(0, f2);
    }

    public static Drawable getDrawableFromAssetsPath(Context context, String string) {
        Drawable drawable2 = null;
        if (context != null && string != null) {
            try {
                drawable2 = OZStorage.getDrawable(context.getResources().getAssets().open(OZStorage.getImagePath(string)));
            }
            catch (IOException iOException) {
                Log.w((String)"OZViewer", (String)String.format("Failed getDrawable from assets(%s)", string));
            }
        }
        return drawable2;
    }

    public static int getDialogSize(Context context) {
        int n = Math.min(m_width, m_height);
        if (context != null) {
            n = OZStorage.DpToPx(context, OZStorage.PxToDp(context, n, true), true, true, true);
        }
        return n;
    }

    public static void workUIThread(Runnable runnable) {
        OZStorage.workUIThread(runnable, 0L, true);
    }

    public static void workUIThread(Runnable runnable, long l, boolean bl) {
        if (runnable != null) {
            if (!OZStorage.isUIThread()) {
                OZStorage$WrapRunnable oZStorage$WrapRunnable = new OZStorage$WrapRunnable(runnable);
                if (UIThreadHandler == null || UIThreadHandler.getLooper() != Looper.getMainLooper()) {
                    UIThreadHandler = new Handler(Looper.getMainLooper());
                }
                UIThreadHandler.postDelayed((Runnable)oZStorage$WrapRunnable, l);
                if (bl) {
                    while (!oZStorage$WrapRunnable.isComplete) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
            } else {
                runnable.run();
            }
        }
    }

    public static boolean isUIThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static boolean isDeviceIncludedInModels(String[] stringArray) {
        if (stringArray != null) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!Build.MODEL.toUpperCase().startsWith(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public static void setOZButtonOnClickListener(OZButton oZButton, View.OnClickListener onClickListener) {
        if (oZButton != null) {
            boolean bl = oZButton.isClickable();
            oZButton.setOnClickListener(onClickListener);
            oZButton.setClickable(bl);
        }
    }

    public static void setOZButtonOnClickListener(OZButton oZButton, View.OnClickListener onClickListener, boolean bl) {
        if (oZButton != null) {
            oZButton.setClickable(bl);
            if (bl) {
                oZButton.setOnClickListener(onClickListener);
            }
        }
    }

    public static float getPadding(float f2) {
        return padding_1 * f2;
    }

    public static int getPaddingInt(float f2) {
        return (int)OZStorage.getPadding(f2);
    }

    public static Object executeMethod(String string, String string2, Class[] classArray, Object[] objectArray, Object object) {
        Object object2 = null;
        try {
            object2 = OZStorage.executeMethod(Class.forName(string), string2, classArray, objectArray, object);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return object2;
    }

    public static Object executeMethod(Class clazz, String string, Class[] classArray, Object[] objectArray, Object object) {
        Object object2 = null;
        try {
            object2 = clazz.getMethod(string, classArray).invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return object2;
    }

    public static Object excuteMethodIfAPILevelAndOver(int n, Class clazz, String string, Class[] classArray, Object[] objectArray, Object object) {
        Object object2 = null;
        if (OZStorage.isAPILevelAndOver(n)) {
            object2 = OZStorage.executeMethod(clazz, string, classArray, objectArray, object);
        }
        return object2;
    }

    public static boolean isAPILevelAndOver(int n) {
        return n <= Build.VERSION.SDK_INT;
    }

    public static int getBottomBarHeight(Context context) {
        Resources resources = context.getResources();
        int n = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (n > 0) {
            return resources.getDimensionPixelSize(n);
        }
        return 0;
    }

    public static String getExternalStorageDirectoryPath(Context context) {
        if (context == null) {
            Log.e((String)"OZViewer", (String)"context is null");
            return Environment.getExternalStorageDirectory().getPath();
        }
        String string = "";
        string = Build.VERSION.SDK_INT >= 29 ? context.getExternalFilesDir(null).toString() : Environment.getExternalStorageDirectory().getPath();
        return string;
    }

    public static String buildLogMsg(String string) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[4];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(stackTraceElement.getFileName());
        stringBuilder.append(" > ");
        stringBuilder.append(stackTraceElement.getMethodName());
        stringBuilder.append(" > #");
        stringBuilder.append(stackTraceElement.getLineNumber());
        stringBuilder.append("] ");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static boolean checkUsingStylusPen(MotionEvent motionEvent) {
        return motionEvent.getToolType(motionEvent.getActionIndex()) == 2;
    }

    public static float getDefaultSizeFromDPI(Context context) {
        TextView textView = new TextView(context);
        float f2 = textView.getTextSize();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        if (m_scaledDensity <= 1.5f) {
            f2 *= 1.5f;
        }
        return f2;
    }

    public static int getDefaultMarginFromDPI(Context context) {
        return OZStorage.getDefaultMarginFromDPI(context, 30);
    }

    public static int getDefaultMarginFromDPI(Context context, int n) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1, 1.0f);
        int n2 = (layoutParams.topMargin + layoutParams.bottomMargin) / 2;
        if (m_scaledDensity <= 1.5f) {
            n2 = n2 == 0 ? (n2 += (int)OZStorage.PxToDp(context, n, false)) : (int)((float)n2 * 1.5f);
        }
        return n2;
    }
}

