/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import oz.util.NListView$ListViewChangeListener;

public class NListView
extends LinearLayout {
    private static final int MAX_SIZE = 10;
    private int mSize = 0;
    private ListView[] mListViews;
    private Object mListViewLock = new Object();
    private NListView$ListViewChangeListener mListViewChange;

    public NListView(Context context) {
        super(context);
        this.initialize();
    }

    public NListView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize();
    }

    public NListView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initialize();
    }

    private void initialize() {
        this.setOrientation(0);
        this.setBackgroundColor(0);
        this.setPadding(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(int n) {
        if (n > 10) {
            n = 10;
        }
        if (n >= 0) {
            Object object = this.mListViewLock;
            synchronized (object) {
                int n2;
                ListView[] listViewArray = this.mListViews;
                ListView[] listViewArray2 = new ListView[n];
                int n3 = 0;
                if (listViewArray != null) {
                    n3 = listViewArray.length;
                    if (n3 > n) {
                        for (n2 = n3; n2 > n; --n2) {
                            this.removeView((View)listViewArray[n2 - 1]);
                            if (this.mListViewChange == null) continue;
                            this.mListViewChange.onDestroyListView(this, listViewArray[n2 - 1], n2 - 1);
                        }
                        n3 = n;
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        listViewArray2[n2] = listViewArray[n2];
                    }
                }
                if (n == 0) {
                    this.mListViews = null;
                    this.mSize = 0;
                } else {
                    if (n3 < n) {
                        for (n2 = n3; n2 < n; ++n2) {
                            listViewArray2[n2] = new ListView(this.getContext());
                            listViewArray2[n2].setVisibility(8);
                            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, 0);
                            if (this.mListViewChange != null) {
                                this.mListViewChange.onCreateListView(this, listViewArray2[n2], n2, layoutParams);
                            }
                            this.addView((View)listViewArray2[n2], (ViewGroup.LayoutParams)layoutParams);
                        }
                    }
                    this.mListViews = listViewArray2;
                    this.mSize = this.mListViews.length;
                }
            }
        }
    }

    public int getSize() {
        return this.mSize;
    }

    public ListView getListView(int n) {
        ListView listView = null;
        if (n >= 0 && this.mListViews != null && this.mListViews.length > n) {
            listView = this.mListViews[n];
        }
        return listView;
    }

    public void showListView(int n) {
        this.setVisibilityListView(n, 0);
    }

    public void hideListView(int n) {
        this.setVisibilityListView(n, 8);
    }

    public void setVisibilityListView(int n, int n2) {
        ListView listView = this.getListView(n);
        if (listView != null) {
            listView.setVisibility(n2);
        }
    }

    public void updateListView() {
        for (int j = 0; j < this.getSize(); ++j) {
            if (!(this.getListView(j).getAdapter() instanceof BaseAdapter)) continue;
            ((BaseAdapter)this.getListView(j).getAdapter()).notifyDataSetChanged();
        }
    }

    public void setListViewChangeListener(NListView$ListViewChangeListener nListView$ListViewChangeListener) {
        this.mListViewChange = nListView$ListViewChangeListener;
    }
}

