/*
 * Decompiled with CFR 0.152.
 */
package oz.util;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.MotionEvent;
import android.widget.SeekBar;

public class VerticalSeekBar
extends SeekBar {
    Paint p = new Paint(1);
    String mText;
    public int minimumValue = 0;

    public VerticalSeekBar(Context context) {
        super(context);
        this.p.setColor(-1);
        this.p.setTextSize(20.0f);
    }

    public void setMinMax(int n, int n2) {
        this.minimumValue = n;
        super.setMax(n2 - this.minimumValue);
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n2, n, n4, n3);
    }

    public void setTitleText(String string) {
        this.mText = string;
    }

    protected synchronized void onMeasure(int n, int n2) {
        super.onMeasure(n2, n);
        this.setMeasuredDimension(this.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected void onDraw(Canvas canvas) {
        canvas.rotate(-90.0f);
        canvas.translate((float)(-this.getHeight()), 0.0f);
        canvas.drawText(this.mText + "=" + (this.getProgress() + this.minimumValue), 20.0f, 20.0f, this.p);
        super.onDraw(canvas);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (motionEvent.getAction()) {
            case 0: 
            case 1: 
            case 2: {
                this.setProgress(this.getMax() - (int)((float)this.getMax() * motionEvent.getY() / (float)this.getHeight()));
                this.onSizeChanged(this.getWidth(), this.getHeight(), 0, 0);
                break;
            }
        }
        return true;
    }
}

