/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.client.android.camera;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Point;
import android.hardware.Camera;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oz.util.barcode.client.android.camera.CameraConfigurationManager$1;
import oz.util.barcode.client.android.camera.FrontLightMode;

final class CameraConfigurationManager {
    private static final String TAG = "CameraConfiguration";
    private static final int MIN_PREVIEW_PIXELS = 150400;
    private static final int MAX_PREVIEW_PIXELS = 1024000;
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;
    int m_orientation;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        int n = display.getWidth();
        int n2 = display.getHeight();
        int n3 = ((Activity)this.context).getWindowManager().getDefaultDisplay().getRotation();
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
            }
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
        this.m_orientation = (cameraInfo.orientation - n4 + 360) % 360;
        camera.setDisplayOrientation(this.m_orientation);
        this.screenResolution = new Point(n, n2);
        Log.i((String)TAG, (String)("Screen resolution: " + this.screenResolution));
        this.cameraResolution = this.findBestPreviewSizeValue(parameters, this.screenResolution);
        Log.i((String)TAG, (String)("Camera resolution: " + this.cameraResolution));
    }

    void setDesiredCameraParameters(Camera camera, boolean bl) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (bl) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        this.initializeTorch(parameters, sharedPreferences, bl);
        String string = null;
        string = bl ? CameraConfigurationManager.findSettableValue(parameters.getSupportedFocusModes(), "auto") : CameraConfigurationManager.findSettableValue(parameters.getSupportedFocusModes(), "continuous-picture", "continuous-video", "auto");
        if (!bl && string == null) {
            string = CameraConfigurationManager.findSettableValue(parameters.getSupportedFocusModes(), "macro", "edof");
        }
        if (string != null) {
            parameters.setFocusMode(string);
        }
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        camera.setParameters(parameters);
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    int getRotate() {
        return this.m_orientation;
    }

    boolean getTorchState(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String string = camera.getParameters().getFlashMode();
            return string != null && ("on".equals(string) || "torch".equals(string));
        }
        return false;
    }

    boolean isCameraFlash(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String string = camera.getParameters().getFlashMode();
            if (string == null) {
                return false;
            }
            return "on".equals(string) || "torch".equals(string) || "off".equals(string);
        }
        return false;
    }

    void setTorch(Camera camera, boolean bl) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, bl, false);
        camera.setParameters(parameters);
    }

    private void initializeTorch(Camera.Parameters parameters, SharedPreferences sharedPreferences, boolean bl) {
        boolean bl2 = FrontLightMode.readPref(sharedPreferences) == FrontLightMode.ON;
        this.doSetTorch(parameters, bl2, bl);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean bl, boolean bl2) {
        String string = bl ? CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "torch", "on") : CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "off");
        if (string != null) {
            parameters.setFlashMode(string);
        }
    }

    public Point findBestPreviewSizeValue(Camera.Parameters parameters, Point point) {
        StringBuilder stringBuilder;
        List list = parameters.getSupportedPreviewSizes();
        if (list == null) {
            Log.w((String)TAG, (String)"Device returned no supported preview sizes; using default");
            Camera.Size size = parameters.getPreviewSize();
            return new Point(size.width, size.height);
        }
        ArrayList arrayList = new ArrayList(list);
        Collections.sort(arrayList, new CameraConfigurationManager$1(this));
        if (Log.isLoggable((String)TAG, (int)4)) {
            stringBuilder = new StringBuilder();
            for (Camera.Size size : arrayList) {
                stringBuilder.append(size.width).append('x').append(size.height).append(' ');
            }
            Log.i((String)TAG, (String)("Supported preview sizes: " + stringBuilder));
        }
        stringBuilder = null;
        float f2 = (float)point.x / (float)point.y;
        float f3 = Float.POSITIVE_INFINITY;
        for (Camera.Size size : arrayList) {
            int n;
            int n2 = size.width;
            int n3 = size.height;
            int n4 = n2 * n3;
            if (n4 < 150400 || n4 > 1024000) continue;
            boolean bl = n2 < n3;
            int n5 = bl ? n3 : n2;
            int n6 = n = bl ? n2 : n3;
            if (n5 == point.x && n == point.y) {
                Point point2 = new Point(n2, n3);
                Log.i((String)TAG, (String)("Found preview size exactly matching screen size: " + point2));
                return point2;
            }
            float f4 = (float)n5 / (float)n;
            float f5 = Math.abs(f4 - f2);
            if (!(f5 < f3)) continue;
            stringBuilder = new Point(n2, n3);
            f3 = f5;
        }
        if (stringBuilder == null) {
            Camera.Size size;
            size = parameters.getPreviewSize();
            stringBuilder = new Point(size.width, size.height);
            Log.i((String)TAG, (String)("No suitable preview sizes, using default: " + stringBuilder));
        }
        Log.i((String)TAG, (String)("Found best approximate preview size: " + stringBuilder));
        return stringBuilder;
    }

    private static String findSettableValue(Collection collection, String ... stringArray) {
        Log.i((String)TAG, (String)("Supported values: " + collection));
        String string = null;
        if (collection != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (collection.contains(string2)) {
                    string = string2;
                    break;
                }
                ++n2;
            }
        }
        Log.i((String)TAG, (String)("Settable value: " + string));
        return string;
    }
}

