/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.common.reedsolomon;

import java.util.ArrayList;
import java.util.List;
import oz.util.barcode.common.reedsolomon.GenericGF;
import oz.util.barcode.common.reedsolomon.GenericGFPoly;

public final class ReedSolomonEncoder {
    private final GenericGF field;
    private final List cachedGenerators;

    public ReedSolomonEncoder(GenericGF genericGF) {
        this.field = genericGF;
        this.cachedGenerators = new ArrayList();
        this.cachedGenerators.add(new GenericGFPoly(genericGF, new int[]{1}));
    }

    private GenericGFPoly buildGenerator(int n) {
        if (n >= this.cachedGenerators.size()) {
            GenericGFPoly genericGFPoly = (GenericGFPoly)this.cachedGenerators.get(this.cachedGenerators.size() - 1);
            int n2 = this.cachedGenerators.size();
            while (n2 <= n) {
                GenericGFPoly genericGFPoly2 = genericGFPoly.multiply(new GenericGFPoly(this.field, new int[]{1, this.field.exp(n2 - 1 + this.field.getGeneratorBase())}));
                this.cachedGenerators.add(genericGFPoly2);
                genericGFPoly = genericGFPoly2;
                ++n2;
            }
        }
        return (GenericGFPoly)this.cachedGenerators.get(n);
    }

    public void encode(int[] nArray, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int n2 = nArray.length - n;
        if (n2 <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GenericGFPoly genericGFPoly = this.buildGenerator(n);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        GenericGFPoly genericGFPoly2 = new GenericGFPoly(this.field, nArray2);
        genericGFPoly2 = genericGFPoly2.multiplyByMonomial(n, 1);
        GenericGFPoly genericGFPoly3 = genericGFPoly2.divide(genericGFPoly)[1];
        int[] nArray3 = genericGFPoly3.getCoefficients();
        int n3 = n - nArray3.length;
        int n4 = 0;
        while (n4 < n3) {
            nArray[n2 + n4] = 0;
            ++n4;
        }
        System.arraycopy(nArray3, 0, nArray, n2 + n3, nArray3.length);
    }
}

