/*
 * Decompiled with CFR 0.152.
 */
package oz.util.barcode.oned;

import java.util.Map;
import oz.util.barcode.BarcodeFormat;
import oz.util.barcode.FormatException;
import oz.util.barcode.common.BitMatrix;
import oz.util.barcode.oned.EAN13Reader;
import oz.util.barcode.oned.UPCEANReader;
import oz.util.barcode.oned.UPCEANWriter;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 95;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map map) {
        if (barcodeFormat != BarcodeFormat.EAN_13) {
            throw new IllegalArgumentException("Can only encode EAN_13, but got " + (Object)((Object)barcodeFormat));
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        if (string.length() != 13) {
            throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + string.length());
        }
        try {
            if (!UPCEANReader.checkStandardUPCEANChecksum(string)) {
                throw new IllegalArgumentException("Contents do not pass checksum");
            }
        }
        catch (FormatException formatException) {
            throw new IllegalArgumentException("Illegal contents");
        }
        int n2 = Integer.parseInt(string.substring(0, 1));
        int n3 = EAN13Reader.FIRST_DIGIT_ENCODINGS[n2];
        boolean[] blArray = new boolean[95];
        int n4 = 0;
        n4 += EAN13Writer.appendPattern(blArray, n4, UPCEANReader.START_END_PATTERN, true);
        int n5 = 1;
        while (n5 <= 6) {
            n = Integer.parseInt(string.substring(n5, n5 + 1));
            if ((n3 >> 6 - n5 & 1) == 1) {
                n += 10;
            }
            n4 += EAN13Writer.appendPattern(blArray, n4, UPCEANReader.L_AND_G_PATTERNS[n], false);
            ++n5;
        }
        n4 += EAN13Writer.appendPattern(blArray, n4, UPCEANReader.MIDDLE_PATTERN, false);
        n5 = 7;
        while (n5 <= 12) {
            n = Integer.parseInt(string.substring(n5, n5 + 1));
            n4 += EAN13Writer.appendPattern(blArray, n4, UPCEANReader.L_PATTERNS[n], true);
            ++n5;
        }
        n4 += EAN13Writer.appendPattern(blArray, n4, UPCEANReader.START_END_PATTERN, true);
        return blArray;
    }
}

