/*
 * Decompiled with CFR 0.152.
 */
package oz.util.speech;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.speech.RecognitionListener;
import android.speech.tts.UtteranceProgressListener;
import oz.util.speech.OZSpeechManager;
import oz.util.speech.OZSpeechSTT;
import oz.util.speech.OZSpeechTTS;

public class OZSpeechHandler
extends Handler {
    public static final int MSG_STT_START = 1;
    public static final int MSG_STT_STOP = 2;
    public static final int MSG_TTS_START = 3;
    public static final int MSG_TTS_STOP = 4;
    public static final int MSG_STT_RESTART = 5;
    private OZSpeechManager mManager;
    private OZSpeechSTT ozSpeechSTT;
    private OZSpeechTTS ozSpeechTTS;
    private Context mContext;
    private RecognitionListener mRecognitionListener;
    private UtteranceProgressListener mUtteranceProgressListener;

    OZSpeechHandler(OZSpeechManager oZSpeechManager, Context context) {
        this.mManager = oZSpeechManager;
        this.mContext = context;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 1: {
                this.ozSpeechSTT = new OZSpeechSTT(this.mContext);
                this.ozSpeechSTT.setRecognitionListener(this.mRecognitionListener);
                this.ozSpeechSTT.startListening(this.mManager.getSTTLanguage());
                break;
            }
            case 2: {
                if (this.ozSpeechSTT == null) break;
                this.ozSpeechSTT.stopListening();
                break;
            }
            case 3: {
                this.ozSpeechTTS = new OZSpeechTTS(this.mContext);
                this.ozSpeechTTS.setOnUtteranceProgressListener(this.mUtteranceProgressListener);
                this.ozSpeechTTS.speak((String)message.obj, this.mManager.getTTSLanguage());
                break;
            }
            case 4: {
                if (this.ozSpeechTTS == null) break;
                this.ozSpeechTTS.stop();
                break;
            }
            case 5: {
                if (this.ozSpeechSTT == null) break;
                this.ozSpeechSTT.startListening(this.mManager.getSTTLanguage());
            }
        }
    }

    public void setListener(RecognitionListener recognitionListener, UtteranceProgressListener utteranceProgressListener) {
        this.mRecognitionListener = recognitionListener;
        this.mUtteranceProgressListener = utteranceProgressListener;
    }

    public OZSpeechSTT getOZSpeechSTT() {
        return this.ozSpeechSTT;
    }

    public void restartSTT() {
        this.sendEmptyMessageDelayed(5, 300L);
    }
}

