/*
 * Decompiled with CFR 0.152.
 */
package oz.util.view.camera;

import android.media.AudioAttributes;
import android.media.SoundPool;
import android.util.Log;
import oz.util.view.camera.CameraMediaActionSound$1;
import oz.util.view.camera.CameraMediaActionSound$SoundState;

public class CameraMediaActionSound {
    private static final int NUM_MEDIA_SOUND_STREAMS = 1;
    private SoundPool mSoundPool;
    private CameraMediaActionSound$SoundState[] mSounds;
    private static final String[] SOUND_DIRS = new String[]{"/product/media/audio/ui/", "/system/media/audio/ui/"};
    private static final String[] SOUND_FILES = new String[]{"camera_click.ogg", "camera_focus.ogg", "VideoRecord.ogg", "VideoStop.ogg"};
    private static final String TAG = "MediaActionSound";
    public static final int SHUTTER_CLICK = 0;
    public static final int FOCUS_COMPLETE = 1;
    public static final int START_VIDEO_RECORDING = 2;
    public static final int STOP_VIDEO_RECORDING = 3;
    private static final int STATE_NOT_LOADED = 0;
    private static final int STATE_LOADING = 1;
    private static final int STATE_LOADING_PLAY_REQUESTED = 2;
    private static final int STATE_LOADED = 3;
    private float mVolume = 0.2f;
    private SoundPool.OnLoadCompleteListener mLoadCompleteListener = new CameraMediaActionSound$1(this);

    public CameraMediaActionSound() {
        this.mSoundPool = new SoundPool.Builder().setMaxStreams(1).setAudioAttributes(new AudioAttributes.Builder().setUsage(13).setFlags(1).setContentType(4).build()).build();
        this.mSoundPool.setOnLoadCompleteListener(this.mLoadCompleteListener);
        this.mSounds = new CameraMediaActionSound$SoundState[SOUND_FILES.length];
        for (int j = 0; j < this.mSounds.length; ++j) {
            this.mSounds[j] = new CameraMediaActionSound$SoundState(this, j);
        }
    }

    public void setVolume(float f2) {
        this.mVolume = Math.max(0.0f, Math.min(1.0f, f2));
    }

    private int loadSound(CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState) {
        String string = SOUND_FILES[cameraMediaActionSound$SoundState.name];
        for (String string2 : SOUND_DIRS) {
            int n = this.mSoundPool.load(string2 + string, 1);
            if (n <= 0) continue;
            cameraMediaActionSound$SoundState.state = 1;
            cameraMediaActionSound$SoundState.id = n;
            return n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(int n) {
        CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState;
        if (n < 0 || n >= SOUND_FILES.length) {
            throw new RuntimeException("Unknown sound requested: " + n);
        }
        CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState2 = cameraMediaActionSound$SoundState = this.mSounds[n];
        synchronized (cameraMediaActionSound$SoundState2) {
            switch (cameraMediaActionSound$SoundState.state) {
                case 0: {
                    if (this.loadSound(cameraMediaActionSound$SoundState) > 0) break;
                    Log.e((String)TAG, (String)("load() error loading sound: " + n));
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("load() called in wrong state: " + cameraMediaActionSound$SoundState + " for sound: " + n));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int n) {
        CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState;
        if (n < 0 || n >= SOUND_FILES.length) {
            throw new RuntimeException("Unknown sound requested: " + n);
        }
        CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState2 = cameraMediaActionSound$SoundState = this.mSounds[n];
        synchronized (cameraMediaActionSound$SoundState2) {
            switch (cameraMediaActionSound$SoundState.state) {
                case 0: {
                    this.loadSound(cameraMediaActionSound$SoundState);
                    if (this.loadSound(cameraMediaActionSound$SoundState) <= 0) {
                        Log.e((String)TAG, (String)("play() error loading sound: " + n));
                        break;
                    }
                }
                case 1: {
                    cameraMediaActionSound$SoundState.state = 2;
                    break;
                }
                case 3: {
                    this.mSoundPool.play(cameraMediaActionSound$SoundState.id, this.mVolume, this.mVolume, 0, 0, 1.0f);
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("play() called in wrong state: " + cameraMediaActionSound$SoundState.state + " for sound: " + n));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mSoundPool != null) {
            CameraMediaActionSound$SoundState[] cameraMediaActionSound$SoundStateArray = this.mSounds;
            int n = cameraMediaActionSound$SoundStateArray.length;
            for (int j = 0; j < n; ++j) {
                CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState;
                CameraMediaActionSound$SoundState cameraMediaActionSound$SoundState2 = cameraMediaActionSound$SoundState = cameraMediaActionSound$SoundStateArray[j];
                synchronized (cameraMediaActionSound$SoundState2) {
                    cameraMediaActionSound$SoundState.state = 0;
                    cameraMediaActionSound$SoundState.id = 0;
                    continue;
                }
            }
            this.mSoundPool.release();
            this.mSoundPool = null;
        }
    }

    protected void finalize() {
        super.finalize();
        this.release();
    }

    static /* synthetic */ CameraMediaActionSound$SoundState[] access$000(CameraMediaActionSound cameraMediaActionSound) {
        return cameraMediaActionSound.mSounds;
    }

    static /* synthetic */ float access$100(CameraMediaActionSound cameraMediaActionSound) {
        return cameraMediaActionSound.mVolume;
    }
}

