/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import oz.viewer.ui.df.DFManager;
import oz.viewer.ui.df.ctrl.DFEFormBotCtrl$FromSTTInfo;

public class DFHandler
extends Handler {
    public static final int MSG_MOVE = 1;
    public static final int MSG_ARGS_MOVE_PREV = 0;
    public static final int MSG_ARGS_MOVE_NEXT = 1;
    public static final int MSG_USE_TTS = 2;
    public static final int MSG_USE_STT = 4;
    public static final int MSG_REQUEST_STT = 8;
    public static final int MSG_REQUEST_TTS = 16;
    public static final int MSG_CREATE_COMP = 17;
    public static final int MSG_REQUEST_HANDLE_DF_MSG = 18;
    public static final int MSG_CALL_EFORMBOT_RESULT = 19;
    private DFManager mManager;

    public DFHandler(DFManager dFManager) {
        super(Looper.getMainLooper());
        this.mManager = dFManager;
    }

    public void handleMessage(Message message) {
        if (this.mManager.getDialog() != null) {
            switch (message.what) {
                case 1: {
                    if (this.mManager.getConnector().getIsNotDFList()) break;
                    if (message.arg1 == 1) {
                        this.mManager.getCompCtrl().OnNextComp(message.arg2);
                        break;
                    }
                    if (message.arg1 != 0) break;
                    this.mManager.getCompCtrl().OnPrevComp(message.arg2);
                    break;
                }
                case 2: {
                    this.mManager.getSpeechCtrl().OnUseTTSChanged(message.arg1 == 1);
                    break;
                }
                case 4: {
                    this.mManager.getSpeechCtrl().OnUseSTTChanged(message.arg1 == 1);
                    break;
                }
                case 8: {
                    this.mManager.getSpeechCtrl().requestSTT();
                    break;
                }
                case 16: {
                    this.mManager.getSpeechCtrl().requestTTS((String)message.obj);
                    break;
                }
                case 17: {
                    this.mManager.getCompCtrl().createComp((String)message.obj, message.arg1 == 1, message.arg2 == 1);
                    break;
                }
                case 18: {
                    this.mManager.getConnector().callNextDFMessage();
                    break;
                }
                case 19: {
                    this.mManager.callOnResult((DFEFormBotCtrl$FromSTTInfo)message.obj);
                }
            }
        }
    }

    public boolean hasMoveRequest() {
        return this.hasMessages(1);
    }

    public void requestMoveNextComp(int n) {
        this.removeMessages(1);
        this.sendMessage(this.obtainMessage(1, 1, n));
    }

    public void requestMovePrevComp(int n) {
        this.removeMessages(1);
        this.sendMessage(this.obtainMessage(1, 0, n));
    }

    public void requestMoveNextComp(int n, int n2) {
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1, 1, n), n2);
    }

    public void requestMovePrevComp(int n, int n2) {
        this.removeMessages(1);
        this.sendMessageDelayed(this.obtainMessage(1, 0, n), n2);
    }

    public void requestUseSTTChanged(boolean bl) {
        this.removeMessages(4);
        this.sendMessage(this.obtainMessage(4, bl ? 1 : 0, 0));
    }

    public void requestUseTTSChanged(boolean bl) {
        this.removeMessages(2);
        this.sendMessage(this.obtainMessage(2, bl ? 1 : 0, 0));
    }

    public void requestSTT() {
        this.removeMessages(8);
        this.sendMessage(this.obtainMessage(8));
    }

    public void requestSTTDelay() {
        this.removeMessages(8);
        this.sendMessageDelayed(this.obtainMessage(8), 300L);
    }

    public void requestTTS(String string) {
        this.removeMessages(16);
        this.sendMessage(this.obtainMessage(16, string));
    }

    public void requestCreateComp(String string, boolean bl, boolean bl2) {
        this.removeMessages(17);
        this.sendMessage(this.obtainMessage(17, bl ? 1 : 0, bl2 ? 1 : 0, string));
    }

    public void requestTryHandleDFMessage() {
        this.removeMessages(18);
        this.sendMessage(this.obtainMessage(18));
    }
}

