/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import oz.resource.OZAndroidResource;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFCompView;
import oz.viewer.ui.df.view.DFConfirmButton;
import oz.viewer.ui.df.view.DFInputCompView$1;
import oz.viewer.ui.df.view.DFInputCompView$DFInputCompInterface;
import oz.viewer.ui.df.view.DFRoundRectFrameLayout;

public abstract class DFInputCompView
extends DFCompView {
    public static final int DP_CLEAR_BTN_S = 22;
    public static final int DP_CLEAR_BTN_M = 31;
    public static final int DP_CLEAR_BTN_L = 40;
    public static final int DP_CLEAR_BTN_MARGIN = 10;
    private boolean mValueChanged;

    public static ViewGroup createBaseInputCompRootLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return linearLayout;
    }

    public DFInputCompView(Context context, DFInputCompView$DFInputCompInterface dFInputCompView$DFInputCompInterface) {
        super(context, dFInputCompView$DFInputCompInterface);
        this.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
    }

    private DFInputCompView$DFInputCompInterface getInterface() {
        return (DFInputCompView$DFInputCompInterface)this.getDFInterface();
    }

    public void setValue(Object object, boolean bl) {
        if (!this.equalValue(object)) {
            this.setValue(object);
            this.mValueChanged |= bl;
        }
    }

    protected boolean equalValue(Object object) {
        return this.getValue() == object;
    }

    public void clearValueChanged() {
        this.mValueChanged = false;
    }

    public boolean isValueChanged() {
        return this.mValueChanged;
    }

    public void callOnValueChanged() {
        this.getInterface().OnValueChanged(this.getValue());
        this.clearValueChanged();
    }

    protected void disposeInternal(boolean bl) {
    }

    protected View createConfirmBtn(ViewGroup viewGroup) {
        String string = this.getInterface().isNotDFList() ? OZAndroidResource.getResource("dialogflow.done") : OZAndroidResource.getResource("dialogflow.ok");
        DFConfirmButton dFConfirmButton = new DFConfirmButton(this.getContext(), string);
        dFConfirmButton.setLayoutParams(this.createConfirmBtnLayoutParam(viewGroup));
        dFConfirmButton.setOnClickListener(new DFInputCompView$1(this));
        dFConfirmButton.setOnTouchListener(this.DFOnTouchListener);
        return dFConfirmButton;
    }

    public void callOnConfirm() {
        this.callOnValueChanged();
        this.getInterface().OnConfirm();
    }

    protected ViewGroup.LayoutParams createConfirmBtnLayoutParam(ViewGroup viewGroup) {
        int n = DFUtils.toDP(this.getContext(), 112.0f);
        int n2 = DFUtils.toDP(this.getContext(), 51.0f);
        int n3 = DFUtils.toDP(this.getContext(), 20.0f);
        if (viewGroup instanceof LinearLayout) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n, n2);
            layoutParams.topMargin = n3;
            return layoutParams;
        }
        return new ViewGroup.LayoutParams(n, n2);
    }

    protected DFRoundRectFrameLayout createDFRoundRectFrameLayout(int n) {
        DFRoundRectFrameLayout dFRoundRectFrameLayout = new DFRoundRectFrameLayout(this.getContext(), n);
        dFRoundRectFrameLayout.setOnTouchListener(this.DFOnTouchListener);
        return dFRoundRectFrameLayout;
    }

    protected DFRoundRectFrameLayout createDFRoundRectFrameLayout(Drawable drawable2) {
        DFRoundRectFrameLayout dFRoundRectFrameLayout = new DFRoundRectFrameLayout(this.getContext(), drawable2);
        dFRoundRectFrameLayout.setOnTouchListener(this.DFOnTouchListener);
        return dFRoundRectFrameLayout;
    }
}

