/*
 * Decompiled with CFR 0.152.
 */
package oz.viewer.ui.df.view;

import android.content.ContentValues;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.net.Uri;
import android.os.Build;
import android.util.Base64;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import oz.viewer.ui.df.DFUtils;
import oz.viewer.ui.df.view.DFInputCompView;
import oz.viewer.ui.df.view.DFInputCompVoice$1;
import oz.viewer.ui.df.view.DFInputCompVoice$2;
import oz.viewer.ui.df.view.DFInputCompVoice$3;
import oz.viewer.ui.df.view.DFInputCompVoice$4;
import oz.viewer.ui.df.view.DFInputCompVoice$5;
import oz.viewer.ui.df.view.DFInputCompVoice$6;
import oz.viewer.ui.df.view.DFInputCompVoice$DFVoiceInterface;
import oz.viewer.ui.df.view.DFInputCompVoice$TimeThread;

public class DFInputCompVoice
extends DFInputCompView {
    private static final int VOICERECORDER_MODE_NONE = 0;
    private static final int VOICERECORDER_MODE_RECORD = 1;
    private static final int VOICERECORDER_MODE_PAUSE = 2;
    private static final int VOICERECORDER_MODE_STOP = 3;
    private static final int VOICERECORDER_MODE_PLAY = 4;
    private static final int DP_MARGIN = 15;
    private static final int DP_MARGIN_BOTTOM_31 = 31;
    private static final int DP_MARGIN_BOTTOM_35 = 35;
    private static final int DP_CENTER_BUTTON_SIZE = 100;
    private static final int DP_SIDE_BUTTON_SIZE = 50;
    private static final int DP_THUMB_SIZE = 8;
    private String m_mimeType = "audio/mp4a-latm";
    private Button leftBtn;
    private Button rightBtn;
    private Button centerBtn;
    private SeekBar voiceProgress;
    private LinearLayout timeLayout;
    private TextView timeView;
    private TextView limitTimeView;
    private int currentMode;
    private int possibleMode;
    public byte[] m_data = null;
    private String centerButtonResource;
    private MediaRecorder recorder;
    private MediaPlayer player;
    boolean isStart = false;
    private int mRecordTimeLimit;
    private boolean isReadOnly;
    private DFInputCompVoice$TimeThread timeThread = null;
    private String filename;
    static ArrayList tmpFileList = new ArrayList();
    private View.OnClickListener onClickListener = new DFInputCompVoice$2(this);

    public DFInputCompVoice(Context context, DFInputCompVoice$DFVoiceInterface dFInputCompVoice$DFVoiceInterface) {
        super(context, dFInputCompVoice$DFVoiceInterface);
    }

    protected void disposeInternal(boolean bl) {
        super.disposeInternal(bl);
        if (bl) {
            this.stopPlayer();
            this.clearTempFile();
        }
    }

    private DFInputCompVoice$DFVoiceInterface getInterface() {
        return (DFInputCompVoice$DFVoiceInterface)this.getDFInterface();
    }

    protected void create(int n, int n2) {
        this.setProperty();
        this.getInterface().setStopNextSpeech(true);
        LinearLayout linearLayout = new LinearLayout(this.getContext());
        linearLayout.setOrientation(1);
        this.leftBtn = new Button(this.getContext());
        this.leftBtn.setOnClickListener(this.onClickListener);
        this.leftBtn.setGravity(17);
        this.leftBtn.setBackground(DFUtils.createVoiceButtonDrawable(this.getContext(), 17));
        this.centerBtn = new Button(this.getContext());
        this.centerBtn.setOnClickListener(this.onClickListener);
        this.centerBtn.setGravity(17);
        this.setCenterButtonResource(12);
        this.rightBtn = new Button(this.getContext());
        this.rightBtn.setOnClickListener(this.onClickListener);
        this.rightBtn.setGravity(17);
        this.rightBtn.setBackground(DFUtils.createVoiceButtonDrawable(this.getContext(), 13));
        int n3 = DFUtils.toDP(this.getContext(), 15.0f);
        int n4 = DFUtils.toDP(this.getContext(), 31.0f);
        int n5 = DFUtils.toDP(this.getContext(), 35.0f);
        int n6 = DFUtils.toDP(this.getContext(), 100.0f);
        int n7 = DFUtils.toDP(this.getContext(), 50.0f);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n6, n6);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(n7, n7);
        LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-2, -2);
        layoutParams.setMargins(n3, 0, n3, 0);
        layoutParams2.setMargins(n3, 0, n3, 0);
        layoutParams3.setMargins(0, 0, 0, n5);
        LinearLayout linearLayout2 = new LinearLayout(this.getContext());
        linearLayout2.setOrientation(0);
        linearLayout2.addView((View)this.leftBtn, (ViewGroup.LayoutParams)layoutParams2);
        linearLayout2.addView((View)this.centerBtn, (ViewGroup.LayoutParams)layoutParams);
        linearLayout2.addView((View)this.rightBtn, (ViewGroup.LayoutParams)layoutParams2);
        linearLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        int n8 = DFUtils.toDP(this.getContext(), 8.0f);
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setShape(1);
        gradientDrawable.setColor(-1);
        gradientDrawable.setSize(n8, n8);
        this.voiceProgress = new SeekBar(this.getContext());
        this.voiceProgress.setIndeterminate(false);
        this.voiceProgress.setThumb((Drawable)gradientDrawable);
        this.voiceProgress.setProgressTintList(ColorStateList.valueOf((int)-1277634344));
        this.voiceProgress.setThumbOffset(0);
        this.voiceProgress.setOnTouchListener((View.OnTouchListener)new DFInputCompVoice$1(this));
        this.voiceProgress.setProgress(0);
        this.voiceProgress.setMax(100);
        LinearLayout.LayoutParams layoutParams4 = new LinearLayout.LayoutParams(-1, -2);
        layoutParams4.setMargins(0, 0, 0, n4);
        this.voiceProgress.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        linearLayout.addView((View)linearLayout2);
        linearLayout.addView((View)this.voiceProgress);
        this.timeView = new TextView(this.getContext());
        this.limitTimeView = new TextView(this.getContext());
        this.timeView.setTextColor(-1);
        this.limitTimeView.setTextColor(-1);
        this.updateProgress(0);
        this.timeLayout = new LinearLayout(this.getContext());
        this.timeLayout.setOrientation(0);
        this.timeLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.timeLayout.setGravity(17);
        this.timeLayout.addView((View)this.timeView);
        this.timeLayout.addView((View)this.limitTimeView);
        linearLayout.addView((View)this.timeLayout);
        linearLayout.addView(this.createConfirmBtn((ViewGroup)linearLayout));
        this.addView((View)linearLayout);
        this.initViews();
    }

    private void setProperty() {
        this.filename = this.getContext().getExternalFilesDir(null).toString() + System.currentTimeMillis() + ".m4a";
        this.mRecordTimeLimit = this.getInterface().getRecordTimeLimit();
        this.isReadOnly = this.getInterface().isReadOnly();
    }

    private void initViews() {
        if (this.getInterface().getValue() != null && ((String)this.getValue()).equalsIgnoreCase("")) {
            this.possibleMode = 1;
            this.setCenterButtonResource(12);
            this.hideSideButton();
        } else {
            this.m_data = this.Base64Decode((String)this.getValue());
            this.possibleMode = 4;
            this.setCenterButtonResource(14);
            if (this.isReadOnly) {
                this.hideSideButton();
            } else {
                this.showOnlyLeftButton();
            }
            try {
                String string = this.getContext().getExternalFilesDir(null).toString() + "OZVoiceRecorder_backup.m4a";
                File file = new File(string);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(this.m_data);
                fileOutputStream.close();
                tmpFileList.add(file.getAbsolutePath());
                this.player = new MediaPlayer();
                this.player.setAudioStreamType(3);
                this.player.setDataSource(this.getContext(), Uri.fromFile((File)file));
                this.player.prepare();
                this.updateProgress(1, this.player.getDuration());
                this.player.release();
                this.player = null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.hideProgress();
    }

    private void branchCenterButton() {
        switch (this.possibleMode) {
            case 1: {
                this.performRecordBtnClick();
                break;
            }
            case 2: {
                this.performRecordPauseBtnClick();
                break;
            }
            case 4: {
                this.performPlayBtnClick();
            }
        }
    }

    private void performResetBtnClick() {
        if (this.currentMode == 4) {
            this.stopPlayer();
        }
        this.m_data = null;
        this.hideSideButton();
        this.updateProgress(0);
        this.setCenterButtonResource(12);
        this.possibleMode = 1;
        this.currentMode = 3;
    }

    private void performRecordBtnClick() {
        if (!this.isStart) {
            this.isStart = true;
            if (this.recorder == null) {
                this.recorder = new MediaRecorder();
                if (this.mRecordTimeLimit > 0) {
                    this.showProgress();
                    this.recorder.setMaxDuration(this.mRecordTimeLimit * 1000);
                } else {
                    this.voiceProgress.setVisibility(4);
                    this.timeLayout.setVisibility(0);
                    this.limitTimeView.setVisibility(8);
                    this.recorder.setMaxDuration(0);
                }
                this.timeView.setVisibility(0);
                this.timeView.setText((CharSequence)"00:00");
                this.recorder.setOnInfoListener((MediaRecorder.OnInfoListener)new DFInputCompVoice$3(this));
                this.recorder.setOnErrorListener((MediaRecorder.OnErrorListener)new DFInputCompVoice$4(this));
                ContentValues contentValues = new ContentValues(3);
                contentValues.put("title", "");
                this.recorder.setAudioSource(1);
                this.recorder.setOutputFormat(2);
                if (Build.VERSION.SDK_INT >= 10) {
                    this.recorder.setAudioEncoder(3);
                } else {
                    this.recorder.setAudioEncoder(1);
                }
                this.recorder.setOutputFile(this.filename);
                try {
                    this.recorder.prepare();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeThread = new DFInputCompVoice$TimeThread(this);
                this.recorder.start();
                this.timeThread.start();
            } else {
                this.recorderResume();
                this.timeThread.resumeTime();
            }
            if (Build.VERSION.SDK_INT < 24) {
                this.centerBtn.setVisibility(4);
            }
            this.setCenterButtonResource(15);
            this.possibleMode = 2;
            this.currentMode = 1;
            this.updateRightButton(true);
        }
    }

    private void performRecordPauseBtnClick() {
        if (this.currentMode == 1) {
            if (Build.VERSION.SDK_INT >= 24) {
                try {
                    this.recorderPause();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(300L);
                        this.recorderPause();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.isStart = false;
                this.timeThread.pauseTime();
                this.setCenterButtonResource(16);
                this.possibleMode = 1;
                this.currentMode = 2;
            }
        } else if (this.currentMode == 4) {
            this.timeThread.pauseTime();
            this.pausePlayer();
            this.setCenterButtonResource(14);
            this.possibleMode = 4;
            this.currentMode = 2;
        }
    }

    private void recorderPause() {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Method method = this.recorder.getClass().getMethod("pause", new Class[0]);
                method.invoke((Object)this.recorder, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void recorderResume() {
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                Method method = this.recorder.getClass().getMethod("resume", new Class[0]);
                method.invoke((Object)this.recorder, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void performRecordStopBtnClick() {
        if (this.currentMode == 1 || this.currentMode == 2) {
            if (this.recorder != null) {
                try {
                    this.recorder.stop();
                    this.recorder.reset();
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(300L);
                        this.recorder.stop();
                        this.recorder.reset();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.isStart = false;
                this.timeThread.end();
                this.saveVoice();
                if (Build.VERSION.SDK_INT < 24) {
                    this.centerBtn.setVisibility(0);
                }
                if (this.m_data != null) {
                    this.showOnlyLeftButton();
                    this.recorder = null;
                }
            }
            if (this.player != null) {
                this.stopPlayer();
                this.showOnlyLeftButton();
            }
        } else if (this.currentMode == 4) {
            this.stopPlayer();
            this.showOnlyLeftButton();
        }
        this.setCenterButtonResource(14);
        this.possibleMode = 4;
        this.currentMode = 3;
    }

    private void performPlayBtnClick() {
        try {
            String string = this.getContext().getExternalFilesDir(null).toString() + "OZVoiceRecorder_backup.m4a";
            File file = new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.m_data);
            fileOutputStream.close();
            tmpFileList.add(file.getAbsolutePath());
            if (this.player == null) {
                this.player = new MediaPlayer();
                this.player.setAudioStreamType(3);
                this.player.setDataSource(this.getContext(), Uri.fromFile((File)file));
                this.player.prepare();
                this.updateProgress(1, this.player.getDuration());
                this.player.start();
                this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)new DFInputCompVoice$5(this));
                this.timeThread = new DFInputCompVoice$TimeThread(this);
                this.timeThread.start();
            } else {
                this.timeThread.resumeTime();
                this.player.start();
            }
            this.showProgress();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Toast.makeText((Context)this.getContext(), (CharSequence)"voice.recorder.playerror", (int)0).show();
        }
        this.showOnlyRightButton();
        this.setCenterButtonResource(15);
        this.possibleMode = 2;
        this.currentMode = 4;
    }

    private void setCenterButtonResource(int n) {
        this.centerBtn.setBackground(DFUtils.createVoiceButtonDrawable(this.getContext(), n));
    }

    private void updateLeftButton(boolean bl) {
        if (bl) {
            this.leftBtn.setVisibility(0);
        } else {
            this.leftBtn.setVisibility(4);
        }
    }

    private void updateRightButton(boolean bl) {
        if (bl) {
            this.rightBtn.setVisibility(0);
        } else {
            this.rightBtn.setVisibility(4);
        }
    }

    private void showOnlyLeftButton() {
        this.updateLeftButton(true);
        this.updateRightButton(false);
    }

    private void showOnlyRightButton() {
        this.updateLeftButton(false);
        this.updateRightButton(true);
    }

    private void hideSideButton() {
        this.updateLeftButton(false);
        this.updateRightButton(false);
    }

    private void showProgress() {
        this.voiceProgress.setVisibility(0);
        this.timeLayout.setVisibility(0);
        this.limitTimeView.setVisibility(0);
    }

    private void hideProgress() {
        this.voiceProgress.setVisibility(4);
        this.timeLayout.setVisibility(4);
        this.limitTimeView.setVisibility(4);
    }

    private void pausePlayer() {
        if (this.player != null && this.player.isPlaying()) {
            this.player.pause();
        }
    }

    private void stopPlayer() {
        if (this.player != null) {
            if (this.player.isPlaying()) {
                this.player.stop();
            }
            this.player.release();
            this.player = null;
        }
        if (this.timeThread != null) {
            this.timeThread.end();
        }
        this.hideProgress();
    }

    public void clearTempFile() {
        if (tmpFileList != null) {
            for (int j = 0; j < tmpFileList.size(); ++j) {
                new File((String)tmpFileList.get(j)).delete();
            }
            tmpFileList.clear();
            tmpFileList = new ArrayList();
        }
    }

    public void saveVoice() {
        this.saveVoice(0);
    }

    public void saveVoice(int n) {
        if (this.isStart) {
            try {
                this.recorder.stop();
            }
            catch (Exception exception) {
                if (n < 3) {
                    this.postDelayed(new DFInputCompVoice$6(this, n), 100L);
                    return;
                }
                this.performRecordStopBtnClick();
            }
        }
        this.recorder.release();
        this.recorder = null;
        this.isStart = false;
        this.timeThread.end();
        this.hideProgress();
        try {
            this.m_data = this.getBytes(new FileInputStream(this.filename));
            new File(this.filename).delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_data = null;
            fileNotFoundException.printStackTrace();
        }
        this.postInvalidate();
    }

    private byte[] getBytes(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        byte[] byArray = new byte[10000];
        try {
            while ((n = bufferedInputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
        }
        catch (Throwable throwable) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void updateProgress(int n) {
        this.updateProgress(n, 0);
    }

    private void updateProgress(int n, int n2) {
        this.timeView.setText((CharSequence)"00:00");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("ECT"));
        if (n == 0) {
            long l = this.mRecordTimeLimit * 1000 + 1;
            this.voiceProgress.setMax((int)l);
            this.voiceProgress.setProgress(0);
            Date date = new Date(l);
            this.limitTimeView.setText((CharSequence)(" / " + (this.mRecordTimeLimit >= 3600 ? "60:00" : simpleDateFormat.format(date))));
        } else if (n == 1) {
            long l = n2 + 1;
            this.voiceProgress.setMax((int)l);
            this.voiceProgress.setProgress(0);
            Date date = new Date(l);
            this.limitTimeView.setText((CharSequence)(" / " + simpleDateFormat.format(date)));
        }
    }

    private String Base64Encode(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return "data:" + this.m_mimeType + ";base64," + Base64.encodeToString((byte[])byArray, (int)2);
    }

    private byte[] Base64Decode(String string) {
        if (string != null && !"".equals(string)) {
            if (string.startsWith("data:")) {
                int n = string.indexOf(";base64,");
                if (n > 0) {
                    this.m_mimeType = string.substring("data:".length(), n);
                    return Base64.decode((String)string.substring(n + ";base64,".length()), (int)2);
                }
            } else {
                return Base64.decode((String)string, (int)2);
            }
        }
        return null;
    }

    protected void updateSizeChanged(int n, int n2) {
    }

    protected void updateInternal(boolean bl) {
    }

    public void callOnValueChanged() {
        if (this.currentMode == 1) {
            this.saveVoice();
        }
        if (this.m_data != null) {
            this.setValue(this.Base64Encode(this.m_data));
        } else {
            this.setValue(null);
        }
        super.callOnValueChanged();
    }

    static /* synthetic */ Button access$000(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.leftBtn;
    }

    static /* synthetic */ void access$100(DFInputCompVoice dFInputCompVoice) {
        dFInputCompVoice.performResetBtnClick();
    }

    static /* synthetic */ Button access$200(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.centerBtn;
    }

    static /* synthetic */ void access$300(DFInputCompVoice dFInputCompVoice) {
        dFInputCompVoice.branchCenterButton();
    }

    static /* synthetic */ Button access$400(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.rightBtn;
    }

    static /* synthetic */ void access$500(DFInputCompVoice dFInputCompVoice) {
        dFInputCompVoice.performRecordStopBtnClick();
    }

    static /* synthetic */ void access$600(DFInputCompVoice dFInputCompVoice, int n) {
        dFInputCompVoice.setCenterButtonResource(n);
    }

    static /* synthetic */ int access$702(DFInputCompVoice dFInputCompVoice, int n) {
        dFInputCompVoice.possibleMode = n;
        return dFInputCompVoice.possibleMode;
    }

    static /* synthetic */ int access$802(DFInputCompVoice dFInputCompVoice, int n) {
        dFInputCompVoice.currentMode = n;
        return dFInputCompVoice.currentMode;
    }

    static /* synthetic */ void access$900(DFInputCompVoice dFInputCompVoice) {
        dFInputCompVoice.showOnlyLeftButton();
    }

    static /* synthetic */ DFInputCompVoice$TimeThread access$1000(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.timeThread;
    }

    static /* synthetic */ MediaPlayer access$1100(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.player;
    }

    static /* synthetic */ MediaPlayer access$1102(DFInputCompVoice dFInputCompVoice, MediaPlayer mediaPlayer) {
        dFInputCompVoice.player = mediaPlayer;
        return dFInputCompVoice.player;
    }

    static /* synthetic */ void access$1200(DFInputCompVoice dFInputCompVoice) {
        dFInputCompVoice.hideProgress();
    }

    static /* synthetic */ int access$1700(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.mRecordTimeLimit;
    }

    static /* synthetic */ SeekBar access$1800(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.voiceProgress;
    }

    static /* synthetic */ TextView access$1900(DFInputCompVoice dFInputCompVoice) {
        return dFInputCompVoice.timeView;
    }
}

